# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_hello_world.ipynb.

# %% auto 0
__all__ = ['hello_two_world', 'cli']

# %% ../nbs/01_hello_world.ipynb 6
# That export there, it makes sure this code goes into the module.

# standard libs
import os
import re

# Common to template
# add into settings.ini, requirements, package name is python-dotenv, for conda build ensure `conda config --add channels conda-forge`
import dotenv  # for loading config from .env files, https://pypi.org/project/python-dotenv/
import envyaml  # Allows to loads env vars into a yaml file, https://github.com/thesimj/envyaml
import fastcore  # To add functionality related to nbdev development, https://github.com/fastai/fastcore/
from fastcore import (
    test,
)
from fastcore.script import (
    call_parse,
)  # for @call_parse, https://fastcore.fast.ai/script
import json  # for nicely printing json and yaml
from fastcore import test

# Project specific libraries

# %% ../nbs/01_hello_world.ipynb 8
from pingme_v2 import (
    core,
)

# %% ../nbs/01_hello_world.ipynb 17
def hello_two_world(name1: str, name2: str) -> str:
    return f"Hello {name1} and {name2}!"

# %% ../nbs/01_hello_world.ipynb 19
from fastcore.script import call_parse


@call_parse
def cli(
    name: str = None,  # A name
    alternative_name: str = None,  # An alternative name
    config_file: str = None,  # config file to set env vars from
) -> None:
    """
    This will print Hello World! with your name
    """
    config = core.get_config(config_file)  # Set env vars and get config variables
    if name is not None:
        config["example"]["input"]["name"] = name
    if alternative_name is not None:
        config["example"]["input"]["alternative_name"] = alternative_name

    print(
        hello_two_world(
            config["example"]["input"]["name"],
            config["example"]["input"]["alternative_name"],
        )
    )
