# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/02_pingme_services.ipynb.

# %% auto 0
__all__ = ['NotificationService', 'pingme_send_default_card_to_webhook', 'pingme_send_simple_card_to_webhook',
           'pingme_send_card_to_webhook']

# %% ../nbs/02_pingme_services.ipynb 2
from .core import settings, logger
from .pingme_class import Card, PingMe
from fastcore.script import (
    call_parse,
)  # for @call_parse, https://fastcore.fast.ai/script

# %% ../nbs/02_pingme_services.ipynb 4
class NotificationService:
    @staticmethod
    def send_default_card_to_webhook():
        # Handles all logic for processing notifications
        logger.info("Sending default webhook card")
        card = Card.model_validate(
            {
                "name": "default",
                "context": {"title": "Default Title", "text": "Test Text"},
            }
        )
        notification = PingMe(
            card,
            config_file=settings.config_file,
        )
        response = notification.send_webhook()
        # Handle response safely
        try:
            response_data = response.json()
        except ValueError:
            # Return text content if not JSON
            response_data = {
                "content": response.text if response.text else "No content"
            }
        return {"status_code": response.status_code, "response": response_data}

    @staticmethod
    def send_simple_card_to_webhook(title: str, text: str):
        # Handles all logic for processing notifications
        logger.info("Sending simple webhook card")
        card = Card.model_validate(
            {
                "name": "default",
                "context": {"title": title, "text": text},
            }
        )
        notification = PingMe(
            card,
            config_file=settings.config_file,
        )
        response = notification.send_webhook()
        # Handle response safely
        try:
            response_data = response.json()
        except ValueError:
            # Return text content if not JSON
            response_data = {
                "content": response.text if response.text else "No content"
            }
        return {"status_code": response.status_code, "response": response_data}

    @staticmethod
    def send_card_to_webhook(card: Card):
        # Handles all logic for processing notifications
        logger.info("Sending webhook card")
        notification = PingMe(
            card,
            config_file=settings.config_file,
        )
        response = notification.send_webhook()
        # Handle response safely
        try:
            response_data = response.json()
        except ValueError:
            # Return text content if not JSON
            response_data = {
                "content": response.text if response.text else "No content"
            }
        return {"status_code": response.status_code, "response": response_data}

# %% ../nbs/02_pingme_services.ipynb 6
# Make a CLI function using `call_parse` to handle arguments
@call_parse
def pingme_send_default_card_to_webhook(
    config_file: str = None,
):
    """
    Send a card to the webhook with default values

    Args:
    - config_file: str = None: Path to the config file, none uses default
    """
    # Override settings if provided
    if config_file:
        settings.config_file = config_file
    NotificationService.send_default_card_to_webhook()

# %% ../nbs/02_pingme_services.ipynb 7
# Make a CLI function using `call_parse` to handle arguments
@call_parse
def pingme_send_simple_card_to_webhook(
    title: str,
    text: str,
    config_file: str = None,
):
    """
    Send a card to the webhook with title and text

    Args:
    - title: str: Title of the card
    - text: str: Text of the card
    - config_file: str = None: Path to the config file, none uses default
    """
    # Override settings if provided
    if config_file:
        settings.config_file = config_file
    NotificationService.send_simple_card_to_webhook(title, text)

# %% ../nbs/02_pingme_services.ipynb 8
# Make a CLI function using `call_parse` to handle arguments
@call_parse
def pingme_send_card_to_webhook(
    card: Card,
    config_file: str = None,
):
    """
    Send a card to the webhook

    Args:
    - card: Card: Card object to send
    - config_file: str = None: Path to the config file, none uses default
    """
    # Override settings if provided
    if config_file:
        settings.config_file = config_file
    NotificationService.send_card_to_webhook(card)
