# coding: utf-8

"""
    Finnhub API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from finnhub.api_client import ApiClient
from finnhub.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DefaultApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def aggregate_indicator(self, symbol, resolution, **kwargs):  # noqa: E501
        """Aggregate Indicators  # noqa: E501

        Get aggregate signal of multiple technical indicators such as MACD, RSI, Moving Average v.v.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.aggregate_indicator(symbol, resolution, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: symbol (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AggregateIndicators
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.aggregate_indicator_with_http_info(symbol, resolution, **kwargs)  # noqa: E501

    def aggregate_indicator_with_http_info(self, symbol, resolution, **kwargs):  # noqa: E501
        """Aggregate Indicators  # noqa: E501

        Get aggregate signal of multiple technical indicators such as MACD, RSI, Moving Average v.v.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.aggregate_indicator_with_http_info(symbol, resolution, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: symbol (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AggregateIndicators, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'resolution'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method aggregate_indicator" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `aggregate_indicator`")  # noqa: E501
        # verify the required parameter 'resolution' is set
        if self.api_client.client_side_validation and ('resolution' not in local_var_params or  # noqa: E501
                                                        local_var_params['resolution'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `resolution` when calling `aggregate_indicator`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'resolution' in local_var_params and local_var_params['resolution'] is not None:  # noqa: E501
            query_params.append(('resolution', local_var_params['resolution']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/scan/technical-indicator', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AggregateIndicators',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def company_basic_financials(self, symbol, metric, **kwargs):  # noqa: E501
        """Basic Financials  # noqa: E501

        Get company basic financials such as margin, P/E ratio, 52-week high/low etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_basic_financials(symbol, metric, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param str metric: Metric type. Can be 1 of the following values <code>all, price, valuation, margin</code> (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BasicFinancials
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.company_basic_financials_with_http_info(symbol, metric, **kwargs)  # noqa: E501

    def company_basic_financials_with_http_info(self, symbol, metric, **kwargs):  # noqa: E501
        """Basic Financials  # noqa: E501

        Get company basic financials such as margin, P/E ratio, 52-week high/low etc.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_basic_financials_with_http_info(symbol, metric, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param str metric: Metric type. Can be 1 of the following values <code>all, price, valuation, margin</code> (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BasicFinancials, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'metric'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method company_basic_financials" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `company_basic_financials`")  # noqa: E501
        # verify the required parameter 'metric' is set
        if self.api_client.client_side_validation and ('metric' not in local_var_params or  # noqa: E501
                                                        local_var_params['metric'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `metric` when calling `company_basic_financials`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'metric' in local_var_params and local_var_params['metric'] is not None:  # noqa: E501
            query_params.append(('metric', local_var_params['metric']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/metric', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BasicFinancials',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def company_earnings(self, symbol, **kwargs):  # noqa: E501
        """Earnings Surprises  # noqa: E501

        Get company historical quarterly earnings surprise going back to 2000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_earnings(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param int limit: Limit number of period returned. Leave blank to get the full history.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EarningResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.company_earnings_with_http_info(symbol, **kwargs)  # noqa: E501

    def company_earnings_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """Earnings Surprises  # noqa: E501

        Get company historical quarterly earnings surprise going back to 2000.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_earnings_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param int limit: Limit number of period returned. Leave blank to get the full history.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EarningResult], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method company_earnings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `company_earnings`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/earnings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EarningResult]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def company_eps_estimates(self, symbol, **kwargs):  # noqa: E501
        """Earnings Estimates  # noqa: E501

        Get company's EPS estimates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_eps_estimates(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param str freq: Can take 1 of the following values: <code>annual, quarterly</code>. Default to <code>quarterly</code>
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EarningsEstimates
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.company_eps_estimates_with_http_info(symbol, **kwargs)  # noqa: E501

    def company_eps_estimates_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """Earnings Estimates  # noqa: E501

        Get company's EPS estimates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_eps_estimates_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param str freq: Can take 1 of the following values: <code>annual, quarterly</code>. Default to <code>quarterly</code>
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EarningsEstimates, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'freq'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method company_eps_estimates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `company_eps_estimates`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'freq' in local_var_params and local_var_params['freq'] is not None:  # noqa: E501
            query_params.append(('freq', local_var_params['freq']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/eps-estimate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EarningsEstimates',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def company_executive(self, symbol, **kwargs):  # noqa: E501
        """Company Executive  # noqa: E501

        Get a list of company's executives and members of the Board.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_executive(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CompanyExecutive
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.company_executive_with_http_info(symbol, **kwargs)  # noqa: E501

    def company_executive_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """Company Executive  # noqa: E501

        Get a list of company's executives and members of the Board.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_executive_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CompanyExecutive, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method company_executive" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `company_executive`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/executive', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CompanyExecutive',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def company_news(self, symbol, _from, to, **kwargs):  # noqa: E501
        """Company News  # noqa: E501

        List latest company news by symbol. This endpoint is only available for North American companies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_news(symbol, _from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Company symbol. (required)
        :param date _from: From date <code>YYYY-MM-DD</code>. (required)
        :param date to: To date <code>YYYY-MM-DD</code>. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.company_news_with_http_info(symbol, _from, to, **kwargs)  # noqa: E501

    def company_news_with_http_info(self, symbol, _from, to, **kwargs):  # noqa: E501
        """Company News  # noqa: E501

        List latest company news by symbol. This endpoint is only available for North American companies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_news_with_http_info(symbol, _from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Company symbol. (required)
        :param date _from: From date <code>YYYY-MM-DD</code>. (required)
        :param date to: To date <code>YYYY-MM-DD</code>. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[News], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            '_from',
            'to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method company_news" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `company_news`")  # noqa: E501
        # verify the required parameter '_from' is set
        if self.api_client.client_side_validation and ('_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `_from` when calling `company_news`")  # noqa: E501
        # verify the required parameter 'to' is set
        if self.api_client.client_side_validation and ('to' not in local_var_params or  # noqa: E501
                                                        local_var_params['to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `to` when calling `company_news`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/company-news', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[News]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def company_peers(self, symbol, **kwargs):  # noqa: E501
        """Peers  # noqa: E501

        Get company peers. Return a list of peers in the same country and GICS sub-industry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_peers(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.company_peers_with_http_info(symbol, **kwargs)  # noqa: E501

    def company_peers_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """Peers  # noqa: E501

        Get company peers. Return a list of peers in the same country and GICS sub-industry  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_peers_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method company_peers" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `company_peers`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/peers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def company_profile(self, **kwargs):  # noqa: E501
        """Company Profile  # noqa: E501

        Get general information of a company. You can query by symbol, ISIN or CUSIP  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_profile(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL e.g.
        :param str isin: ISIN
        :param str cusip: CUSIP
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CompanyProfile
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.company_profile_with_http_info(**kwargs)  # noqa: E501

    def company_profile_with_http_info(self, **kwargs):  # noqa: E501
        """Company Profile  # noqa: E501

        Get general information of a company. You can query by symbol, ISIN or CUSIP  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_profile_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL e.g.
        :param str isin: ISIN
        :param str cusip: CUSIP
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CompanyProfile, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'isin',
            'cusip'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method company_profile" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'isin' in local_var_params and local_var_params['isin'] is not None:  # noqa: E501
            query_params.append(('isin', local_var_params['isin']))  # noqa: E501
        if 'cusip' in local_var_params and local_var_params['cusip'] is not None:  # noqa: E501
            query_params.append(('cusip', local_var_params['cusip']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/profile', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CompanyProfile',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def company_profile2(self, **kwargs):  # noqa: E501
        """Company Profile 2  # noqa: E501

        Get general information of a company. You can query by symbol, ISIN or CUSIP. This is the free version of <a href=\"#company-profile\">Company Profile</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_profile2(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL e.g.
        :param str isin: ISIN
        :param str cusip: CUSIP
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CompanyProfile2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.company_profile2_with_http_info(**kwargs)  # noqa: E501

    def company_profile2_with_http_info(self, **kwargs):  # noqa: E501
        """Company Profile 2  # noqa: E501

        Get general information of a company. You can query by symbol, ISIN or CUSIP. This is the free version of <a href=\"#company-profile\">Company Profile</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_profile2_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL e.g.
        :param str isin: ISIN
        :param str cusip: CUSIP
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CompanyProfile2, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'isin',
            'cusip'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method company_profile2" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'isin' in local_var_params and local_var_params['isin'] is not None:  # noqa: E501
            query_params.append(('isin', local_var_params['isin']))  # noqa: E501
        if 'cusip' in local_var_params and local_var_params['cusip'] is not None:  # noqa: E501
            query_params.append(('cusip', local_var_params['cusip']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/profile2', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CompanyProfile2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def company_revenue_estimates(self, symbol, **kwargs):  # noqa: E501
        """Revenue Estimates  # noqa: E501

        Get company's revenue estimates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_revenue_estimates(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param str freq: Can take 1 of the following values: <code>annual, quarterly</code>. Default to <code>quarterly</code>
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RevenueEstimates
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.company_revenue_estimates_with_http_info(symbol, **kwargs)  # noqa: E501

    def company_revenue_estimates_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """Revenue Estimates  # noqa: E501

        Get company's revenue estimates.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.company_revenue_estimates_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param str freq: Can take 1 of the following values: <code>annual, quarterly</code>. Default to <code>quarterly</code>
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RevenueEstimates, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'freq'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method company_revenue_estimates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `company_revenue_estimates`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'freq' in local_var_params and local_var_params['freq'] is not None:  # noqa: E501
            query_params.append(('freq', local_var_params['freq']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/revenue-estimate', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RevenueEstimates',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def country(self, **kwargs):  # noqa: E501
        """Country Metadata  # noqa: E501

        List all countries and metadata.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.country(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[CountryMetadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.country_with_http_info(**kwargs)  # noqa: E501

    def country_with_http_info(self, **kwargs):  # noqa: E501
        """Country Metadata  # noqa: E501

        List all countries and metadata.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.country_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[CountryMetadata], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method country" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/country', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CountryMetadata]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def covid19(self, **kwargs):  # noqa: E501
        """COVID-19  # noqa: E501

        Get real-time updates on the number of COVID-19 (Corona virus) cases in the US with a state-by-state breakdown. Data is sourced from CDC and reputable sources. You can also access this API <a href=\"https://rapidapi.com/Finnhub/api/finnhub-real-time-covid-19\" target=\"_blank\" rel=\"nofollow\">here</a>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.covid19(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[CovidInfo]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.covid19_with_http_info(**kwargs)  # noqa: E501

    def covid19_with_http_info(self, **kwargs):  # noqa: E501
        """COVID-19  # noqa: E501

        Get real-time updates on the number of COVID-19 (Corona virus) cases in the US with a state-by-state breakdown. Data is sourced from CDC and reputable sources. You can also access this API <a href=\"https://rapidapi.com/Finnhub/api/finnhub-real-time-covid-19\" target=\"_blank\" rel=\"nofollow\">here</a>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.covid19_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[CovidInfo], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method covid19" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/covid19/us', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CovidInfo]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def crypto_candles(self, symbol, resolution, _from, to, **kwargs):  # noqa: E501
        """Crypto Candles  # noqa: E501

        Get candlestick data for crypto symbols.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_candles(symbol, resolution, _from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Use symbol returned in <code>/crypto/symbol</code> endpoint for this field. (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param int _from: UNIX timestamp. Interval initial value. (required)
        :param int to: UNIX timestamp. Interval end value. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CryptoCandles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.crypto_candles_with_http_info(symbol, resolution, _from, to, **kwargs)  # noqa: E501

    def crypto_candles_with_http_info(self, symbol, resolution, _from, to, **kwargs):  # noqa: E501
        """Crypto Candles  # noqa: E501

        Get candlestick data for crypto symbols.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_candles_with_http_info(symbol, resolution, _from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Use symbol returned in <code>/crypto/symbol</code> endpoint for this field. (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param int _from: UNIX timestamp. Interval initial value. (required)
        :param int to: UNIX timestamp. Interval end value. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CryptoCandles, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'resolution',
            '_from',
            'to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crypto_candles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `crypto_candles`")  # noqa: E501
        # verify the required parameter 'resolution' is set
        if self.api_client.client_side_validation and ('resolution' not in local_var_params or  # noqa: E501
                                                        local_var_params['resolution'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `resolution` when calling `crypto_candles`")  # noqa: E501
        # verify the required parameter '_from' is set
        if self.api_client.client_side_validation and ('_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `_from` when calling `crypto_candles`")  # noqa: E501
        # verify the required parameter 'to' is set
        if self.api_client.client_side_validation and ('to' not in local_var_params or  # noqa: E501
                                                        local_var_params['to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `to` when calling `crypto_candles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'resolution' in local_var_params and local_var_params['resolution'] is not None:  # noqa: E501
            query_params.append(('resolution', local_var_params['resolution']))  # noqa: E501
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/candle', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CryptoCandles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def crypto_exchanges(self, **kwargs):  # noqa: E501
        """Crypto Exchanges  # noqa: E501

        List supported crypto exchanges  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_exchanges(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.crypto_exchanges_with_http_info(**kwargs)  # noqa: E501

    def crypto_exchanges_with_http_info(self, **kwargs):  # noqa: E501
        """Crypto Exchanges  # noqa: E501

        List supported crypto exchanges  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_exchanges_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crypto_exchanges" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/exchange', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def crypto_symbols(self, exchange, **kwargs):  # noqa: E501
        """Crypto Symbol  # noqa: E501

        List supported crypto symbols by exchange  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_symbols(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange: Exchange you want to get the list of symbols from. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[CryptoSymbol]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.crypto_symbols_with_http_info(exchange, **kwargs)  # noqa: E501

    def crypto_symbols_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """Crypto Symbol  # noqa: E501

        List supported crypto symbols by exchange  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.crypto_symbols_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange: Exchange you want to get the list of symbols from. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[CryptoSymbol], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'exchange'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method crypto_symbols" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and ('exchange' not in local_var_params or  # noqa: E501
                                                        local_var_params['exchange'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `crypto_symbols`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'exchange' in local_var_params and local_var_params['exchange'] is not None:  # noqa: E501
            query_params.append(('exchange', local_var_params['exchange']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/crypto/symbol', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CryptoSymbol]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def earnings_calendar(self, **kwargs):  # noqa: E501
        """Earnings Calendar  # noqa: E501

        Get historical and coming earnings release dating back to 2003. You can setup <a href=\"#webhook\">webhook</a> to receive real-time earnings update.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.earnings_calendar(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param date _from: From date: 2020-03-15.
        :param date to: To date: 2020-03-16.
        :param str symbol: Filter by symbol: AAPL.
        :param object international: Set to <code>true</code> to include international markets. Default value is <code>false</code>
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EarningsCalendar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.earnings_calendar_with_http_info(**kwargs)  # noqa: E501

    def earnings_calendar_with_http_info(self, **kwargs):  # noqa: E501
        """Earnings Calendar  # noqa: E501

        Get historical and coming earnings release dating back to 2003. You can setup <a href=\"#webhook\">webhook</a> to receive real-time earnings update.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.earnings_calendar_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param date _from: From date: 2020-03-15.
        :param date to: To date: 2020-03-16.
        :param str symbol: Filter by symbol: AAPL.
        :param object international: Set to <code>true</code> to include international markets. Default value is <code>false</code>
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EarningsCalendar, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            '_from',
            'to',
            'symbol',
            'international'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method earnings_calendar" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'international' in local_var_params and local_var_params['international'] is not None:  # noqa: E501
            query_params.append(('international', local_var_params['international']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/calendar/earnings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EarningsCalendar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def economic_code(self, **kwargs):  # noqa: E501
        """Economic Code  # noqa: E501

        List codes of supported economic data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.economic_code(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[EconomicCode]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.economic_code_with_http_info(**kwargs)  # noqa: E501

    def economic_code_with_http_info(self, **kwargs):  # noqa: E501
        """Economic Code  # noqa: E501

        List codes of supported economic data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.economic_code_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[EconomicCode], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method economic_code" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/economic/code', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[EconomicCode]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def economic_data(self, code, **kwargs):  # noqa: E501
        """Economic Data  # noqa: E501

        Get economic data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.economic_data(code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str code: Economic code. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EconomicData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.economic_data_with_http_info(code, **kwargs)  # noqa: E501

    def economic_data_with_http_info(self, code, **kwargs):  # noqa: E501
        """Economic Data  # noqa: E501

        Get economic data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.economic_data_with_http_info(code, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str code: Economic code. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EconomicData, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'code'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method economic_data" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'code' is set
        if self.api_client.client_side_validation and ('code' not in local_var_params or  # noqa: E501
                                                        local_var_params['code'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `code` when calling `economic_data`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'code' in local_var_params and local_var_params['code'] is not None:  # noqa: E501
            query_params.append(('code', local_var_params['code']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/economic', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EconomicData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def filings(self, **kwargs):  # noqa: E501
        """Filings  # noqa: E501

        List company's filing. Limit to 250 documents at a time. This data is available for bulk download on <a href=\"https://www.kaggle.com/finnhub/sec-filings\" target=\"_blank\">Kaggle SEC Filings database</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filings(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol. Leave <code>symbol</code>,<code>cik</code> and <code>accessNumber</code> empty to list latest filings.
        :param str cik: CIK.
        :param str access_number: Access number of a specific report you want to retrieve data from.
        :param str form: Filter by form. You can use this value <code>NT 10-K</code> to find non-timely filings for a company.
        :param date _from: From date: 2020-03-15.
        :param date to: To date: 2020-03-16.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Filing]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.filings_with_http_info(**kwargs)  # noqa: E501

    def filings_with_http_info(self, **kwargs):  # noqa: E501
        """Filings  # noqa: E501

        List company's filing. Limit to 250 documents at a time. This data is available for bulk download on <a href=\"https://www.kaggle.com/finnhub/sec-filings\" target=\"_blank\">Kaggle SEC Filings database</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.filings_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol. Leave <code>symbol</code>,<code>cik</code> and <code>accessNumber</code> empty to list latest filings.
        :param str cik: CIK.
        :param str access_number: Access number of a specific report you want to retrieve data from.
        :param str form: Filter by form. You can use this value <code>NT 10-K</code> to find non-timely filings for a company.
        :param date _from: From date: 2020-03-15.
        :param date to: To date: 2020-03-16.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Filing], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'cik',
            'access_number',
            'form',
            '_from',
            'to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method filings" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'cik' in local_var_params and local_var_params['cik'] is not None:  # noqa: E501
            query_params.append(('cik', local_var_params['cik']))  # noqa: E501
        if 'access_number' in local_var_params and local_var_params['access_number'] is not None:  # noqa: E501
            query_params.append(('accessNumber', local_var_params['access_number']))  # noqa: E501
        if 'form' in local_var_params and local_var_params['form'] is not None:  # noqa: E501
            query_params.append(('form', local_var_params['form']))  # noqa: E501
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/filings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Filing]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def financials(self, symbol, statement, freq, **kwargs):  # noqa: E501
        """Financial Statements  # noqa: E501

        Get standardized balance sheet, income statement and cash flow for global companies going back 30+ years.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.financials(symbol, statement, freq, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param str statement: Statement can take 1 of these values <code>bs, ic, cf</code> for Balance Sheet, Income Statement, Cash Flow respectively. (required)
        :param str freq: Frequency can take 1 of these values <code>annual, quarterly, ttm, ytd</code>.  TTM (Trailing Twelve Months) option is available for Income Statement and Cash Flow. YTD (Year To Date) option is only available for Cash Flow. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FinancialStatements
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.financials_with_http_info(symbol, statement, freq, **kwargs)  # noqa: E501

    def financials_with_http_info(self, symbol, statement, freq, **kwargs):  # noqa: E501
        """Financial Statements  # noqa: E501

        Get standardized balance sheet, income statement and cash flow for global companies going back 30+ years.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.financials_with_http_info(symbol, statement, freq, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param str statement: Statement can take 1 of these values <code>bs, ic, cf</code> for Balance Sheet, Income Statement, Cash Flow respectively. (required)
        :param str freq: Frequency can take 1 of these values <code>annual, quarterly, ttm, ytd</code>.  TTM (Trailing Twelve Months) option is available for Income Statement and Cash Flow. YTD (Year To Date) option is only available for Cash Flow. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FinancialStatements, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'statement',
            'freq'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method financials" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `financials`")  # noqa: E501
        # verify the required parameter 'statement' is set
        if self.api_client.client_side_validation and ('statement' not in local_var_params or  # noqa: E501
                                                        local_var_params['statement'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `statement` when calling `financials`")  # noqa: E501
        # verify the required parameter 'freq' is set
        if self.api_client.client_side_validation and ('freq' not in local_var_params or  # noqa: E501
                                                        local_var_params['freq'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `freq` when calling `financials`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'statement' in local_var_params and local_var_params['statement'] is not None:  # noqa: E501
            query_params.append(('statement', local_var_params['statement']))  # noqa: E501
        if 'freq' in local_var_params and local_var_params['freq'] is not None:  # noqa: E501
            query_params.append(('freq', local_var_params['freq']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/financials', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FinancialStatements',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def financials_reported(self, **kwargs):  # noqa: E501
        """Financials As Reported  # noqa: E501

        Get financials as reported. This data is available for bulk download on <a href=\"https://www.kaggle.com/finnhub/reported-financials\" target=\"_blank\">Kaggle SEC Financials database</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.financials_reported(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol.
        :param str cik: CIK.
        :param str access_number: Access number of a specific report you want to retrieve financials from.
        :param str freq: Frequency. Can be either <code>annual</code> or <code>quarterly</code>. Default to <code>annual</code>.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FinancialsAsReported
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.financials_reported_with_http_info(**kwargs)  # noqa: E501

    def financials_reported_with_http_info(self, **kwargs):  # noqa: E501
        """Financials As Reported  # noqa: E501

        Get financials as reported. This data is available for bulk download on <a href=\"https://www.kaggle.com/finnhub/reported-financials\" target=\"_blank\">Kaggle SEC Financials database</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.financials_reported_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol.
        :param str cik: CIK.
        :param str access_number: Access number of a specific report you want to retrieve financials from.
        :param str freq: Frequency. Can be either <code>annual</code> or <code>quarterly</code>. Default to <code>annual</code>.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FinancialsAsReported, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'cik',
            'access_number',
            'freq'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method financials_reported" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'cik' in local_var_params and local_var_params['cik'] is not None:  # noqa: E501
            query_params.append(('cik', local_var_params['cik']))  # noqa: E501
        if 'access_number' in local_var_params and local_var_params['access_number'] is not None:  # noqa: E501
            query_params.append(('accessNumber', local_var_params['access_number']))  # noqa: E501
        if 'freq' in local_var_params and local_var_params['freq'] is not None:  # noqa: E501
            query_params.append(('freq', local_var_params['freq']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/financials-reported', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FinancialsAsReported',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def forex_candles(self, symbol, resolution, _from, to, **kwargs):  # noqa: E501
        """Forex Candles  # noqa: E501

        Get candlestick data for forex symbols.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.forex_candles(symbol, resolution, _from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Use symbol returned in <code>/forex/symbol</code> endpoint for this field. (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param int _from: UNIX timestamp. Interval initial value. (required)
        :param int to: UNIX timestamp. Interval end value. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ForexCandles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.forex_candles_with_http_info(symbol, resolution, _from, to, **kwargs)  # noqa: E501

    def forex_candles_with_http_info(self, symbol, resolution, _from, to, **kwargs):  # noqa: E501
        """Forex Candles  # noqa: E501

        Get candlestick data for forex symbols.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.forex_candles_with_http_info(symbol, resolution, _from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Use symbol returned in <code>/forex/symbol</code> endpoint for this field. (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param int _from: UNIX timestamp. Interval initial value. (required)
        :param int to: UNIX timestamp. Interval end value. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ForexCandles, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'resolution',
            '_from',
            'to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method forex_candles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `forex_candles`")  # noqa: E501
        # verify the required parameter 'resolution' is set
        if self.api_client.client_side_validation and ('resolution' not in local_var_params or  # noqa: E501
                                                        local_var_params['resolution'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `resolution` when calling `forex_candles`")  # noqa: E501
        # verify the required parameter '_from' is set
        if self.api_client.client_side_validation and ('_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `_from` when calling `forex_candles`")  # noqa: E501
        # verify the required parameter 'to' is set
        if self.api_client.client_side_validation and ('to' not in local_var_params or  # noqa: E501
                                                        local_var_params['to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `to` when calling `forex_candles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'resolution' in local_var_params and local_var_params['resolution'] is not None:  # noqa: E501
            query_params.append(('resolution', local_var_params['resolution']))  # noqa: E501
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/forex/candle', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ForexCandles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def forex_exchanges(self, **kwargs):  # noqa: E501
        """Forex Exchanges  # noqa: E501

        List supported forex exchanges  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.forex_exchanges(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.forex_exchanges_with_http_info(**kwargs)  # noqa: E501

    def forex_exchanges_with_http_info(self, **kwargs):  # noqa: E501
        """Forex Exchanges  # noqa: E501

        List supported forex exchanges  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.forex_exchanges_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[str], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method forex_exchanges" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/forex/exchange', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def forex_rates(self, **kwargs):  # noqa: E501
        """Forex rates  # noqa: E501

        Get rates for all forex pairs. Ideal for currency conversion  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.forex_rates(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str base: Base currency. Default to EUR.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Forexrates
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.forex_rates_with_http_info(**kwargs)  # noqa: E501

    def forex_rates_with_http_info(self, **kwargs):  # noqa: E501
        """Forex rates  # noqa: E501

        Get rates for all forex pairs. Ideal for currency conversion  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.forex_rates_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str base: Base currency. Default to EUR.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Forexrates, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'base'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method forex_rates" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'base' in local_var_params and local_var_params['base'] is not None:  # noqa: E501
            query_params.append(('base', local_var_params['base']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/forex/rates', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Forexrates',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def forex_symbols(self, exchange, **kwargs):  # noqa: E501
        """Forex Symbol  # noqa: E501

        List supported forex symbols.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.forex_symbols(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange: Exchange you want to get the list of symbols from. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[ForexSymbol]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.forex_symbols_with_http_info(exchange, **kwargs)  # noqa: E501

    def forex_symbols_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """Forex Symbol  # noqa: E501

        List supported forex symbols.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.forex_symbols_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange: Exchange you want to get the list of symbols from. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[ForexSymbol], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'exchange'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method forex_symbols" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and ('exchange' not in local_var_params or  # noqa: E501
                                                        local_var_params['exchange'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `forex_symbols`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'exchange' in local_var_params and local_var_params['exchange'] is not None:  # noqa: E501
            query_params.append(('exchange', local_var_params['exchange']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/forex/symbol', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ForexSymbol]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def fund_ownership(self, symbol, **kwargs):  # noqa: E501
        """Fund Ownership  # noqa: E501

        Get a full list fund and institutional investors of a company in descending order of the number of shares held.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fund_ownership(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param int limit: Limit number of results. Leave empty to get the full list.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FundOwnership
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.fund_ownership_with_http_info(symbol, **kwargs)  # noqa: E501

    def fund_ownership_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """Fund Ownership  # noqa: E501

        Get a full list fund and institutional investors of a company in descending order of the number of shares held.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.fund_ownership_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param int limit: Limit number of results. Leave empty to get the full list.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FundOwnership, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method fund_ownership" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `fund_ownership`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/fund-ownership', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='FundOwnership',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def general_news(self, category, **kwargs):  # noqa: E501
        """General News  # noqa: E501

        Get latest market news.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.general_news(category, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str category: This parameter can be 1 of the following values <code>general, forex, crypto, merger</code>. (required)
        :param str min_id: Use this field to get only news after this ID. Default to 0
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[News]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.general_news_with_http_info(category, **kwargs)  # noqa: E501

    def general_news_with_http_info(self, category, **kwargs):  # noqa: E501
        """General News  # noqa: E501

        Get latest market news.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.general_news_with_http_info(category, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str category: This parameter can be 1 of the following values <code>general, forex, crypto, merger</code>. (required)
        :param str min_id: Use this field to get only news after this ID. Default to 0
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[News], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'category',
            'min_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method general_news" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'category' is set
        if self.api_client.client_side_validation and ('category' not in local_var_params or  # noqa: E501
                                                        local_var_params['category'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `category` when calling `general_news`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'category' in local_var_params and local_var_params['category'] is not None:  # noqa: E501
            query_params.append(('category', local_var_params['category']))  # noqa: E501
        if 'min_id' in local_var_params and local_var_params['min_id'] is not None:  # noqa: E501
            query_params.append(('minId', local_var_params['min_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/news', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[News]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def investors_ownership(self, symbol, **kwargs):  # noqa: E501
        """Investors Ownership  # noqa: E501

        Get a full list of shareholders/investors of a company in descending order of the number of shares held.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.investors_ownership(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param int limit: Limit number of results. Leave empty to get the full list.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InvestorsOwnership
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.investors_ownership_with_http_info(symbol, **kwargs)  # noqa: E501

    def investors_ownership_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """Investors Ownership  # noqa: E501

        Get a full list of shareholders/investors of a company in descending order of the number of shares held.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.investors_ownership_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param int limit: Limit number of results. Leave empty to get the full list.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InvestorsOwnership, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method investors_ownership" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `investors_ownership`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/investor-ownership', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InvestorsOwnership',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ipo_calendar(self, _from, to, **kwargs):  # noqa: E501
        """IPO Calendar  # noqa: E501

        Get recent and coming IPO.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ipo_calendar(_from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param date _from: From date: 2020-03-15. (required)
        :param date to: To date: 2020-03-16. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: IPOCalendar
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.ipo_calendar_with_http_info(_from, to, **kwargs)  # noqa: E501

    def ipo_calendar_with_http_info(self, _from, to, **kwargs):  # noqa: E501
        """IPO Calendar  # noqa: E501

        Get recent and coming IPO.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ipo_calendar_with_http_info(_from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param date _from: From date: 2020-03-15. (required)
        :param date to: To date: 2020-03-16. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(IPOCalendar, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            '_from',
            'to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ipo_calendar" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter '_from' is set
        if self.api_client.client_side_validation and ('_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `_from` when calling `ipo_calendar`")  # noqa: E501
        # verify the required parameter 'to' is set
        if self.api_client.client_side_validation and ('to' not in local_var_params or  # noqa: E501
                                                        local_var_params['to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `to` when calling `ipo_calendar`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/calendar/ipo', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IPOCalendar',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def major_developments(self, symbol, **kwargs):  # noqa: E501
        """Major Developments  # noqa: E501

        List latest major developments of a company going back 20 years with 12M+ data points. This data can be used to highlight the most significant events.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.major_developments(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Company symbol. (required)
        :param date _from: From time: 2020-01-01.
        :param date to: To time: 2020-01-05.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: MajorDevelopments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.major_developments_with_http_info(symbol, **kwargs)  # noqa: E501

    def major_developments_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """Major Developments  # noqa: E501

        List latest major developments of a company going back 20 years with 12M+ data points. This data can be used to highlight the most significant events.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.major_developments_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Company symbol. (required)
        :param date _from: From time: 2020-01-01.
        :param date to: To time: 2020-01-05.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(MajorDevelopments, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            '_from',
            'to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method major_developments" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `major_developments`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/major-development', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MajorDevelopments',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def news_sentiment(self, symbol, **kwargs):  # noqa: E501
        """News Sentiment  # noqa: E501

        Get company's news sentiment and statistics. This endpoint is only available for US companies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.news_sentiment(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Company symbol. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: NewsSentiment
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.news_sentiment_with_http_info(symbol, **kwargs)  # noqa: E501

    def news_sentiment_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """News Sentiment  # noqa: E501

        Get company's news sentiment and statistics. This endpoint is only available for US companies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.news_sentiment_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Company symbol. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(NewsSentiment, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method news_sentiment" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `news_sentiment`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/news-sentiment', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='NewsSentiment',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def pattern_recognition(self, symbol, resolution, **kwargs):  # noqa: E501
        """Pattern Recognition  # noqa: E501

        Run pattern recognition algorithm on a symbol. Support double top/bottom, triple top/bottom, head and shoulders, triangle, wedge, channel, flag, and candlestick patterns.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pattern_recognition(symbol, resolution, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PatternRecognition
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.pattern_recognition_with_http_info(symbol, resolution, **kwargs)  # noqa: E501

    def pattern_recognition_with_http_info(self, symbol, resolution, **kwargs):  # noqa: E501
        """Pattern Recognition  # noqa: E501

        Run pattern recognition algorithm on a symbol. Support double top/bottom, triple top/bottom, head and shoulders, triangle, wedge, channel, flag, and candlestick patterns.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.pattern_recognition_with_http_info(symbol, resolution, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PatternRecognition, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'resolution'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method pattern_recognition" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `pattern_recognition`")  # noqa: E501
        # verify the required parameter 'resolution' is set
        if self.api_client.client_side_validation and ('resolution' not in local_var_params or  # noqa: E501
                                                        local_var_params['resolution'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `resolution` when calling `pattern_recognition`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'resolution' in local_var_params and local_var_params['resolution'] is not None:  # noqa: E501
            query_params.append(('resolution', local_var_params['resolution']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/scan/pattern', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PatternRecognition',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def price_target(self, symbol, **kwargs):  # noqa: E501
        """Price Target  # noqa: E501

        Get latest price target consensus.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.price_target(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PriceTarget
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.price_target_with_http_info(symbol, **kwargs)  # noqa: E501

    def price_target_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """Price Target  # noqa: E501

        Get latest price target consensus.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.price_target_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PriceTarget, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method price_target" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `price_target`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/price-target', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PriceTarget',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def quote(self, symbol, **kwargs):  # noqa: E501
        """Quote  # noqa: E501

        <p>Get real-time quote data for US stocks. Constant polling is not recommended. Use websocket if you need real-time update.</p><p>Real-time stock prices for international markets are supported for Enterprise clients via our partner's feed. <a href=\"mailto:support@finnhub.io\">Contact Us</a> to learn more.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.quote(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Quote
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.quote_with_http_info(symbol, **kwargs)  # noqa: E501

    def quote_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """Quote  # noqa: E501

        <p>Get real-time quote data for US stocks. Constant polling is not recommended. Use websocket if you need real-time update.</p><p>Real-time stock prices for international markets are supported for Enterprise clients via our partner's feed. <a href=\"mailto:support@finnhub.io\">Contact Us</a> to learn more.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.quote_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Quote, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method quote" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `quote`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/quote', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Quote',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def recommendation_trends(self, symbol, **kwargs):  # noqa: E501
        """Recommendation Trends  # noqa: E501

        Get latest analyst recommendation trends for a company.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.recommendation_trends(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[RecommendationTrend]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.recommendation_trends_with_http_info(symbol, **kwargs)  # noqa: E501

    def recommendation_trends_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """Recommendation Trends  # noqa: E501

        Get latest analyst recommendation trends for a company.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.recommendation_trends_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[RecommendationTrend], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method recommendation_trends" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `recommendation_trends`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/recommendation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[RecommendationTrend]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stock_bidask(self, symbol, **kwargs):  # noqa: E501
        """Last Bid-Ask  # noqa: E501

        Get last bid/ask data for US stocks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stock_bidask(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: LastBidAsk
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.stock_bidask_with_http_info(symbol, **kwargs)  # noqa: E501

    def stock_bidask_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """Last Bid-Ask  # noqa: E501

        Get last bid/ask data for US stocks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stock_bidask_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(LastBidAsk, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stock_bidask" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `stock_bidask`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/bidask', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='LastBidAsk',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stock_candles(self, symbol, resolution, _from, to, **kwargs):  # noqa: E501
        """Stock Candles  # noqa: E501

        <p>Get candlestick data for stocks going back 25 years for US stocks.</p><p>Real-time stock prices for international markets are supported for Enterprise clients via our partner's feed. <a href=\"mailto:support@finnhub.io\">Contact Us</a> to learn more.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stock_candles(symbol, resolution, _from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol. (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param int _from: UNIX timestamp. Interval initial value. (required)
        :param int to: UNIX timestamp. Interval end value. (required)
        :param str adjusted: By default, <code>adjusted=false</code>. Use <code>true</code> to get adjusted data.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StockCandles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.stock_candles_with_http_info(symbol, resolution, _from, to, **kwargs)  # noqa: E501

    def stock_candles_with_http_info(self, symbol, resolution, _from, to, **kwargs):  # noqa: E501
        """Stock Candles  # noqa: E501

        <p>Get candlestick data for stocks going back 25 years for US stocks.</p><p>Real-time stock prices for international markets are supported for Enterprise clients via our partner's feed. <a href=\"mailto:support@finnhub.io\">Contact Us</a> to learn more.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stock_candles_with_http_info(symbol, resolution, _from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol. (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param int _from: UNIX timestamp. Interval initial value. (required)
        :param int to: UNIX timestamp. Interval end value. (required)
        :param str adjusted: By default, <code>adjusted=false</code>. Use <code>true</code> to get adjusted data.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StockCandles, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'resolution',
            '_from',
            'to',
            'adjusted'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stock_candles" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `stock_candles`")  # noqa: E501
        # verify the required parameter 'resolution' is set
        if self.api_client.client_side_validation and ('resolution' not in local_var_params or  # noqa: E501
                                                        local_var_params['resolution'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `resolution` when calling `stock_candles`")  # noqa: E501
        # verify the required parameter '_from' is set
        if self.api_client.client_side_validation and ('_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `_from` when calling `stock_candles`")  # noqa: E501
        # verify the required parameter 'to' is set
        if self.api_client.client_side_validation and ('to' not in local_var_params or  # noqa: E501
                                                        local_var_params['to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `to` when calling `stock_candles`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'resolution' in local_var_params and local_var_params['resolution'] is not None:  # noqa: E501
            query_params.append(('resolution', local_var_params['resolution']))  # noqa: E501
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501
        if 'adjusted' in local_var_params and local_var_params['adjusted'] is not None:  # noqa: E501
            query_params.append(('adjusted', local_var_params['adjusted']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/candle', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StockCandles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stock_dividends(self, symbol, _from, to, **kwargs):  # noqa: E501
        """Dividends  # noqa: E501

        Get dividends data for common stocks going back 30 years.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stock_dividends(symbol, _from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol. (required)
        :param date _from: YYYY-MM-DD. (required)
        :param date to: YYYY-MM-DD. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Dividends]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.stock_dividends_with_http_info(symbol, _from, to, **kwargs)  # noqa: E501

    def stock_dividends_with_http_info(self, symbol, _from, to, **kwargs):  # noqa: E501
        """Dividends  # noqa: E501

        Get dividends data for common stocks going back 30 years.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stock_dividends_with_http_info(symbol, _from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol. (required)
        :param date _from: YYYY-MM-DD. (required)
        :param date to: YYYY-MM-DD. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Dividends], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            '_from',
            'to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stock_dividends" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `stock_dividends`")  # noqa: E501
        # verify the required parameter '_from' is set
        if self.api_client.client_side_validation and ('_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `_from` when calling `stock_dividends`")  # noqa: E501
        # verify the required parameter 'to' is set
        if self.api_client.client_side_validation and ('to' not in local_var_params or  # noqa: E501
                                                        local_var_params['to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `to` when calling `stock_dividends`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/dividend', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Dividends]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stock_splits(self, symbol, _from, to, **kwargs):  # noqa: E501
        """Splits  # noqa: E501

        Get splits data for stocks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stock_splits(symbol, _from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol. (required)
        :param date _from: YYYY-MM-DD. (required)
        :param date to: YYYY-MM-DD. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Split]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.stock_splits_with_http_info(symbol, _from, to, **kwargs)  # noqa: E501

    def stock_splits_with_http_info(self, symbol, _from, to, **kwargs):  # noqa: E501
        """Splits  # noqa: E501

        Get splits data for stocks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stock_splits_with_http_info(symbol, _from, to, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol. (required)
        :param date _from: YYYY-MM-DD. (required)
        :param date to: YYYY-MM-DD. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Split], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            '_from',
            'to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stock_splits" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `stock_splits`")  # noqa: E501
        # verify the required parameter '_from' is set
        if self.api_client.client_side_validation and ('_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `_from` when calling `stock_splits`")  # noqa: E501
        # verify the required parameter 'to' is set
        if self.api_client.client_side_validation and ('to' not in local_var_params or  # noqa: E501
                                                        local_var_params['to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `to` when calling `stock_splits`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/split', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Split]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stock_symbols(self, exchange, **kwargs):  # noqa: E501
        """Stock Symbol  # noqa: E501

        List supported stocks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stock_symbols(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange: Exchange you want to get the list of symbols from. List of exchanges with fundamental data can be found <a href=\"https://docs.google.com/spreadsheets/d/1I3pBxjfXB056-g_JYf_6o3Rns3BV2kMGG1nCatb91ls/edit?usp=sharing\" target=\"_blank\">here</a>. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[Stock]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.stock_symbols_with_http_info(exchange, **kwargs)  # noqa: E501

    def stock_symbols_with_http_info(self, exchange, **kwargs):  # noqa: E501
        """Stock Symbol  # noqa: E501

        List supported stocks.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stock_symbols_with_http_info(exchange, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str exchange: Exchange you want to get the list of symbols from. List of exchanges with fundamental data can be found <a href=\"https://docs.google.com/spreadsheets/d/1I3pBxjfXB056-g_JYf_6o3Rns3BV2kMGG1nCatb91ls/edit?usp=sharing\" target=\"_blank\">here</a>. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[Stock], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'exchange'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stock_symbols" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'exchange' is set
        if self.api_client.client_side_validation and ('exchange' not in local_var_params or  # noqa: E501
                                                        local_var_params['exchange'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `exchange` when calling `stock_symbols`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'exchange' in local_var_params and local_var_params['exchange'] is not None:  # noqa: E501
            query_params.append(('exchange', local_var_params['exchange']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/symbol', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Stock]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stock_tick(self, symbol, date, limit, skip, **kwargs):  # noqa: E501
        """Tick Data  # noqa: E501

        <p>Get historical tick data for US stocks from all 13 exchanges. You can send the request directly to our tick server at <a href=\"https://tick.finnhub.io/\">https://tick.finnhub.io/</a> with the same path and parameters or get redirected there if you call our main server. Data is updated at the end of each trading day.</p><p>Tick data from 1985 is available for Enterprise clients. <a href=\"mailto:support@finnhub.io\">Contact us</a> to learn more.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stock_tick(symbol, date, limit, skip, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol. (required)
        :param date date: Date: 2020-04-02. (required)
        :param int limit: Limit number of ticks returned. Maximum value: <code>25000</code> (required)
        :param int skip: Number of ticks to skip. Use this parameter to loop through the entire data. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: TickData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.stock_tick_with_http_info(symbol, date, limit, skip, **kwargs)  # noqa: E501

    def stock_tick_with_http_info(self, symbol, date, limit, skip, **kwargs):  # noqa: E501
        """Tick Data  # noqa: E501

        <p>Get historical tick data for US stocks from all 13 exchanges. You can send the request directly to our tick server at <a href=\"https://tick.finnhub.io/\">https://tick.finnhub.io/</a> with the same path and parameters or get redirected there if you call our main server. Data is updated at the end of each trading day.</p><p>Tick data from 1985 is available for Enterprise clients. <a href=\"mailto:support@finnhub.io\">Contact us</a> to learn more.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stock_tick_with_http_info(symbol, date, limit, skip, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol. (required)
        :param date date: Date: 2020-04-02. (required)
        :param int limit: Limit number of ticks returned. Maximum value: <code>25000</code> (required)
        :param int skip: Number of ticks to skip. Use this parameter to loop through the entire data. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(TickData, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'date',
            'limit',
            'skip'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stock_tick" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `stock_tick`")  # noqa: E501
        # verify the required parameter 'date' is set
        if self.api_client.client_side_validation and ('date' not in local_var_params or  # noqa: E501
                                                        local_var_params['date'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `date` when calling `stock_tick`")  # noqa: E501
        # verify the required parameter 'limit' is set
        if self.api_client.client_side_validation and ('limit' not in local_var_params or  # noqa: E501
                                                        local_var_params['limit'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `limit` when calling `stock_tick`")  # noqa: E501
        # verify the required parameter 'skip' is set
        if self.api_client.client_side_validation and ('skip' not in local_var_params or  # noqa: E501
                                                        local_var_params['skip'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `skip` when calling `stock_tick`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'date' in local_var_params and local_var_params['date'] is not None:  # noqa: E501
            query_params.append(('date', local_var_params['date']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'skip' in local_var_params and local_var_params['skip'] is not None:  # noqa: E501
            query_params.append(('skip', local_var_params['skip']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/tick', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='TickData',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def support_resistance(self, symbol, resolution, **kwargs):  # noqa: E501
        """Support/Resistance  # noqa: E501

        Get support and resistance levels for a symbol.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.support_resistance(symbol, resolution, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: SupportResistance
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.support_resistance_with_http_info(symbol, resolution, **kwargs)  # noqa: E501

    def support_resistance_with_http_info(self, symbol, resolution, **kwargs):  # noqa: E501
        """Support/Resistance  # noqa: E501

        Get support and resistance levels for a symbol.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.support_resistance_with_http_info(symbol, resolution, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(SupportResistance, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'resolution'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method support_resistance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `support_resistance`")  # noqa: E501
        # verify the required parameter 'resolution' is set
        if self.api_client.client_side_validation and ('resolution' not in local_var_params or  # noqa: E501
                                                        local_var_params['resolution'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `resolution` when calling `support_resistance`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'resolution' in local_var_params and local_var_params['resolution'] is not None:  # noqa: E501
            query_params.append(('resolution', local_var_params['resolution']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/scan/support-resistance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='SupportResistance',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def technical_indicator(self, symbol, resolution, _from, to, indicator, **kwargs):  # noqa: E501
        """Technical Indicators  # noqa: E501

        Return technical indicator with price data. List of supported indicators can be found <a href=\"https://docs.google.com/spreadsheets/d/1ylUvKHVYN2E87WdwIza8ROaCpd48ggEl1k5i5SgA29k/edit?usp=sharing\" target=\"_blank\">here</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.technical_indicator(symbol, resolution, _from, to, indicator, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: symbol (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param int _from: UNIX timestamp. Interval initial value. (required)
        :param int to: UNIX timestamp. Interval end value. (required)
        :param str indicator: Indicator name. Full list can be found <a href=\"https://docs.google.com/spreadsheets/d/1ylUvKHVYN2E87WdwIza8ROaCpd48ggEl1k5i5SgA29k/edit?usp=sharing\" target=\"_blank\">here</a>. (required)
        :param object indicator_fields: Check out <a href=\"https://docs.google.com/spreadsheets/d/1ylUvKHVYN2E87WdwIza8ROaCpd48ggEl1k5i5SgA29k/edit?usp=sharing\" target=\"_blank\">this page</a> to see which indicators and params are supported.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.technical_indicator_with_http_info(symbol, resolution, _from, to, indicator, **kwargs)  # noqa: E501

    def technical_indicator_with_http_info(self, symbol, resolution, _from, to, indicator, **kwargs):  # noqa: E501
        """Technical Indicators  # noqa: E501

        Return technical indicator with price data. List of supported indicators can be found <a href=\"https://docs.google.com/spreadsheets/d/1ylUvKHVYN2E87WdwIza8ROaCpd48ggEl1k5i5SgA29k/edit?usp=sharing\" target=\"_blank\">here</a>.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.technical_indicator_with_http_info(symbol, resolution, _from, to, indicator, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: symbol (required)
        :param str resolution: Supported resolution includes <code>1, 5, 15, 30, 60, D, W, M </code>.Some timeframes might not be available depending on the exchange. (required)
        :param int _from: UNIX timestamp. Interval initial value. (required)
        :param int to: UNIX timestamp. Interval end value. (required)
        :param str indicator: Indicator name. Full list can be found <a href=\"https://docs.google.com/spreadsheets/d/1ylUvKHVYN2E87WdwIza8ROaCpd48ggEl1k5i5SgA29k/edit?usp=sharing\" target=\"_blank\">here</a>. (required)
        :param object indicator_fields: Check out <a href=\"https://docs.google.com/spreadsheets/d/1ylUvKHVYN2E87WdwIza8ROaCpd48ggEl1k5i5SgA29k/edit?usp=sharing\" target=\"_blank\">this page</a> to see which indicators and params are supported.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            'resolution',
            '_from',
            'to',
            'indicator',
            'indicator_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method technical_indicator" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `technical_indicator`")  # noqa: E501
        # verify the required parameter 'resolution' is set
        if self.api_client.client_side_validation and ('resolution' not in local_var_params or  # noqa: E501
                                                        local_var_params['resolution'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `resolution` when calling `technical_indicator`")  # noqa: E501
        # verify the required parameter '_from' is set
        if self.api_client.client_side_validation and ('_from' not in local_var_params or  # noqa: E501
                                                        local_var_params['_from'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `_from` when calling `technical_indicator`")  # noqa: E501
        # verify the required parameter 'to' is set
        if self.api_client.client_side_validation and ('to' not in local_var_params or  # noqa: E501
                                                        local_var_params['to'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `to` when calling `technical_indicator`")  # noqa: E501
        # verify the required parameter 'indicator' is set
        if self.api_client.client_side_validation and ('indicator' not in local_var_params or  # noqa: E501
                                                        local_var_params['indicator'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `indicator` when calling `technical_indicator`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if 'resolution' in local_var_params and local_var_params['resolution'] is not None:  # noqa: E501
            query_params.append(('resolution', local_var_params['resolution']))  # noqa: E501
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501
        if 'indicator' in local_var_params and local_var_params['indicator'] is not None:  # noqa: E501
            query_params.append(('indicator', local_var_params['indicator']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'indicator_fields' in local_var_params:
            body_params = local_var_params['indicator_fields']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/indicator', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def transcripts(self, id, **kwargs):  # noqa: E501
        """Earnings Call Transcripts  # noqa: E501

        <p>Get earnings call transcripts, audio and participants' list. This endpoint is only available for US companies. <p>17+ years of data is available with 170,000+ audio which add up to 6TB in size.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.transcripts(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: Transcript's id obtained with <a href=\"#transcripts-list\">Transcripts List endpoint</a>. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EarningsCallTranscripts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.transcripts_with_http_info(id, **kwargs)  # noqa: E501

    def transcripts_with_http_info(self, id, **kwargs):  # noqa: E501
        """Earnings Call Transcripts  # noqa: E501

        <p>Get earnings call transcripts, audio and participants' list. This endpoint is only available for US companies. <p>17+ years of data is available with 170,000+ audio which add up to 6TB in size.</p>  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.transcripts_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: Transcript's id obtained with <a href=\"#transcripts-list\">Transcripts List endpoint</a>. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EarningsCallTranscripts, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method transcripts" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `transcripts`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'id' in local_var_params and local_var_params['id'] is not None:  # noqa: E501
            query_params.append(('id', local_var_params['id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/transcripts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EarningsCallTranscripts',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def transcripts_list(self, symbol, **kwargs):  # noqa: E501
        """Earnings Call Transcripts List  # noqa: E501

        List earnings call transcripts' metadata. This endpoint is only available for US companies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.transcripts_list(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Company symbol: AAPL. Leave empty to list the latest transcripts (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EarningsCallTranscriptsList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.transcripts_list_with_http_info(symbol, **kwargs)  # noqa: E501

    def transcripts_list_with_http_info(self, symbol, **kwargs):  # noqa: E501
        """Earnings Call Transcripts List  # noqa: E501

        List earnings call transcripts' metadata. This endpoint is only available for US companies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.transcripts_list_with_http_info(symbol, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Company symbol: AAPL. Leave empty to list the latest transcripts (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EarningsCallTranscriptsList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method transcripts_list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'symbol' is set
        if self.api_client.client_side_validation and ('symbol' not in local_var_params or  # noqa: E501
                                                        local_var_params['symbol'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `symbol` when calling `transcripts_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/transcripts/list', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EarningsCallTranscriptsList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upgrade_downgrade(self, **kwargs):  # noqa: E501
        """Stock Upgrade/Downgrade  # noqa: E501

        Get latest stock upgrade and downgrade.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upgrade_downgrade(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. If left blank, the API will return latest stock upgrades/downgrades.
        :param date _from: From date: 2000-03-15.
        :param date to: To date: 2020-03-16.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[UpgradeDowngrade]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.upgrade_downgrade_with_http_info(**kwargs)  # noqa: E501

    def upgrade_downgrade_with_http_info(self, **kwargs):  # noqa: E501
        """Stock Upgrade/Downgrade  # noqa: E501

        Get latest stock upgrade and downgrade.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upgrade_downgrade_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str symbol: Symbol of the company: AAPL. If left blank, the API will return latest stock upgrades/downgrades.
        :param date _from: From date: 2000-03-15.
        :param date to: To date: 2020-03-16.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[UpgradeDowngrade], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'symbol',
            '_from',
            'to'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upgrade_downgrade" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'symbol' in local_var_params and local_var_params['symbol'] is not None:  # noqa: E501
            query_params.append(('symbol', local_var_params['symbol']))  # noqa: E501
        if '_from' in local_var_params and local_var_params['_from'] is not None:  # noqa: E501
            query_params.append(('from', local_var_params['_from']))  # noqa: E501
        if 'to' in local_var_params and local_var_params['to'] is not None:  # noqa: E501
            query_params.append(('to', local_var_params['to']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key']  # noqa: E501

        return self.api_client.call_api(
            '/stock/upgrade-downgrade', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UpgradeDowngrade]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
