# Table of contents

* [👋 Welcome!!](README.md)
* [📖 Docs](docs/README.md)
  * [🧐 Getting Started](docs/getting-started/README.md)
    * [🐍 Getting the Essentials (Python + IDE)](docs/getting-started/getting-the-essentials-python-+-ide.md)
    * [⚠️ Setting Environment Variable](docs/getting-started/setting-environment-variable.md)
    * [⬇️ Downloading Library (BETA)](docs/getting-started/downloading-library-beta.md)
    * [⚙️ Create API Object](docs/getting-started/create-api-object.md)
  * [📦 Standard Methods](docs/methods/README.md)
    * [🔢 DNs](docs/methods/dns/README.md)
      * [1️⃣ GET - Group DNs](docs/methods/dns/group-dns.md)
      * [2️⃣ GET - Group DN Search](docs/methods/dns/group-dn-search.md)
      * [3️⃣ GET - Group DN Details](docs/methods/dns/group-dn-details.md)
      * [4️⃣ GET - Service Provider DNs](docs/methods/dns/service-provider-dns.md)
      * [5️⃣ GET - Service Provider DN Search](docs/methods/dns/service-provider-dn-search.md)
      * [6️⃣ GET - System DNs](docs/methods/dns/system-dns.md)
      * [7️⃣ GET - System DN Summary](docs/methods/dns/system-dn-summary.md)
      * [8️⃣ GET - System DN Utilisation](docs/methods/dns/system-dn-utilization.md)
      * [1️⃣ POST - Group DNs](docs/methods/dns/group-dns-1.md)
      * [2️⃣ POST - Group DNs Assign Bulk](docs/methods/dns/group-dns-assign-bulk.md)
      * [3️⃣ POST - Group DNs Unassign Bulk](docs/methods/dns/group-dns-unassign-bulk.md)
      * [4️⃣ POST - Service Provider DNs](docs/methods/dns/service-provider-dns-1.md)
      * [1️⃣ PUT - Group DNs Activate](docs/methods/dns/group-dns-activate.md)
      * [1️⃣ DELETE - Group DNs](docs/methods/dns/group-dns-2.md)
      * [2️⃣ DELETE - Service Provider DNs](docs/methods/dns/service-provider-dns-2.md)
      * [2️⃣ GET - System DN Search](docs/methods/dns/get-system-dn-search.md)
    * [🔑 Password Generate](docs/methods/password-generate/README.md)
      * [🔓 GET - Password Generate](docs/methods/password-generate/password-generate.md)
      * [🔓 GET - Passwords Generate](docs/methods/password-generate/passwords-generate.md)
      * [🗝️ GET - Passcode Generate](docs/methods/password-generate/passcode-generate.md)
      * [🗝️ GET - Passcodes Generate](docs/methods/password-generate/passcodes-generate.md)
      * [🗝️ GET - SIP Password Generate](docs/methods/password-generate/sip-password-generate.md)
      * [🗝️ GET - SIP Passwords Generate](docs/methods/password-generate/sip-passwords-generate.md)
    * [🟢 Registration](docs/methods/registration/README.md)
      * [💚 GET - User Registration](docs/methods/registration/user-registration.md)
      * [💚 GET - Bulk User Registration](docs/methods/registration/bulk-user-registration.md)
    * [🤵 Administrators](docs/methods/administrators/README.md)
      * [🤵 POST - Group Admin](docs/methods/administrators/post.group-admin.md)
    * [🔢 Alternate Numbers](docs/methods/alternate-numbers/README.md)
      * [1️⃣ GET - User Alternate Numbers](docs/methods/alternate-numbers/get-user-alternate-numbers.md)
    * [📆 Schedules](docs/methods/schedules.md)
      * [📆 GET - Group Schedules](docs/methods/schedules/get-group-schedules.md)
      * [📆 GET - Group Events](docs/methods/schedules/get-group-events.md)
    * [🌊 Trunk Groups](docs/methods/trunk-groups/README.md)
      * [📞 GET - Group Trunk Groups Call Capacity](docs/methods/trunk-groups/get-group-trunk-groups-call-capacity.md)
      * [☎️ GET - Group Trunk Group](docs/methods/trunk-groups/get-group-trunk-group.md)
      * [🚰 GET - Group Trunk Groups](docs/methods/trunk-groups/get-group-trunk-groups.md)
      * [🚿 GET - Service Provider Trunk Group Call Capacity](docs/methods/trunk-groups/get-service-provider-trunk-group-call-capacity.md)
      * [📂 GET - Service Provider Call Capacity Report](docs/methods/trunk-groups/get-service-provider-call-capacity-report.md)
      * [📞 PUT - Group Trunk Groups Call Capacity](docs/methods/trunk-groups/put-group-trunk-groups-call-capacity.md)
      * [☎️ PUT - Group Trunk Group](docs/methods/trunk-groups/put-group-trunk-group.md)
      * [🚿 PUT - Service Provider Trunk Group Call Capacity](docs/methods/trunk-groups/put-service-providers-trunk-group-call-capacity.md)
      * [🚿 POST - Group Trunk Group](docs/methods/trunk-groups/post-group-trunk-group.md)
    * [🤵 User](docs/methods/user/README.md)
      * [🆔 GET - User By ID](docs/methods/user/get-user-by-id.md)
      * [🧅 GET - User Login Info](docs/methods/user/get-user-login-info.md)
      * [🔐 GET - User Portal Passcode](docs/methods/user/get-user-portal-passcode.md)
      * [👯 GET - Users](docs/methods/user/get-users.md)
      * [📮 POST - User](docs/methods/user/post-user.md)
      * [⭕ POST - User Reset](docs/methods/user/post-user-reset.md)
      * [👩‍💻 PUT - User](docs/methods/user/put-user.md)
      * [🆔 PUT - User ID](docs/methods/user/put-user-id.md)
      * [👩‍👩‍👧‍👧 PUT - Users Bulk](docs/methods/user/put-users-bulk.md)
      * [🔏 PUT - User Portal Passcode](docs/methods/user/put-user-portal-passcode.md)
      * [🤝 PUT - User Group ID Update](docs/methods/user/put-user-group-id-update.md)
      * [❌ DEL - User](docs/methods/user/del-user.md)
    * [🤝 Groups](docs/methods/groups/README.md)
      * [🤝 GET - Service Provider Groups](docs/methods/groups/get-groups.md)
      * [🤝 GET - Group Information](docs/methods/groups/get-group.md)
    * [🚗 User Call Forwarding](docs/methods/call-forwarding/README.md)
      * [🚗 GET - Bulk User Call Forwarding Always](docs/methods/call-forwarding/get-user-call-forwarding-always.md)
      * [🚗 GET - User Call Forwarding Always](docs/methods/call-forwarding/get-bulk-call-forwarding-always.md)
      * [🚗 GET - Bulk User Call Forwarding Busy](docs/methods/call-forwarding/get-user-call-forwarding-busy.md)
      * [🚗 GET - User Call Forwarding Busy](docs/methods/call-forwarding/get-bulk-call-forwarding-busy.md)
      * [🚗 GET - Bulk User Call Forwarding Not Reachable](docs/methods/call-forwarding/get-user-call-forwarding-not-reachable.md)
      * [🚗 GET - User Call Forwarding Not Reachable](docs/methods/call-forwarding/get-bulk-call-forwarding-not-reachable.md)
      * [🚗 GET - Bulk User Call Forwarding No Answer](docs/methods/call-forwarding/get-bulk-call-forwarding-no-answer.md)
      * [🚗 GET - User Call Forwarding No Answer](docs/methods/call-forwarding/get-user-call-forwarding-no-answer.md)
      * [🚗 GET - User Call Forwarding Selective Criteria](docs/methods/call-forwarding/get-user-call-forwarding-selective-criteria.md)
      * [🚗 GET - User Call Forwarding Selective Criterias](docs/methods/call-forwarding/get-user-call-forwarding-selective-criterias.md)
      * [🚗 GET - User Call Forwarding Selective](docs/methods/call-forwarding/get-user-call-forwarding-selective.md)
    * [🏢️ Service Providers](docs/methods/service-providers/README.md)
      * [🏢️ GET - Service Provider](docs/methods/service-providers/get-service-provider.md)
      * [🏢️ GET - Service Providers](docs/methods/service-providers/get-service-providers.md)
    * [📈 User Reports](docs/methods/reports/README.md)
      * [📈 GET - User Report](docs/methods/reports/get-user-report.md)
    * [🧾 Call Records](docs/methods/call-records/README.md)
      * [🧾 GET - User Stats](docs/methods/call-records/get-call-stats.md)
    * [💬 Call Pickup](docs/methods/call-pickup/README.md)
      * [🤳 GET - Call Pickup Group User](docs/methods/call-pickup/get-call-pickup-group-user.md)
    * [🔑 Authentication](docs/methods/authentication/README.md)
      * [🔏 PUT - User Web Authentication Password](docs/methods/authentication/put-user-web-authentication-password.md)
      * [👮‍♀️ PUT - User Authentication Service](docs/methods/authentication/put-user-authentication-service.md)
    * [💬 Auto Attendants](docs/methods/auto-attendants/README.md)
      * [🟢 PUT - Auto Attendant Status](docs/methods/auto-attendants/auto-attendant-status.md)
      * [🍅 PUT - Auto Attendant](docs/methods/auto-attendants/auto-attendant.md)
      * [📖 PUT - Auto Attendant Submenu](docs/methods/auto-attendants/auto-attendant-submenu.md)
      * [📞 GET - Auto Attendants](docs/methods/auto-attendants/get-auto-attendants.md)
      * [🤙🏼 GET - Auto Attendant](docs/methods/auto-attendants/get-auto-attendant.md)
      * [🖲️ GET - Auto Attendant Submenu Usage](docs/methods/auto-attendants/get-auto-attendant-submenu-usage.md)
      * [🎚️ GET - Auto Attendant Submenus](docs/methods/auto-attendants/get-auto-attendant-submenus.md)
      * [💁‍♀️ GET - Auto Attendant User](docs/methods/auto-attendants/get-auto-attendant-user.md)
      * [✍️ POST - Auto Attendant](docs/methods/auto-attendants/post-auto-attendant.md)
      * [👋 POST - Auto Attendant Remove User](docs/methods/auto-attendants/post-auto-attendant-remove-user.md)
      * [🦾 POST - Auto Attendant Submenu](docs/methods/auto-attendants/post-auto-attendant-submenu.md)
      * [🚮 DELETE - Auto Attendant](docs/methods/auto-attendants/delete-auto-attendant.md)
      * [🛑 DELETE - Auto Attendant Submenu](docs/methods/auto-attendants/delete-auto-attendant-submenu.md)
    * [📞 Call Centers](docs/methods/call-centers/README.md)
      * [🎧 GET - Group Call Centers](docs/methods/call-centers/get-group-call-centers.md)
      * [🎧 GET - Group Call Center](docs/methods//call-centers/get-group-call-center.md)
      * [👤 GET - User Call Center](docs/methods/call-centers/get-user-call-center.md)
      * [📞 GET - Group Call Center Bounced Calls](docs/methods/call-centers/get-group-call-center-bounced-calls.md)
      * [📞 GET - Group Call Center Forced Forwarding](docs/methods/call-centers/get-group-call-center-forced-forwarding.md)
      * [📞 GET - Group Call Center Overflow](docs/methods/call-centers/get-group-call-center-overflow.md)
      * [🆘 GET - Group Call Center Stranded Calls](docs/methods/call-centers/get-group-call-center-stranded-calls.md)
      * [🚫 GET - Group Call Center Stranded Calls Unavailable](docs/methods/call-centers/get-group-call-center-stranded-calls-unavailable.md)
      * [🟢 PUT - Group Call Center Status](docs/methods/call-centers/group-call-center-status.md)
      * [🎧 PUT - Group Call Center](docs/methods/call-centers/group-call-center.md)
      * [🎧 PUT - Group Call Center Agents](docs/methods/call-centers/group-call-center-agents.md)
      * [🎚️ PUT - Group Call Center Agents Levels](docs/methods/call-centers/group-call-center-agents-levels.md)
      * [⚽ PUT - Group Call Center Bounced Call](docs/methods/call-centers/group-call-center-bounced-call.md)
      * [📞 PUT - Group Call Center DNIS Instance](docs/methods/call-centers/group-call-center-dnis-instance.md)
      * [⏩ PUT - Group Call Center Forced Forwarding](docs/methods/call-centers/group-call-center-forced-forwarding.md)
      * [🌊 PUT - Group Call Center Overflow](docs/methods/call-centers/group-call-center-overflow.md)
      * [🏝️ PUT - Group Call Center Stranded Calls](docs/methods/call-centers/group-call-center-stranded-calls.md)
      * [🔴 PUT - Group Call Center Stranded Calls Unavailable](docs/methods/call-centers/group-call-center-stranded-calls-unavailable.md)
      * [👓 PUT - User Call Center Supervised Agents](docs/methods/call-centers/user-call-center-supervised-agents.md)
      * [🟢 PUT - User Call Center](docs/methods/call-centers/user-call-center.md)
      * [🙋‍♂️ PUT - User Call Center Agents Update](docs/methods/call-centers/user-call-center-agents-update.md)
      * [🛑 PUT - User Call Center Agent Sign Out](docs/methods/call-centers/user-call-center-agent-sign-out.md)
    * [📞 Call Processing Policies](docs/methods/call-processing-policies/README.md)
      * [🗃️ PUT - User Call Processing Policy](docs/methods/call-processing-policies/put-user-call-processing-policy.md)
    * [☎️ Devices](docs/methods/devices/README.md)
      * [📱 PUT - Group Devices](docs/methods/devices/group-devices.md)
      * [📞 PUT - Service Provider Device](docs/methods/devices/service-provider-device.md)
      * [💻 PUT - System Devices](docs/methods/devices/system-devices.md)
      * [📁 PUT - System Device File](docs/methods/devices/system-device-file.md)
      * [📂 PUT - Service Provider Device File](docs/methods/devices/service-provider-device-file.md)
      * [🗃️ PUT - Group Device File](docs/methods/devices/group-device-file.md)
      * [🏷️ PUT - Group Device Tags Profile](docs/methods/devices/group-device-tags-profile.md)
      * [🎐 PUT - Group Device Tag](docs/methods/devices/group-device-tag.md)
      * [🛰️ PUT - Service Provider Device Tag](docs/methods/devices/service-provider-device-tag.md)
      * [💾 PUT - System Device Tag](docs/methods/devices/system-device-tag.md)
      * [📂 PUT - Group Device Type File](docs/methods/devices/group-device-type-file.md)
      * [🎐 PUT - Group Device Type Tag](docs/methods/devices/group-device-type-tag.md)
      * [🎐 PUT - Service Provider Device Type Tag](docs/methods/devices/service-provider-device-type-tag.md)
      * [🗃️ POST - Group Device](docs/methods/devices/post-group\_device.md)
    * [🍇 Hunt Groups](docs/methods/hunt-groups/README.md)
      * [🍇 GET - Group Hunt Groups](docs/methods/hunt-groups/get-group-hunt-groups.md)
      * [🍊 GET - Group Hunt Group](docs/methods/hunt-groups/get-group-hunt-group.md)
      * [🍐 GET - Group Hunt Group User](docs/methods/hunt-groups/get-group-hunt-group-user.md)
      * [👩‍👩‍👧‍👧 GET - Group Hunt Groups Available Users](docs/methods/hunt-groups/get-group-hunt-groups-available-users.md)
      * [🟢 PUT - Group Hunt Groups Status](docs/methods/hunt-groups/group-hunt-groups-status.md)
      * [🍏 PUT - Group Hunt Group](docs/methods/hunt-groups/group-hunt-group.md)
      * [💯 PUT - Group Hunt Group Weighted Call Distribution](docs/methods/hunt-groups/group-hunt-group-weighted-call-distribution.md)
      * [🙋‍♂️ POST - Group Hunt Group](docs/methods/hunt-groups/post-group-hunt-group.md)
      * [👋 POST - Group Hunt Groups Remove User](docs/methods/hunt-groups/post-group-hunt-groups-remove-user.md)
      * [💔 DELETE - Group Hunt Group](docs/methods/hunt-groups/delete-group-hunt-group.md)
    * [🧍 Services](docs/methods/services/README.md)
      * [🧍 PUT - User Services](docs/methods/services/put-user-services.md)
      * [🧍 GET - User Services Assigned](docs/methods/services/get-user-services-assigned.md)
      * [🧍 GET - User-Services](docs/methods/services/get-user-services.md)
      * [🧍 GET - Group Services Assigned](docs/methods/services/get-group-services-assigned.md)
      * [🧍 GET - Group Services](docs/methods/services/get-group-services.md)
      * [⚙️ GET - User Service Settings](docs/methods/services/get-user-service-settings.md)
      * [⚙️ PUT - User Service Settings](docs/methods/services/put-user-service-settings.md)
    * [🚑 Emergency Zones](docs/methods/emergency-zones/README.md)
      * [🗃️ POST - Group Emergency Zones](docs/methods/emergency-zones/post-group-emergency-zones.md)
      * [⚠️ PUT - Group Emergency Zones](docs/methods/emergency-zones/put-group-emergency-zones.md)
    * [🛑 Do Not Disturb](docs/methods/do-not-disturb/README.md)
      * [🛑 GET - User Do Not Disturb](docs/methods/do-not-disturb/get-user-do-not-disturb.md)
      * [🛑 PUT - User Do Not Disturb](docs/methods/do-not-disturb/put-user-do-not-disturb.md)
    * [🎭 Shared Call Appearance](docs/methods/shared-call-appearance/README.md)
      * [🎭 POST - User Shared Call Appearance Endpoint](docs/methods/shared-call-appearance/post-user-shared-call-appearance-endpoint)
  * [🙌 Advanced Features](docs/features/README.md)
    * [🤖 Scripter](docs/features/scripter/README.md)
      * [🔎 Find Alias](docs/features/scripter/find-alias-script.md)
      * [🔗 User Association](docs/features/scripter/user-association.md)
      * [☑️ Group Audit](docs/features/scripter/group-audit.md)
      * [✅ Service Pack Audit](docs/features/scripter/service-pack-audit.md)
      * [✔️ AA, CC, HG Audit](docs/features/scripter/aa-cc-hg-audit.md)
      * [🔢 Move Numbers](docs/features/scripter/move-numbers.md)
      * [🔢 Remove Numbers](docs/features/scripter/remove-numbers.md)
      * [🔑 Bulk Password Reset](docs/features/scripter/bulk-password-reset.md)
      * [📜 Service Provider Trunking Capacity](docs/features/scripter/service-provider-trunking-capacity.md)
      * [💻 Webex Builder](docs/features/scripter/webex-builder.md)
      * [Locate Free Extension](docs/features/scripter/locate-free-extension.md)
    * [📈 Reporter](docs/features/reporter/README.md)
      * [🤙 Call Flow](docs/features/reporter/call-flow/README.md)
        * [🔑 Node Key](docs/features/reporter/call-flow/node-key.md)
        * [🔑 Abbreviation Key](docs/features/reporter/call-flow/abbreviation-key.md)
        * [📈 Graphviz](docs/features/reporter/call-flow/graphviz.md)
      * [🔢 Group Users Call Statistics](docs/features/reporter/group-users-call-statistics.md)
    * [📜 Logger](docs/features/logger/README.md)
      * [📂 Sending Logs To A File](docs/features/logger/sending-logs-to-a-file.md)
      * [☁️ Sending Logs To A Syslog Server](docs/features/logger/sending-logs-to-a-syslog-server.md)
    * [🛑 Rate Limiting API Calls](docs/features/rate-limiting-api-calls.md)
* [Powered By Odin's Spear](powered-by-odins-spear/README.md)
  * [Bulk Build Group Admins](powered-by-odins-spear/bulk-build-group-admins.md)
* [👨‍💻 Development](development.md)
* [🆘 Troubleshooting & FAQ](troubleshooting-and-faq/README.md)
  * [🐛 Common Issues](troubleshooting-and-faq/common-issues.md)
  * [⁉️ Frequently Asked Questions](troubleshooting-and-faq/frequently-asked-questions/README.md)
    * [1️⃣ Multiple Loggers](troubleshooting-and-faq/frequently-asked-questions/do-you-need-to-set-up-multiple-loggers-for-multiple-api-objects-no..md)
    * [📈 Graphviz Troubleshooting](troubleshooting-and-faq/graphviz-troubleshooting.md)
* [🐛 Bugs and Issues](bugs-and-issues.md)
* [🤙 Contact](contact.md)
