/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#allow_tracing ApiManagementSubscription#allow_tracing}
    */
    readonly allowTracing?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#api_id ApiManagementSubscription#api_id}
    */
    readonly apiId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#api_management_name ApiManagementSubscription#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#display_name ApiManagementSubscription#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#id ApiManagementSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#primary_key ApiManagementSubscription#primary_key}
    */
    readonly primaryKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#product_id ApiManagementSubscription#product_id}
    */
    readonly productId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#resource_group_name ApiManagementSubscription#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#secondary_key ApiManagementSubscription#secondary_key}
    */
    readonly secondaryKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#state ApiManagementSubscription#state}
    */
    readonly state?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#subscription_id ApiManagementSubscription#subscription_id}
    */
    readonly subscriptionId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#user_id ApiManagementSubscription#user_id}
    */
    readonly userId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#timeouts ApiManagementSubscription#timeouts}
    */
    readonly timeouts?: ApiManagementSubscriptionTimeouts;
}
export interface ApiManagementSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#create ApiManagementSubscription#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#delete ApiManagementSubscription#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#read ApiManagementSubscription#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#update ApiManagementSubscription#update}
    */
    readonly update?: string;
}
export declare function apiManagementSubscriptionTimeoutsToTerraform(struct?: ApiManagementSubscriptionTimeouts | cdktf.IResolvable): any;
export declare function apiManagementSubscriptionTimeoutsToHclTerraform(struct?: ApiManagementSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementSubscriptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementSubscriptionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription azurerm_api_management_subscription}
*/
export declare class ApiManagementSubscription extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_subscription";
    /**
    * Generates CDKTF code for importing a ApiManagementSubscription resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiManagementSubscription to import
    * @param importFromId The id of the existing ApiManagementSubscription that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiManagementSubscription to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/api_management_subscription azurerm_api_management_subscription} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementSubscriptionConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementSubscriptionConfig);
    private _allowTracing?;
    get allowTracing(): boolean | cdktf.IResolvable;
    set allowTracing(value: boolean | cdktf.IResolvable);
    resetAllowTracing(): void;
    get allowTracingInput(): boolean | cdktf.IResolvable | undefined;
    private _apiId?;
    get apiId(): string;
    set apiId(value: string);
    resetApiId(): void;
    get apiIdInput(): string | undefined;
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _primaryKey?;
    get primaryKey(): string;
    set primaryKey(value: string);
    resetPrimaryKey(): void;
    get primaryKeyInput(): string | undefined;
    private _productId?;
    get productId(): string;
    set productId(value: string);
    resetProductId(): void;
    get productIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _secondaryKey?;
    get secondaryKey(): string;
    set secondaryKey(value: string);
    resetSecondaryKey(): void;
    get secondaryKeyInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    resetSubscriptionId(): void;
    get subscriptionIdInput(): string | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    resetUserId(): void;
    get userIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementSubscriptionTimeoutsOutputReference;
    putTimeouts(value: ApiManagementSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
