/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceActiveSlotConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/app_service_active_slot#app_service_name AppServiceActiveSlot#app_service_name}
    */
    readonly appServiceName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/app_service_active_slot#app_service_slot_name AppServiceActiveSlot#app_service_slot_name}
    */
    readonly appServiceSlotName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/app_service_active_slot#id AppServiceActiveSlot#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/app_service_active_slot#resource_group_name AppServiceActiveSlot#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/app_service_active_slot#timeouts AppServiceActiveSlot#timeouts}
    */
    readonly timeouts?: AppServiceActiveSlotTimeouts;
}
export interface AppServiceActiveSlotTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/app_service_active_slot#create AppServiceActiveSlot#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/app_service_active_slot#delete AppServiceActiveSlot#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/app_service_active_slot#read AppServiceActiveSlot#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/app_service_active_slot#update AppServiceActiveSlot#update}
    */
    readonly update?: string;
}
export declare function appServiceActiveSlotTimeoutsToTerraform(struct?: AppServiceActiveSlotTimeouts | cdktf.IResolvable): any;
export declare function appServiceActiveSlotTimeoutsToHclTerraform(struct?: AppServiceActiveSlotTimeouts | cdktf.IResolvable): any;
export declare class AppServiceActiveSlotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AppServiceActiveSlotTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AppServiceActiveSlotTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/app_service_active_slot azurerm_app_service_active_slot}
*/
export declare class AppServiceActiveSlot extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_app_service_active_slot";
    /**
    * Generates CDKTF code for importing a AppServiceActiveSlot resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AppServiceActiveSlot to import
    * @param importFromId The id of the existing AppServiceActiveSlot that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/app_service_active_slot#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AppServiceActiveSlot to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/app_service_active_slot azurerm_app_service_active_slot} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceActiveSlotConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceActiveSlotConfig);
    private _appServiceName?;
    get appServiceName(): string;
    set appServiceName(value: string);
    get appServiceNameInput(): string | undefined;
    private _appServiceSlotName?;
    get appServiceSlotName(): string;
    set appServiceSlotName(value: string);
    get appServiceSlotNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): AppServiceActiveSlotTimeoutsOutputReference;
    putTimeouts(value: AppServiceActiveSlotTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AppServiceActiveSlotTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
