/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BackupProtectedVmConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#backup_policy_id BackupProtectedVm#backup_policy_id}
    */
    readonly backupPolicyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#exclude_disk_luns BackupProtectedVm#exclude_disk_luns}
    */
    readonly excludeDiskLuns?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#id BackupProtectedVm#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#include_disk_luns BackupProtectedVm#include_disk_luns}
    */
    readonly includeDiskLuns?: number[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#protection_state BackupProtectedVm#protection_state}
    */
    readonly protectionState?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#recovery_vault_name BackupProtectedVm#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#resource_group_name BackupProtectedVm#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#source_vm_id BackupProtectedVm#source_vm_id}
    */
    readonly sourceVmId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#timeouts BackupProtectedVm#timeouts}
    */
    readonly timeouts?: BackupProtectedVmTimeouts;
}
export interface BackupProtectedVmTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#create BackupProtectedVm#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#delete BackupProtectedVm#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#read BackupProtectedVm#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#update BackupProtectedVm#update}
    */
    readonly update?: string;
}
export declare function backupProtectedVmTimeoutsToTerraform(struct?: BackupProtectedVmTimeouts | cdktf.IResolvable): any;
export declare function backupProtectedVmTimeoutsToHclTerraform(struct?: BackupProtectedVmTimeouts | cdktf.IResolvable): any;
export declare class BackupProtectedVmTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BackupProtectedVmTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: BackupProtectedVmTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm azurerm_backup_protected_vm}
*/
export declare class BackupProtectedVm extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_backup_protected_vm";
    /**
    * Generates CDKTF code for importing a BackupProtectedVm resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the BackupProtectedVm to import
    * @param importFromId The id of the existing BackupProtectedVm that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the BackupProtectedVm to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/backup_protected_vm azurerm_backup_protected_vm} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BackupProtectedVmConfig
    */
    constructor(scope: Construct, id: string, config: BackupProtectedVmConfig);
    private _backupPolicyId?;
    get backupPolicyId(): string;
    set backupPolicyId(value: string);
    resetBackupPolicyId(): void;
    get backupPolicyIdInput(): string | undefined;
    private _excludeDiskLuns?;
    get excludeDiskLuns(): number[];
    set excludeDiskLuns(value: number[]);
    resetExcludeDiskLuns(): void;
    get excludeDiskLunsInput(): number[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _includeDiskLuns?;
    get includeDiskLuns(): number[];
    set includeDiskLuns(value: number[]);
    resetIncludeDiskLuns(): void;
    get includeDiskLunsInput(): number[] | undefined;
    private _protectionState?;
    get protectionState(): string;
    set protectionState(value: string);
    resetProtectionState(): void;
    get protectionStateInput(): string | undefined;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sourceVmId?;
    get sourceVmId(): string;
    set sourceVmId(value: string);
    resetSourceVmId(): void;
    get sourceVmIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): BackupProtectedVmTimeoutsOutputReference;
    putTimeouts(value: BackupProtectedVmTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | BackupProtectedVmTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
