/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CdnFrontdoorCustomDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#cdn_frontdoor_profile_id CdnFrontdoorCustomDomain#cdn_frontdoor_profile_id}
    */
    readonly cdnFrontdoorProfileId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#dns_zone_id CdnFrontdoorCustomDomain#dns_zone_id}
    */
    readonly dnsZoneId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#host_name CdnFrontdoorCustomDomain#host_name}
    */
    readonly hostName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#id CdnFrontdoorCustomDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#name CdnFrontdoorCustomDomain#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#timeouts CdnFrontdoorCustomDomain#timeouts}
    */
    readonly timeouts?: CdnFrontdoorCustomDomainTimeouts;
    /**
    * tls block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#tls CdnFrontdoorCustomDomain#tls}
    */
    readonly tls: CdnFrontdoorCustomDomainTls;
}
export interface CdnFrontdoorCustomDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#create CdnFrontdoorCustomDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#delete CdnFrontdoorCustomDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#read CdnFrontdoorCustomDomain#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#update CdnFrontdoorCustomDomain#update}
    */
    readonly update?: string;
}
export declare function cdnFrontdoorCustomDomainTimeoutsToTerraform(struct?: CdnFrontdoorCustomDomainTimeouts | cdktf.IResolvable): any;
export declare function cdnFrontdoorCustomDomainTimeoutsToHclTerraform(struct?: CdnFrontdoorCustomDomainTimeouts | cdktf.IResolvable): any;
export declare class CdnFrontdoorCustomDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorCustomDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CdnFrontdoorCustomDomainTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface CdnFrontdoorCustomDomainTls {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#cdn_frontdoor_secret_id CdnFrontdoorCustomDomain#cdn_frontdoor_secret_id}
    */
    readonly cdnFrontdoorSecretId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#certificate_type CdnFrontdoorCustomDomain#certificate_type}
    */
    readonly certificateType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#minimum_tls_version CdnFrontdoorCustomDomain#minimum_tls_version}
    */
    readonly minimumTlsVersion?: string;
}
export declare function cdnFrontdoorCustomDomainTlsToTerraform(struct?: CdnFrontdoorCustomDomainTlsOutputReference | CdnFrontdoorCustomDomainTls): any;
export declare function cdnFrontdoorCustomDomainTlsToHclTerraform(struct?: CdnFrontdoorCustomDomainTlsOutputReference | CdnFrontdoorCustomDomainTls): any;
export declare class CdnFrontdoorCustomDomainTlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CdnFrontdoorCustomDomainTls | undefined;
    set internalValue(value: CdnFrontdoorCustomDomainTls | undefined);
    private _cdnFrontdoorSecretId?;
    get cdnFrontdoorSecretId(): string;
    set cdnFrontdoorSecretId(value: string);
    resetCdnFrontdoorSecretId(): void;
    get cdnFrontdoorSecretIdInput(): string | undefined;
    private _certificateType?;
    get certificateType(): string;
    set certificateType(value: string);
    resetCertificateType(): void;
    get certificateTypeInput(): string | undefined;
    private _minimumTlsVersion?;
    get minimumTlsVersion(): string;
    set minimumTlsVersion(value: string);
    resetMinimumTlsVersion(): void;
    get minimumTlsVersionInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain azurerm_cdn_frontdoor_custom_domain}
*/
export declare class CdnFrontdoorCustomDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cdn_frontdoor_custom_domain";
    /**
    * Generates CDKTF code for importing a CdnFrontdoorCustomDomain resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CdnFrontdoorCustomDomain to import
    * @param importFromId The id of the existing CdnFrontdoorCustomDomain that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CdnFrontdoorCustomDomain to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/cdn_frontdoor_custom_domain azurerm_cdn_frontdoor_custom_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CdnFrontdoorCustomDomainConfig
    */
    constructor(scope: Construct, id: string, config: CdnFrontdoorCustomDomainConfig);
    private _cdnFrontdoorProfileId?;
    get cdnFrontdoorProfileId(): string;
    set cdnFrontdoorProfileId(value: string);
    get cdnFrontdoorProfileIdInput(): string | undefined;
    private _dnsZoneId?;
    get dnsZoneId(): string;
    set dnsZoneId(value: string);
    resetDnsZoneId(): void;
    get dnsZoneIdInput(): string | undefined;
    get expirationDate(): string;
    private _hostName?;
    get hostName(): string;
    set hostName(value: string);
    get hostNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get validationToken(): string;
    private _timeouts;
    get timeouts(): CdnFrontdoorCustomDomainTimeoutsOutputReference;
    putTimeouts(value: CdnFrontdoorCustomDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CdnFrontdoorCustomDomainTimeouts | undefined;
    private _tls;
    get tls(): CdnFrontdoorCustomDomainTlsOutputReference;
    putTls(value: CdnFrontdoorCustomDomainTls): void;
    get tlsInput(): CdnFrontdoorCustomDomainTls | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
