/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerAppCustomDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * The Binding type. Possible values include `Disabled` and `SniEnabled`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/container_app_custom_domain#certificate_binding_type ContainerAppCustomDomain#certificate_binding_type}
    */
    readonly certificateBindingType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/container_app_custom_domain#container_app_environment_certificate_id ContainerAppCustomDomain#container_app_environment_certificate_id}
    */
    readonly containerAppEnvironmentCertificateId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/container_app_custom_domain#container_app_id ContainerAppCustomDomain#container_app_id}
    */
    readonly containerAppId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/container_app_custom_domain#id ContainerAppCustomDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The hostname of the Certificate. Must be the CN or a named SAN in the certificate.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/container_app_custom_domain#name ContainerAppCustomDomain#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/container_app_custom_domain#timeouts ContainerAppCustomDomain#timeouts}
    */
    readonly timeouts?: ContainerAppCustomDomainTimeouts;
}
export interface ContainerAppCustomDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/container_app_custom_domain#create ContainerAppCustomDomain#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/container_app_custom_domain#delete ContainerAppCustomDomain#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/container_app_custom_domain#read ContainerAppCustomDomain#read}
    */
    readonly read?: string;
}
export declare function containerAppCustomDomainTimeoutsToTerraform(struct?: ContainerAppCustomDomainTimeouts | cdktf.IResolvable): any;
export declare function containerAppCustomDomainTimeoutsToHclTerraform(struct?: ContainerAppCustomDomainTimeouts | cdktf.IResolvable): any;
export declare class ContainerAppCustomDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ContainerAppCustomDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ContainerAppCustomDomainTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/container_app_custom_domain azurerm_container_app_custom_domain}
*/
export declare class ContainerAppCustomDomain extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_container_app_custom_domain";
    /**
    * Generates CDKTF code for importing a ContainerAppCustomDomain resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ContainerAppCustomDomain to import
    * @param importFromId The id of the existing ContainerAppCustomDomain that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/container_app_custom_domain#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ContainerAppCustomDomain to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/container_app_custom_domain azurerm_container_app_custom_domain} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerAppCustomDomainConfig
    */
    constructor(scope: Construct, id: string, config: ContainerAppCustomDomainConfig);
    private _certificateBindingType?;
    get certificateBindingType(): string;
    set certificateBindingType(value: string);
    get certificateBindingTypeInput(): string | undefined;
    private _containerAppEnvironmentCertificateId?;
    get containerAppEnvironmentCertificateId(): string;
    set containerAppEnvironmentCertificateId(value: string);
    get containerAppEnvironmentCertificateIdInput(): string | undefined;
    private _containerAppId?;
    get containerAppId(): string;
    set containerAppId(value: string);
    get containerAppIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ContainerAppCustomDomainTimeoutsOutputReference;
    putTimeouts(value: ContainerAppCustomDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ContainerAppCustomDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
