/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMonitorDataCollectionRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/monitor_data_collection_rule#id DataAzurermMonitorDataCollectionRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/monitor_data_collection_rule#name DataAzurermMonitorDataCollectionRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/monitor_data_collection_rule#resource_group_name DataAzurermMonitorDataCollectionRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/monitor_data_collection_rule#timeouts DataAzurermMonitorDataCollectionRule#timeouts}
    */
    readonly timeouts?: DataAzurermMonitorDataCollectionRuleTimeouts;
}
export interface DataAzurermMonitorDataCollectionRuleDataFlow {
}
export declare function dataAzurermMonitorDataCollectionRuleDataFlowToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataFlow): any;
export declare function dataAzurermMonitorDataCollectionRuleDataFlowToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataFlow): any;
export declare class DataAzurermMonitorDataCollectionRuleDataFlowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataFlow | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataFlow | undefined);
    get builtInTransform(): string;
    get destinations(): string[];
    get outputStream(): string;
    get streams(): string[];
    get transformKql(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDataFlowList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataFlowOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesDataImportEventHubDataSourceToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesDataImportEventHubDataSourceToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesDataImportEventHubDataSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesDataImportEventHubDataSource | undefined);
    get consumerGroup(): string;
    get name(): string;
    get stream(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesDataImportEventHubDataSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesDataImportEventHubDataSourceOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesDataImport {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesDataImportToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesDataImport): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesDataImportToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesDataImport): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesDataImportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesDataImport | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesDataImport | undefined);
    private _eventHubDataSource;
    get eventHubDataSource(): DataAzurermMonitorDataCollectionRuleDataSourcesDataImportEventHubDataSourceList;
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesDataImportList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesDataImportOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesExtension {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesExtensionToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesExtension): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesExtensionToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesExtension): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesExtensionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesExtension | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesExtension | undefined);
    get extensionJson(): string;
    get extensionName(): string;
    get inputDataSources(): string[];
    get name(): string;
    get streams(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesExtensionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesExtensionOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesIisLog {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesIisLogToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesIisLog): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesIisLogToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesIisLog): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesIisLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesIisLog | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesIisLog | undefined);
    get logDirectories(): string[];
    get name(): string;
    get streams(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesIisLogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesIisLogOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsText {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsTextToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsText): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsTextToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsText): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsTextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsText | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsText | undefined);
    get recordStartTimestampFormat(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsTextList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsTextOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettings {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettings): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettings): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettings | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettings | undefined);
    private _text;
    get text(): DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsTextList;
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesLogFile {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesLogFileToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesLogFile): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesLogFileToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesLogFile): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesLogFileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesLogFile | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesLogFile | undefined);
    get filePatterns(): string[];
    get format(): string;
    get name(): string;
    private _settings;
    get settings(): DataAzurermMonitorDataCollectionRuleDataSourcesLogFileSettingsList;
    get streams(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesLogFileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesLogFileOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounter {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounterToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounter): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounterToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounter): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounter | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounter | undefined);
    get counterSpecifiers(): string[];
    get name(): string;
    get samplingFrequencyInSeconds(): number;
    get streams(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounterOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesPlatformTelemetry {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesPlatformTelemetryToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesPlatformTelemetry): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesPlatformTelemetryToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesPlatformTelemetry): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesPlatformTelemetryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesPlatformTelemetry | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesPlatformTelemetry | undefined);
    get name(): string;
    get streams(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesPlatformTelemetryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesPlatformTelemetryOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilterToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilterToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilterOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilter | undefined);
    get label(): string;
    get value(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilterList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilterOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarder {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarder): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarder): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarder | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarder | undefined);
    private _labelIncludeFilter;
    get labelIncludeFilter(): DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderLabelIncludeFilterList;
    get name(): string;
    get streams(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesSyslog {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesSyslogToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesSyslog): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesSyslogToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesSyslog): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesSyslogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesSyslog | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesSyslog | undefined);
    get facilityNames(): string[];
    get logLevels(): string[];
    get name(): string;
    get streams(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesSyslogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesSyslogOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLog {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLogToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLog): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLogToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLog): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLog | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLog | undefined);
    get name(): string;
    get streams(): string[];
    get xPathQueries(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLogOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSourcesWindowsFirewallLog {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesWindowsFirewallLogToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesWindowsFirewallLog): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesWindowsFirewallLogToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSourcesWindowsFirewallLog): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesWindowsFirewallLogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSourcesWindowsFirewallLog | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSourcesWindowsFirewallLog | undefined);
    get name(): string;
    get streams(): string[];
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesWindowsFirewallLogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesWindowsFirewallLogOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDataSources {
}
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSources): any;
export declare function dataAzurermMonitorDataCollectionRuleDataSourcesToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDataSources): any;
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDataSources | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDataSources | undefined);
    private _dataImport;
    get dataImport(): DataAzurermMonitorDataCollectionRuleDataSourcesDataImportList;
    private _extension;
    get extension(): DataAzurermMonitorDataCollectionRuleDataSourcesExtensionList;
    private _iisLog;
    get iisLog(): DataAzurermMonitorDataCollectionRuleDataSourcesIisLogList;
    private _logFile;
    get logFile(): DataAzurermMonitorDataCollectionRuleDataSourcesLogFileList;
    private _performanceCounter;
    get performanceCounter(): DataAzurermMonitorDataCollectionRuleDataSourcesPerformanceCounterList;
    private _platformTelemetry;
    get platformTelemetry(): DataAzurermMonitorDataCollectionRuleDataSourcesPlatformTelemetryList;
    private _prometheusForwarder;
    get prometheusForwarder(): DataAzurermMonitorDataCollectionRuleDataSourcesPrometheusForwarderList;
    private _syslog;
    get syslog(): DataAzurermMonitorDataCollectionRuleDataSourcesSyslogList;
    private _windowsEventLog;
    get windowsEventLog(): DataAzurermMonitorDataCollectionRuleDataSourcesWindowsEventLogList;
    private _windowsFirewallLog;
    get windowsFirewallLog(): DataAzurermMonitorDataCollectionRuleDataSourcesWindowsFirewallLogList;
}
export declare class DataAzurermMonitorDataCollectionRuleDataSourcesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDataSourcesOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetrics {
}
export declare function dataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetricsToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetrics): any;
export declare function dataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetricsToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetrics): any;
export declare class DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetricsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetrics | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetrics | undefined);
    get name(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetricsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetricsOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDestinationsEventHub {
}
export declare function dataAzurermMonitorDataCollectionRuleDestinationsEventHubToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsEventHub): any;
export declare function dataAzurermMonitorDataCollectionRuleDestinationsEventHubToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsEventHub): any;
export declare class DataAzurermMonitorDataCollectionRuleDestinationsEventHubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDestinationsEventHub | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDestinationsEventHub | undefined);
    get eventHubId(): string;
    get name(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDestinationsEventHubList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDestinationsEventHubOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDestinationsEventHubDirect {
}
export declare function dataAzurermMonitorDataCollectionRuleDestinationsEventHubDirectToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsEventHubDirect): any;
export declare function dataAzurermMonitorDataCollectionRuleDestinationsEventHubDirectToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsEventHubDirect): any;
export declare class DataAzurermMonitorDataCollectionRuleDestinationsEventHubDirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDestinationsEventHubDirect | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDestinationsEventHubDirect | undefined);
    get eventHubId(): string;
    get name(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDestinationsEventHubDirectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDestinationsEventHubDirectOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDestinationsLogAnalytics {
}
export declare function dataAzurermMonitorDataCollectionRuleDestinationsLogAnalyticsToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsLogAnalytics): any;
export declare function dataAzurermMonitorDataCollectionRuleDestinationsLogAnalyticsToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsLogAnalytics): any;
export declare class DataAzurermMonitorDataCollectionRuleDestinationsLogAnalyticsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDestinationsLogAnalytics | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDestinationsLogAnalytics | undefined);
    get name(): string;
    get workspaceResourceId(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDestinationsLogAnalyticsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDestinationsLogAnalyticsOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDestinationsMonitorAccount {
}
export declare function dataAzurermMonitorDataCollectionRuleDestinationsMonitorAccountToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsMonitorAccount): any;
export declare function dataAzurermMonitorDataCollectionRuleDestinationsMonitorAccountToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsMonitorAccount): any;
export declare class DataAzurermMonitorDataCollectionRuleDestinationsMonitorAccountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDestinationsMonitorAccount | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDestinationsMonitorAccount | undefined);
    get monitorAccountId(): string;
    get name(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDestinationsMonitorAccountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDestinationsMonitorAccountOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDestinationsStorageBlob {
}
export declare function dataAzurermMonitorDataCollectionRuleDestinationsStorageBlobToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsStorageBlob): any;
export declare function dataAzurermMonitorDataCollectionRuleDestinationsStorageBlobToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsStorageBlob): any;
export declare class DataAzurermMonitorDataCollectionRuleDestinationsStorageBlobOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDestinationsStorageBlob | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDestinationsStorageBlob | undefined);
    get containerName(): string;
    get name(): string;
    get storageAccountId(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDestinationsStorageBlobList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDestinationsStorageBlobOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDestinationsStorageBlobDirect {
}
export declare function dataAzurermMonitorDataCollectionRuleDestinationsStorageBlobDirectToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsStorageBlobDirect): any;
export declare function dataAzurermMonitorDataCollectionRuleDestinationsStorageBlobDirectToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsStorageBlobDirect): any;
export declare class DataAzurermMonitorDataCollectionRuleDestinationsStorageBlobDirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDestinationsStorageBlobDirect | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDestinationsStorageBlobDirect | undefined);
    get containerName(): string;
    get name(): string;
    get storageAccountId(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDestinationsStorageBlobDirectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDestinationsStorageBlobDirectOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDestinationsStorageTableDirect {
}
export declare function dataAzurermMonitorDataCollectionRuleDestinationsStorageTableDirectToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsStorageTableDirect): any;
export declare function dataAzurermMonitorDataCollectionRuleDestinationsStorageTableDirectToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinationsStorageTableDirect): any;
export declare class DataAzurermMonitorDataCollectionRuleDestinationsStorageTableDirectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDestinationsStorageTableDirect | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDestinationsStorageTableDirect | undefined);
    get name(): string;
    get storageAccountId(): string;
    get tableName(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleDestinationsStorageTableDirectList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDestinationsStorageTableDirectOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleDestinations {
}
export declare function dataAzurermMonitorDataCollectionRuleDestinationsToTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinations): any;
export declare function dataAzurermMonitorDataCollectionRuleDestinationsToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleDestinations): any;
export declare class DataAzurermMonitorDataCollectionRuleDestinationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleDestinations | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleDestinations | undefined);
    private _azureMonitorMetrics;
    get azureMonitorMetrics(): DataAzurermMonitorDataCollectionRuleDestinationsAzureMonitorMetricsList;
    private _eventHub;
    get eventHub(): DataAzurermMonitorDataCollectionRuleDestinationsEventHubList;
    private _eventHubDirect;
    get eventHubDirect(): DataAzurermMonitorDataCollectionRuleDestinationsEventHubDirectList;
    private _logAnalytics;
    get logAnalytics(): DataAzurermMonitorDataCollectionRuleDestinationsLogAnalyticsList;
    private _monitorAccount;
    get monitorAccount(): DataAzurermMonitorDataCollectionRuleDestinationsMonitorAccountList;
    private _storageBlob;
    get storageBlob(): DataAzurermMonitorDataCollectionRuleDestinationsStorageBlobList;
    private _storageBlobDirect;
    get storageBlobDirect(): DataAzurermMonitorDataCollectionRuleDestinationsStorageBlobDirectList;
    private _storageTableDirect;
    get storageTableDirect(): DataAzurermMonitorDataCollectionRuleDestinationsStorageTableDirectList;
}
export declare class DataAzurermMonitorDataCollectionRuleDestinationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleDestinationsOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleIdentity {
}
export declare function dataAzurermMonitorDataCollectionRuleIdentityToTerraform(struct?: DataAzurermMonitorDataCollectionRuleIdentity): any;
export declare function dataAzurermMonitorDataCollectionRuleIdentityToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleIdentity): any;
export declare class DataAzurermMonitorDataCollectionRuleIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleIdentity | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleIdentityOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleStreamDeclarationColumn {
}
export declare function dataAzurermMonitorDataCollectionRuleStreamDeclarationColumnToTerraform(struct?: DataAzurermMonitorDataCollectionRuleStreamDeclarationColumn): any;
export declare function dataAzurermMonitorDataCollectionRuleStreamDeclarationColumnToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleStreamDeclarationColumn): any;
export declare class DataAzurermMonitorDataCollectionRuleStreamDeclarationColumnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleStreamDeclarationColumn | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleStreamDeclarationColumn | undefined);
    get name(): string;
    get type(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleStreamDeclarationColumnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleStreamDeclarationColumnOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleStreamDeclaration {
}
export declare function dataAzurermMonitorDataCollectionRuleStreamDeclarationToTerraform(struct?: DataAzurermMonitorDataCollectionRuleStreamDeclaration): any;
export declare function dataAzurermMonitorDataCollectionRuleStreamDeclarationToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleStreamDeclaration): any;
export declare class DataAzurermMonitorDataCollectionRuleStreamDeclarationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMonitorDataCollectionRuleStreamDeclaration | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleStreamDeclaration | undefined);
    private _column;
    get column(): DataAzurermMonitorDataCollectionRuleStreamDeclarationColumnList;
    get streamName(): string;
}
export declare class DataAzurermMonitorDataCollectionRuleStreamDeclarationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMonitorDataCollectionRuleStreamDeclarationOutputReference;
}
export interface DataAzurermMonitorDataCollectionRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/monitor_data_collection_rule#read DataAzurermMonitorDataCollectionRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMonitorDataCollectionRuleTimeoutsToTerraform(struct?: DataAzurermMonitorDataCollectionRuleTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMonitorDataCollectionRuleTimeoutsToHclTerraform(struct?: DataAzurermMonitorDataCollectionRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMonitorDataCollectionRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMonitorDataCollectionRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMonitorDataCollectionRuleTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/monitor_data_collection_rule azurerm_monitor_data_collection_rule}
*/
export declare class DataAzurermMonitorDataCollectionRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_monitor_data_collection_rule";
    /**
    * Generates CDKTF code for importing a DataAzurermMonitorDataCollectionRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMonitorDataCollectionRule to import
    * @param importFromId The id of the existing DataAzurermMonitorDataCollectionRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/monitor_data_collection_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMonitorDataCollectionRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/monitor_data_collection_rule azurerm_monitor_data_collection_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMonitorDataCollectionRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorDataCollectionRuleConfig);
    get dataCollectionEndpointId(): string;
    private _dataFlow;
    get dataFlow(): DataAzurermMonitorDataCollectionRuleDataFlowList;
    private _dataSources;
    get dataSources(): DataAzurermMonitorDataCollectionRuleDataSourcesList;
    get description(): string;
    private _destinations;
    get destinations(): DataAzurermMonitorDataCollectionRuleDestinationsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermMonitorDataCollectionRuleIdentityList;
    get immutableId(): string;
    get kind(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _streamDeclaration;
    get streamDeclaration(): DataAzurermMonitorDataCollectionRuleStreamDeclarationList;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermMonitorDataCollectionRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMonitorDataCollectionRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMonitorDataCollectionRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
