/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMssqlElasticpoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/mssql_elasticpool#id DataAzurermMssqlElasticpool#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/mssql_elasticpool#name DataAzurermMssqlElasticpool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/mssql_elasticpool#resource_group_name DataAzurermMssqlElasticpool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/mssql_elasticpool#server_name DataAzurermMssqlElasticpool#server_name}
    */
    readonly serverName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/mssql_elasticpool#timeouts DataAzurermMssqlElasticpool#timeouts}
    */
    readonly timeouts?: DataAzurermMssqlElasticpoolTimeouts;
}
export interface DataAzurermMssqlElasticpoolSku {
}
export declare function dataAzurermMssqlElasticpoolSkuToTerraform(struct?: DataAzurermMssqlElasticpoolSku): any;
export declare function dataAzurermMssqlElasticpoolSkuToHclTerraform(struct?: DataAzurermMssqlElasticpoolSku): any;
export declare class DataAzurermMssqlElasticpoolSkuOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMssqlElasticpoolSku | undefined;
    set internalValue(value: DataAzurermMssqlElasticpoolSku | undefined);
    get capacity(): number;
    get family(): string;
    get name(): string;
    get tier(): string;
}
export declare class DataAzurermMssqlElasticpoolSkuList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMssqlElasticpoolSkuOutputReference;
}
export interface DataAzurermMssqlElasticpoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/mssql_elasticpool#read DataAzurermMssqlElasticpool#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMssqlElasticpoolTimeoutsToTerraform(struct?: DataAzurermMssqlElasticpoolTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMssqlElasticpoolTimeoutsToHclTerraform(struct?: DataAzurermMssqlElasticpoolTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMssqlElasticpoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMssqlElasticpoolTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMssqlElasticpoolTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/mssql_elasticpool azurerm_mssql_elasticpool}
*/
export declare class DataAzurermMssqlElasticpool extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mssql_elasticpool";
    /**
    * Generates CDKTF code for importing a DataAzurermMssqlElasticpool resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMssqlElasticpool to import
    * @param importFromId The id of the existing DataAzurermMssqlElasticpool that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/mssql_elasticpool#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMssqlElasticpool to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/mssql_elasticpool azurerm_mssql_elasticpool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMssqlElasticpoolConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMssqlElasticpoolConfig);
    get enclaveType(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get licenseType(): string;
    get location(): string;
    get maxSizeBytes(): number;
    get maxSizeGb(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get perDbMaxCapacity(): number;
    get perDbMinCapacity(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serverName?;
    get serverName(): string;
    set serverName(value: string);
    get serverNameInput(): string | undefined;
    private _sku;
    get sku(): DataAzurermMssqlElasticpoolSkuList;
    private _tags;
    get tags(): cdktf.StringMap;
    get zoneRedundant(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermMssqlElasticpoolTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMssqlElasticpoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMssqlElasticpoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
