/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetappAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/netapp_account#id DataAzurermNetappAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/netapp_account#name DataAzurermNetappAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/netapp_account#resource_group_name DataAzurermNetappAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/netapp_account#identity DataAzurermNetappAccount#identity}
    */
    readonly identity?: DataAzurermNetappAccountIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/netapp_account#timeouts DataAzurermNetappAccount#timeouts}
    */
    readonly timeouts?: DataAzurermNetappAccountTimeouts;
}
export interface DataAzurermNetappAccountIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/netapp_account#identity_ids DataAzurermNetappAccount#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/netapp_account#type DataAzurermNetappAccount#type}
    */
    readonly type: string;
}
export declare function dataAzurermNetappAccountIdentityToTerraform(struct?: DataAzurermNetappAccountIdentityOutputReference | DataAzurermNetappAccountIdentity): any;
export declare function dataAzurermNetappAccountIdentityToHclTerraform(struct?: DataAzurermNetappAccountIdentityOutputReference | DataAzurermNetappAccountIdentity): any;
export declare class DataAzurermNetappAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetappAccountIdentity | undefined;
    set internalValue(value: DataAzurermNetappAccountIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface DataAzurermNetappAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/netapp_account#read DataAzurermNetappAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetappAccountTimeoutsToTerraform(struct?: DataAzurermNetappAccountTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermNetappAccountTimeoutsToHclTerraform(struct?: DataAzurermNetappAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetappAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermNetappAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermNetappAccountTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/netapp_account azurerm_netapp_account}
*/
export declare class DataAzurermNetappAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_netapp_account";
    /**
    * Generates CDKTF code for importing a DataAzurermNetappAccount resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermNetappAccount to import
    * @param importFromId The id of the existing DataAzurermNetappAccount that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/netapp_account#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermNetappAccount to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/netapp_account azurerm_netapp_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetappAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetappAccountConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _identity;
    get identity(): DataAzurermNetappAccountIdentityOutputReference;
    putIdentity(value: DataAzurermNetappAccountIdentity): void;
    resetIdentity(): void;
    get identityInput(): DataAzurermNetappAccountIdentity | undefined;
    private _timeouts;
    get timeouts(): DataAzurermNetappAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetappAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermNetappAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
