/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPrivateDnsTxtRecordConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/private_dns_txt_record#id DataAzurermPrivateDnsTxtRecord#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/private_dns_txt_record#name DataAzurermPrivateDnsTxtRecord#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/private_dns_txt_record#resource_group_name DataAzurermPrivateDnsTxtRecord#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/private_dns_txt_record#zone_name DataAzurermPrivateDnsTxtRecord#zone_name}
    */
    readonly zoneName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/private_dns_txt_record#timeouts DataAzurermPrivateDnsTxtRecord#timeouts}
    */
    readonly timeouts?: DataAzurermPrivateDnsTxtRecordTimeouts;
}
export interface DataAzurermPrivateDnsTxtRecordRecord {
}
export declare function dataAzurermPrivateDnsTxtRecordRecordToTerraform(struct?: DataAzurermPrivateDnsTxtRecordRecord): any;
export declare function dataAzurermPrivateDnsTxtRecordRecordToHclTerraform(struct?: DataAzurermPrivateDnsTxtRecordRecord): any;
export declare class DataAzurermPrivateDnsTxtRecordRecordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermPrivateDnsTxtRecordRecord | undefined;
    set internalValue(value: DataAzurermPrivateDnsTxtRecordRecord | undefined);
    get value(): string;
}
export declare class DataAzurermPrivateDnsTxtRecordRecordList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermPrivateDnsTxtRecordRecordOutputReference;
}
export interface DataAzurermPrivateDnsTxtRecordTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/private_dns_txt_record#read DataAzurermPrivateDnsTxtRecord#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPrivateDnsTxtRecordTimeoutsToTerraform(struct?: DataAzurermPrivateDnsTxtRecordTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermPrivateDnsTxtRecordTimeoutsToHclTerraform(struct?: DataAzurermPrivateDnsTxtRecordTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPrivateDnsTxtRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermPrivateDnsTxtRecordTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermPrivateDnsTxtRecordTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/private_dns_txt_record azurerm_private_dns_txt_record}
*/
export declare class DataAzurermPrivateDnsTxtRecord extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_private_dns_txt_record";
    /**
    * Generates CDKTF code for importing a DataAzurermPrivateDnsTxtRecord resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermPrivateDnsTxtRecord to import
    * @param importFromId The id of the existing DataAzurermPrivateDnsTxtRecord that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/private_dns_txt_record#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermPrivateDnsTxtRecord to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/private_dns_txt_record azurerm_private_dns_txt_record} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPrivateDnsTxtRecordConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermPrivateDnsTxtRecordConfig);
    get fqdn(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _record;
    get record(): DataAzurermPrivateDnsTxtRecordRecordList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get ttl(): number;
    private _zoneName?;
    get zoneName(): string;
    set zoneName(value: string);
    get zoneNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermPrivateDnsTxtRecordTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPrivateDnsTxtRecordTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermPrivateDnsTxtRecordTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
