/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSharedImageGalleryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/shared_image_gallery#id DataAzurermSharedImageGallery#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/shared_image_gallery#name DataAzurermSharedImageGallery#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/shared_image_gallery#resource_group_name DataAzurermSharedImageGallery#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/shared_image_gallery#timeouts DataAzurermSharedImageGallery#timeouts}
    */
    readonly timeouts?: DataAzurermSharedImageGalleryTimeouts;
}
export interface DataAzurermSharedImageGalleryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/shared_image_gallery#read DataAzurermSharedImageGallery#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSharedImageGalleryTimeoutsToTerraform(struct?: DataAzurermSharedImageGalleryTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermSharedImageGalleryTimeoutsToHclTerraform(struct?: DataAzurermSharedImageGalleryTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSharedImageGalleryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSharedImageGalleryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSharedImageGalleryTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/shared_image_gallery azurerm_shared_image_gallery}
*/
export declare class DataAzurermSharedImageGallery extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_shared_image_gallery";
    /**
    * Generates CDKTF code for importing a DataAzurermSharedImageGallery resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSharedImageGallery to import
    * @param importFromId The id of the existing DataAzurermSharedImageGallery that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/shared_image_gallery#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSharedImageGallery to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/shared_image_gallery azurerm_shared_image_gallery} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSharedImageGalleryConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSharedImageGalleryConfig);
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get imageNames(): string[];
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get uniqueName(): string;
    private _timeouts;
    get timeouts(): DataAzurermSharedImageGalleryTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSharedImageGalleryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSharedImageGalleryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
