/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/subscription#id DataAzurermSubscription#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/subscription#subscription_id DataAzurermSubscription#subscription_id}
    */
    readonly subscriptionId?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/subscription#timeouts DataAzurermSubscription#timeouts}
    */
    readonly timeouts?: DataAzurermSubscriptionTimeouts;
}
export interface DataAzurermSubscriptionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/subscription#read DataAzurermSubscription#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSubscriptionTimeoutsToTerraform(struct?: DataAzurermSubscriptionTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermSubscriptionTimeoutsToHclTerraform(struct?: DataAzurermSubscriptionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSubscriptionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSubscriptionTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/subscription azurerm_subscription}
*/
export declare class DataAzurermSubscription extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_subscription";
    /**
    * Generates CDKTF code for importing a DataAzurermSubscription resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSubscription to import
    * @param importFromId The id of the existing DataAzurermSubscription that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/subscription#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSubscription to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/data-sources/subscription azurerm_subscription} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSubscriptionConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermSubscriptionConfig);
    get displayName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get locationPlacementId(): string;
    get quotaId(): string;
    get spendingLimit(): string;
    get state(): string;
    private _subscriptionId?;
    get subscriptionId(): string;
    set subscriptionId(value: string);
    resetSubscriptionId(): void;
    get subscriptionIdInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    get tenantId(): string;
    private _timeouts;
    get timeouts(): DataAzurermSubscriptionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSubscriptionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSubscriptionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
