/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryDataFlowConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#annotations DataFactoryDataFlow#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#data_factory_id DataFactoryDataFlow#data_factory_id}
    */
    readonly dataFactoryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#description DataFactoryDataFlow#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#folder DataFactoryDataFlow#folder}
    */
    readonly folder?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#id DataFactoryDataFlow#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#script DataFactoryDataFlow#script}
    */
    readonly script?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#script_lines DataFactoryDataFlow#script_lines}
    */
    readonly scriptLines?: string[];
    /**
    * sink block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#sink DataFactoryDataFlow#sink}
    */
    readonly sink: DataFactoryDataFlowSink[] | cdktf.IResolvable;
    /**
    * source block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#source DataFactoryDataFlow#source}
    */
    readonly source: DataFactoryDataFlowSource[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#timeouts DataFactoryDataFlow#timeouts}
    */
    readonly timeouts?: DataFactoryDataFlowTimeouts;
    /**
    * transformation block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#transformation DataFactoryDataFlow#transformation}
    */
    readonly transformation?: DataFactoryDataFlowTransformation[] | cdktf.IResolvable;
}
export interface DataFactoryDataFlowSinkDataset {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#parameters DataFactoryDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryDataFlowSinkDatasetToTerraform(struct?: DataFactoryDataFlowSinkDatasetOutputReference | DataFactoryDataFlowSinkDataset): any;
export declare function dataFactoryDataFlowSinkDatasetToHclTerraform(struct?: DataFactoryDataFlowSinkDatasetOutputReference | DataFactoryDataFlowSinkDataset): any;
export declare class DataFactoryDataFlowSinkDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowSinkDataset | undefined;
    set internalValue(value: DataFactoryDataFlowSinkDataset | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryDataFlowSinkFlowlet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#dataset_parameters DataFactoryDataFlow#dataset_parameters}
    */
    readonly datasetParameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#parameters DataFactoryDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryDataFlowSinkFlowletToTerraform(struct?: DataFactoryDataFlowSinkFlowletOutputReference | DataFactoryDataFlowSinkFlowlet): any;
export declare function dataFactoryDataFlowSinkFlowletToHclTerraform(struct?: DataFactoryDataFlowSinkFlowletOutputReference | DataFactoryDataFlowSinkFlowlet): any;
export declare class DataFactoryDataFlowSinkFlowletOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowSinkFlowlet | undefined;
    set internalValue(value: DataFactoryDataFlowSinkFlowlet | undefined);
    private _datasetParameters?;
    get datasetParameters(): string;
    set datasetParameters(value: string);
    resetDatasetParameters(): void;
    get datasetParametersInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryDataFlowSinkLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#parameters DataFactoryDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryDataFlowSinkLinkedServiceToTerraform(struct?: DataFactoryDataFlowSinkLinkedServiceOutputReference | DataFactoryDataFlowSinkLinkedService): any;
export declare function dataFactoryDataFlowSinkLinkedServiceToHclTerraform(struct?: DataFactoryDataFlowSinkLinkedServiceOutputReference | DataFactoryDataFlowSinkLinkedService): any;
export declare class DataFactoryDataFlowSinkLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowSinkLinkedService | undefined;
    set internalValue(value: DataFactoryDataFlowSinkLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryDataFlowSinkRejectedLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#parameters DataFactoryDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryDataFlowSinkRejectedLinkedServiceToTerraform(struct?: DataFactoryDataFlowSinkRejectedLinkedServiceOutputReference | DataFactoryDataFlowSinkRejectedLinkedService): any;
export declare function dataFactoryDataFlowSinkRejectedLinkedServiceToHclTerraform(struct?: DataFactoryDataFlowSinkRejectedLinkedServiceOutputReference | DataFactoryDataFlowSinkRejectedLinkedService): any;
export declare class DataFactoryDataFlowSinkRejectedLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowSinkRejectedLinkedService | undefined;
    set internalValue(value: DataFactoryDataFlowSinkRejectedLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryDataFlowSinkSchemaLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#parameters DataFactoryDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryDataFlowSinkSchemaLinkedServiceToTerraform(struct?: DataFactoryDataFlowSinkSchemaLinkedServiceOutputReference | DataFactoryDataFlowSinkSchemaLinkedService): any;
export declare function dataFactoryDataFlowSinkSchemaLinkedServiceToHclTerraform(struct?: DataFactoryDataFlowSinkSchemaLinkedServiceOutputReference | DataFactoryDataFlowSinkSchemaLinkedService): any;
export declare class DataFactoryDataFlowSinkSchemaLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowSinkSchemaLinkedService | undefined;
    set internalValue(value: DataFactoryDataFlowSinkSchemaLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryDataFlowSink {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#description DataFactoryDataFlow#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#dataset DataFactoryDataFlow#dataset}
    */
    readonly dataset?: DataFactoryDataFlowSinkDataset;
    /**
    * flowlet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#flowlet DataFactoryDataFlow#flowlet}
    */
    readonly flowlet?: DataFactoryDataFlowSinkFlowlet;
    /**
    * linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#linked_service DataFactoryDataFlow#linked_service}
    */
    readonly linkedService?: DataFactoryDataFlowSinkLinkedService;
    /**
    * rejected_linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#rejected_linked_service DataFactoryDataFlow#rejected_linked_service}
    */
    readonly rejectedLinkedService?: DataFactoryDataFlowSinkRejectedLinkedService;
    /**
    * schema_linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#schema_linked_service DataFactoryDataFlow#schema_linked_service}
    */
    readonly schemaLinkedService?: DataFactoryDataFlowSinkSchemaLinkedService;
}
export declare function dataFactoryDataFlowSinkToTerraform(struct?: DataFactoryDataFlowSink | cdktf.IResolvable): any;
export declare function dataFactoryDataFlowSinkToHclTerraform(struct?: DataFactoryDataFlowSink | cdktf.IResolvable): any;
export declare class DataFactoryDataFlowSinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryDataFlowSink | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryDataFlowSink | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _dataset;
    get dataset(): DataFactoryDataFlowSinkDatasetOutputReference;
    putDataset(value: DataFactoryDataFlowSinkDataset): void;
    resetDataset(): void;
    get datasetInput(): DataFactoryDataFlowSinkDataset | undefined;
    private _flowlet;
    get flowlet(): DataFactoryDataFlowSinkFlowletOutputReference;
    putFlowlet(value: DataFactoryDataFlowSinkFlowlet): void;
    resetFlowlet(): void;
    get flowletInput(): DataFactoryDataFlowSinkFlowlet | undefined;
    private _linkedService;
    get linkedService(): DataFactoryDataFlowSinkLinkedServiceOutputReference;
    putLinkedService(value: DataFactoryDataFlowSinkLinkedService): void;
    resetLinkedService(): void;
    get linkedServiceInput(): DataFactoryDataFlowSinkLinkedService | undefined;
    private _rejectedLinkedService;
    get rejectedLinkedService(): DataFactoryDataFlowSinkRejectedLinkedServiceOutputReference;
    putRejectedLinkedService(value: DataFactoryDataFlowSinkRejectedLinkedService): void;
    resetRejectedLinkedService(): void;
    get rejectedLinkedServiceInput(): DataFactoryDataFlowSinkRejectedLinkedService | undefined;
    private _schemaLinkedService;
    get schemaLinkedService(): DataFactoryDataFlowSinkSchemaLinkedServiceOutputReference;
    putSchemaLinkedService(value: DataFactoryDataFlowSinkSchemaLinkedService): void;
    resetSchemaLinkedService(): void;
    get schemaLinkedServiceInput(): DataFactoryDataFlowSinkSchemaLinkedService | undefined;
}
export declare class DataFactoryDataFlowSinkList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryDataFlowSink[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryDataFlowSinkOutputReference;
}
export interface DataFactoryDataFlowSourceDataset {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#parameters DataFactoryDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryDataFlowSourceDatasetToTerraform(struct?: DataFactoryDataFlowSourceDatasetOutputReference | DataFactoryDataFlowSourceDataset): any;
export declare function dataFactoryDataFlowSourceDatasetToHclTerraform(struct?: DataFactoryDataFlowSourceDatasetOutputReference | DataFactoryDataFlowSourceDataset): any;
export declare class DataFactoryDataFlowSourceDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowSourceDataset | undefined;
    set internalValue(value: DataFactoryDataFlowSourceDataset | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryDataFlowSourceFlowlet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#dataset_parameters DataFactoryDataFlow#dataset_parameters}
    */
    readonly datasetParameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#parameters DataFactoryDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryDataFlowSourceFlowletToTerraform(struct?: DataFactoryDataFlowSourceFlowletOutputReference | DataFactoryDataFlowSourceFlowlet): any;
export declare function dataFactoryDataFlowSourceFlowletToHclTerraform(struct?: DataFactoryDataFlowSourceFlowletOutputReference | DataFactoryDataFlowSourceFlowlet): any;
export declare class DataFactoryDataFlowSourceFlowletOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowSourceFlowlet | undefined;
    set internalValue(value: DataFactoryDataFlowSourceFlowlet | undefined);
    private _datasetParameters?;
    get datasetParameters(): string;
    set datasetParameters(value: string);
    resetDatasetParameters(): void;
    get datasetParametersInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryDataFlowSourceLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#parameters DataFactoryDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryDataFlowSourceLinkedServiceToTerraform(struct?: DataFactoryDataFlowSourceLinkedServiceOutputReference | DataFactoryDataFlowSourceLinkedService): any;
export declare function dataFactoryDataFlowSourceLinkedServiceToHclTerraform(struct?: DataFactoryDataFlowSourceLinkedServiceOutputReference | DataFactoryDataFlowSourceLinkedService): any;
export declare class DataFactoryDataFlowSourceLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowSourceLinkedService | undefined;
    set internalValue(value: DataFactoryDataFlowSourceLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryDataFlowSourceRejectedLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#parameters DataFactoryDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryDataFlowSourceRejectedLinkedServiceToTerraform(struct?: DataFactoryDataFlowSourceRejectedLinkedServiceOutputReference | DataFactoryDataFlowSourceRejectedLinkedService): any;
export declare function dataFactoryDataFlowSourceRejectedLinkedServiceToHclTerraform(struct?: DataFactoryDataFlowSourceRejectedLinkedServiceOutputReference | DataFactoryDataFlowSourceRejectedLinkedService): any;
export declare class DataFactoryDataFlowSourceRejectedLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowSourceRejectedLinkedService | undefined;
    set internalValue(value: DataFactoryDataFlowSourceRejectedLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryDataFlowSourceSchemaLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#parameters DataFactoryDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryDataFlowSourceSchemaLinkedServiceToTerraform(struct?: DataFactoryDataFlowSourceSchemaLinkedServiceOutputReference | DataFactoryDataFlowSourceSchemaLinkedService): any;
export declare function dataFactoryDataFlowSourceSchemaLinkedServiceToHclTerraform(struct?: DataFactoryDataFlowSourceSchemaLinkedServiceOutputReference | DataFactoryDataFlowSourceSchemaLinkedService): any;
export declare class DataFactoryDataFlowSourceSchemaLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowSourceSchemaLinkedService | undefined;
    set internalValue(value: DataFactoryDataFlowSourceSchemaLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryDataFlowSource {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#description DataFactoryDataFlow#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#dataset DataFactoryDataFlow#dataset}
    */
    readonly dataset?: DataFactoryDataFlowSourceDataset;
    /**
    * flowlet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#flowlet DataFactoryDataFlow#flowlet}
    */
    readonly flowlet?: DataFactoryDataFlowSourceFlowlet;
    /**
    * linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#linked_service DataFactoryDataFlow#linked_service}
    */
    readonly linkedService?: DataFactoryDataFlowSourceLinkedService;
    /**
    * rejected_linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#rejected_linked_service DataFactoryDataFlow#rejected_linked_service}
    */
    readonly rejectedLinkedService?: DataFactoryDataFlowSourceRejectedLinkedService;
    /**
    * schema_linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#schema_linked_service DataFactoryDataFlow#schema_linked_service}
    */
    readonly schemaLinkedService?: DataFactoryDataFlowSourceSchemaLinkedService;
}
export declare function dataFactoryDataFlowSourceToTerraform(struct?: DataFactoryDataFlowSource | cdktf.IResolvable): any;
export declare function dataFactoryDataFlowSourceToHclTerraform(struct?: DataFactoryDataFlowSource | cdktf.IResolvable): any;
export declare class DataFactoryDataFlowSourceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryDataFlowSource | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryDataFlowSource | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _dataset;
    get dataset(): DataFactoryDataFlowSourceDatasetOutputReference;
    putDataset(value: DataFactoryDataFlowSourceDataset): void;
    resetDataset(): void;
    get datasetInput(): DataFactoryDataFlowSourceDataset | undefined;
    private _flowlet;
    get flowlet(): DataFactoryDataFlowSourceFlowletOutputReference;
    putFlowlet(value: DataFactoryDataFlowSourceFlowlet): void;
    resetFlowlet(): void;
    get flowletInput(): DataFactoryDataFlowSourceFlowlet | undefined;
    private _linkedService;
    get linkedService(): DataFactoryDataFlowSourceLinkedServiceOutputReference;
    putLinkedService(value: DataFactoryDataFlowSourceLinkedService): void;
    resetLinkedService(): void;
    get linkedServiceInput(): DataFactoryDataFlowSourceLinkedService | undefined;
    private _rejectedLinkedService;
    get rejectedLinkedService(): DataFactoryDataFlowSourceRejectedLinkedServiceOutputReference;
    putRejectedLinkedService(value: DataFactoryDataFlowSourceRejectedLinkedService): void;
    resetRejectedLinkedService(): void;
    get rejectedLinkedServiceInput(): DataFactoryDataFlowSourceRejectedLinkedService | undefined;
    private _schemaLinkedService;
    get schemaLinkedService(): DataFactoryDataFlowSourceSchemaLinkedServiceOutputReference;
    putSchemaLinkedService(value: DataFactoryDataFlowSourceSchemaLinkedService): void;
    resetSchemaLinkedService(): void;
    get schemaLinkedServiceInput(): DataFactoryDataFlowSourceSchemaLinkedService | undefined;
}
export declare class DataFactoryDataFlowSourceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryDataFlowSource[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryDataFlowSourceOutputReference;
}
export interface DataFactoryDataFlowTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#create DataFactoryDataFlow#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#delete DataFactoryDataFlow#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#read DataFactoryDataFlow#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#update DataFactoryDataFlow#update}
    */
    readonly update?: string;
}
export declare function dataFactoryDataFlowTimeoutsToTerraform(struct?: DataFactoryDataFlowTimeouts | cdktf.IResolvable): any;
export declare function dataFactoryDataFlowTimeoutsToHclTerraform(struct?: DataFactoryDataFlowTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryDataFlowTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryDataFlowTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DataFactoryDataFlowTransformationDataset {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#parameters DataFactoryDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryDataFlowTransformationDatasetToTerraform(struct?: DataFactoryDataFlowTransformationDatasetOutputReference | DataFactoryDataFlowTransformationDataset): any;
export declare function dataFactoryDataFlowTransformationDatasetToHclTerraform(struct?: DataFactoryDataFlowTransformationDatasetOutputReference | DataFactoryDataFlowTransformationDataset): any;
export declare class DataFactoryDataFlowTransformationDatasetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowTransformationDataset | undefined;
    set internalValue(value: DataFactoryDataFlowTransformationDataset | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryDataFlowTransformationFlowlet {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#dataset_parameters DataFactoryDataFlow#dataset_parameters}
    */
    readonly datasetParameters?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#parameters DataFactoryDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryDataFlowTransformationFlowletToTerraform(struct?: DataFactoryDataFlowTransformationFlowletOutputReference | DataFactoryDataFlowTransformationFlowlet): any;
export declare function dataFactoryDataFlowTransformationFlowletToHclTerraform(struct?: DataFactoryDataFlowTransformationFlowletOutputReference | DataFactoryDataFlowTransformationFlowlet): any;
export declare class DataFactoryDataFlowTransformationFlowletOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowTransformationFlowlet | undefined;
    set internalValue(value: DataFactoryDataFlowTransformationFlowlet | undefined);
    private _datasetParameters?;
    get datasetParameters(): string;
    set datasetParameters(value: string);
    resetDatasetParameters(): void;
    get datasetParametersInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryDataFlowTransformationLinkedService {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#parameters DataFactoryDataFlow#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryDataFlowTransformationLinkedServiceToTerraform(struct?: DataFactoryDataFlowTransformationLinkedServiceOutputReference | DataFactoryDataFlowTransformationLinkedService): any;
export declare function dataFactoryDataFlowTransformationLinkedServiceToHclTerraform(struct?: DataFactoryDataFlowTransformationLinkedServiceOutputReference | DataFactoryDataFlowTransformationLinkedService): any;
export declare class DataFactoryDataFlowTransformationLinkedServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryDataFlowTransformationLinkedService | undefined;
    set internalValue(value: DataFactoryDataFlowTransformationLinkedService | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataFactoryDataFlowTransformation {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#description DataFactoryDataFlow#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#name DataFactoryDataFlow#name}
    */
    readonly name: string;
    /**
    * dataset block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#dataset DataFactoryDataFlow#dataset}
    */
    readonly dataset?: DataFactoryDataFlowTransformationDataset;
    /**
    * flowlet block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#flowlet DataFactoryDataFlow#flowlet}
    */
    readonly flowlet?: DataFactoryDataFlowTransformationFlowlet;
    /**
    * linked_service block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#linked_service DataFactoryDataFlow#linked_service}
    */
    readonly linkedService?: DataFactoryDataFlowTransformationLinkedService;
}
export declare function dataFactoryDataFlowTransformationToTerraform(struct?: DataFactoryDataFlowTransformation | cdktf.IResolvable): any;
export declare function dataFactoryDataFlowTransformationToHclTerraform(struct?: DataFactoryDataFlowTransformation | cdktf.IResolvable): any;
export declare class DataFactoryDataFlowTransformationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryDataFlowTransformation | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryDataFlowTransformation | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _dataset;
    get dataset(): DataFactoryDataFlowTransformationDatasetOutputReference;
    putDataset(value: DataFactoryDataFlowTransformationDataset): void;
    resetDataset(): void;
    get datasetInput(): DataFactoryDataFlowTransformationDataset | undefined;
    private _flowlet;
    get flowlet(): DataFactoryDataFlowTransformationFlowletOutputReference;
    putFlowlet(value: DataFactoryDataFlowTransformationFlowlet): void;
    resetFlowlet(): void;
    get flowletInput(): DataFactoryDataFlowTransformationFlowlet | undefined;
    private _linkedService;
    get linkedService(): DataFactoryDataFlowTransformationLinkedServiceOutputReference;
    putLinkedService(value: DataFactoryDataFlowTransformationLinkedService): void;
    resetLinkedService(): void;
    get linkedServiceInput(): DataFactoryDataFlowTransformationLinkedService | undefined;
}
export declare class DataFactoryDataFlowTransformationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryDataFlowTransformation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryDataFlowTransformationOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow azurerm_data_factory_data_flow}
*/
export declare class DataFactoryDataFlow extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_factory_data_flow";
    /**
    * Generates CDKTF code for importing a DataFactoryDataFlow resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataFactoryDataFlow to import
    * @param importFromId The id of the existing DataFactoryDataFlow that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataFactoryDataFlow to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_data_flow azurerm_data_factory_data_flow} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryDataFlowConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryDataFlowConfig);
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _folder?;
    get folder(): string;
    set folder(value: string);
    resetFolder(): void;
    get folderInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _script?;
    get script(): string;
    set script(value: string);
    resetScript(): void;
    get scriptInput(): string | undefined;
    private _scriptLines?;
    get scriptLines(): string[];
    set scriptLines(value: string[]);
    resetScriptLines(): void;
    get scriptLinesInput(): string[] | undefined;
    private _sink;
    get sink(): DataFactoryDataFlowSinkList;
    putSink(value: DataFactoryDataFlowSink[] | cdktf.IResolvable): void;
    get sinkInput(): cdktf.IResolvable | DataFactoryDataFlowSink[] | undefined;
    private _source;
    get source(): DataFactoryDataFlowSourceList;
    putSource(value: DataFactoryDataFlowSource[] | cdktf.IResolvable): void;
    get sourceInput(): cdktf.IResolvable | DataFactoryDataFlowSource[] | undefined;
    private _timeouts;
    get timeouts(): DataFactoryDataFlowTimeoutsOutputReference;
    putTimeouts(value: DataFactoryDataFlowTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataFactoryDataFlowTimeouts | undefined;
    private _transformation;
    get transformation(): DataFactoryDataFlowTransformationList;
    putTransformation(value: DataFactoryDataFlowTransformation[] | cdktf.IResolvable): void;
    resetTransformation(): void;
    get transformationInput(): cdktf.IResolvable | DataFactoryDataFlowTransformation[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
