/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataFactoryTriggerCustomEventConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#activated DataFactoryTriggerCustomEvent#activated}
    */
    readonly activated?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#additional_properties DataFactoryTriggerCustomEvent#additional_properties}
    */
    readonly additionalProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#annotations DataFactoryTriggerCustomEvent#annotations}
    */
    readonly annotations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#data_factory_id DataFactoryTriggerCustomEvent#data_factory_id}
    */
    readonly dataFactoryId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#description DataFactoryTriggerCustomEvent#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#eventgrid_topic_id DataFactoryTriggerCustomEvent#eventgrid_topic_id}
    */
    readonly eventgridTopicId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#events DataFactoryTriggerCustomEvent#events}
    */
    readonly events: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#id DataFactoryTriggerCustomEvent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#name DataFactoryTriggerCustomEvent#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#subject_begins_with DataFactoryTriggerCustomEvent#subject_begins_with}
    */
    readonly subjectBeginsWith?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#subject_ends_with DataFactoryTriggerCustomEvent#subject_ends_with}
    */
    readonly subjectEndsWith?: string;
    /**
    * pipeline block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#pipeline DataFactoryTriggerCustomEvent#pipeline}
    */
    readonly pipeline: DataFactoryTriggerCustomEventPipeline[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#timeouts DataFactoryTriggerCustomEvent#timeouts}
    */
    readonly timeouts?: DataFactoryTriggerCustomEventTimeouts;
}
export interface DataFactoryTriggerCustomEventPipeline {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#name DataFactoryTriggerCustomEvent#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#parameters DataFactoryTriggerCustomEvent#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function dataFactoryTriggerCustomEventPipelineToTerraform(struct?: DataFactoryTriggerCustomEventPipeline | cdktf.IResolvable): any;
export declare function dataFactoryTriggerCustomEventPipelineToHclTerraform(struct?: DataFactoryTriggerCustomEventPipeline | cdktf.IResolvable): any;
export declare class DataFactoryTriggerCustomEventPipelineOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataFactoryTriggerCustomEventPipeline | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryTriggerCustomEventPipeline | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class DataFactoryTriggerCustomEventPipelineList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataFactoryTriggerCustomEventPipeline[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataFactoryTriggerCustomEventPipelineOutputReference;
}
export interface DataFactoryTriggerCustomEventTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#create DataFactoryTriggerCustomEvent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#delete DataFactoryTriggerCustomEvent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#read DataFactoryTriggerCustomEvent#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#update DataFactoryTriggerCustomEvent#update}
    */
    readonly update?: string;
}
export declare function dataFactoryTriggerCustomEventTimeoutsToTerraform(struct?: DataFactoryTriggerCustomEventTimeouts | cdktf.IResolvable): any;
export declare function dataFactoryTriggerCustomEventTimeoutsToHclTerraform(struct?: DataFactoryTriggerCustomEventTimeouts | cdktf.IResolvable): any;
export declare class DataFactoryTriggerCustomEventTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataFactoryTriggerCustomEventTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataFactoryTriggerCustomEventTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event azurerm_data_factory_trigger_custom_event}
*/
export declare class DataFactoryTriggerCustomEvent extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_factory_trigger_custom_event";
    /**
    * Generates CDKTF code for importing a DataFactoryTriggerCustomEvent resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataFactoryTriggerCustomEvent to import
    * @param importFromId The id of the existing DataFactoryTriggerCustomEvent that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataFactoryTriggerCustomEvent to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/data_factory_trigger_custom_event azurerm_data_factory_trigger_custom_event} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataFactoryTriggerCustomEventConfig
    */
    constructor(scope: Construct, id: string, config: DataFactoryTriggerCustomEventConfig);
    private _activated?;
    get activated(): boolean | cdktf.IResolvable;
    set activated(value: boolean | cdktf.IResolvable);
    resetActivated(): void;
    get activatedInput(): boolean | cdktf.IResolvable | undefined;
    private _additionalProperties?;
    get additionalProperties(): {
        [key: string]: string;
    };
    set additionalProperties(value: {
        [key: string]: string;
    });
    resetAdditionalProperties(): void;
    get additionalPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    get annotations(): string[];
    set annotations(value: string[]);
    resetAnnotations(): void;
    get annotationsInput(): string[] | undefined;
    private _dataFactoryId?;
    get dataFactoryId(): string;
    set dataFactoryId(value: string);
    get dataFactoryIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _eventgridTopicId?;
    get eventgridTopicId(): string;
    set eventgridTopicId(value: string);
    get eventgridTopicIdInput(): string | undefined;
    private _events?;
    get events(): string[];
    set events(value: string[]);
    get eventsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _subjectBeginsWith?;
    get subjectBeginsWith(): string;
    set subjectBeginsWith(value: string);
    resetSubjectBeginsWith(): void;
    get subjectBeginsWithInput(): string | undefined;
    private _subjectEndsWith?;
    get subjectEndsWith(): string;
    set subjectEndsWith(value: string);
    resetSubjectEndsWith(): void;
    get subjectEndsWithInput(): string | undefined;
    private _pipeline;
    get pipeline(): DataFactoryTriggerCustomEventPipelineList;
    putPipeline(value: DataFactoryTriggerCustomEventPipeline[] | cdktf.IResolvable): void;
    get pipelineInput(): cdktf.IResolvable | DataFactoryTriggerCustomEventPipeline[] | undefined;
    private _timeouts;
    get timeouts(): DataFactoryTriggerCustomEventTimeoutsOutputReference;
    putTimeouts(value: DataFactoryTriggerCustomEventTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataFactoryTriggerCustomEventTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
