/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatabricksWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#customer_managed_key_enabled DatabricksWorkspace#customer_managed_key_enabled}
    */
    readonly customerManagedKeyEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#id DatabricksWorkspace#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#infrastructure_encryption_enabled DatabricksWorkspace#infrastructure_encryption_enabled}
    */
    readonly infrastructureEncryptionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#load_balancer_backend_address_pool_id DatabricksWorkspace#load_balancer_backend_address_pool_id}
    */
    readonly loadBalancerBackendAddressPoolId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#location DatabricksWorkspace#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#managed_disk_cmk_key_vault_id DatabricksWorkspace#managed_disk_cmk_key_vault_id}
    */
    readonly managedDiskCmkKeyVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#managed_disk_cmk_key_vault_key_id DatabricksWorkspace#managed_disk_cmk_key_vault_key_id}
    */
    readonly managedDiskCmkKeyVaultKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#managed_disk_cmk_rotation_to_latest_version_enabled DatabricksWorkspace#managed_disk_cmk_rotation_to_latest_version_enabled}
    */
    readonly managedDiskCmkRotationToLatestVersionEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#managed_resource_group_name DatabricksWorkspace#managed_resource_group_name}
    */
    readonly managedResourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#managed_services_cmk_key_vault_id DatabricksWorkspace#managed_services_cmk_key_vault_id}
    */
    readonly managedServicesCmkKeyVaultId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#managed_services_cmk_key_vault_key_id DatabricksWorkspace#managed_services_cmk_key_vault_key_id}
    */
    readonly managedServicesCmkKeyVaultKeyId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#name DatabricksWorkspace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#network_security_group_rules_required DatabricksWorkspace#network_security_group_rules_required}
    */
    readonly networkSecurityGroupRulesRequired?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#public_network_access_enabled DatabricksWorkspace#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#resource_group_name DatabricksWorkspace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#sku DatabricksWorkspace#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#tags DatabricksWorkspace#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * custom_parameters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#custom_parameters DatabricksWorkspace#custom_parameters}
    */
    readonly customParameters?: DatabricksWorkspaceCustomParameters;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#timeouts DatabricksWorkspace#timeouts}
    */
    readonly timeouts?: DatabricksWorkspaceTimeouts;
}
export interface DatabricksWorkspaceManagedDiskIdentity {
}
export declare function databricksWorkspaceManagedDiskIdentityToTerraform(struct?: DatabricksWorkspaceManagedDiskIdentity): any;
export declare function databricksWorkspaceManagedDiskIdentityToHclTerraform(struct?: DatabricksWorkspaceManagedDiskIdentity): any;
export declare class DatabricksWorkspaceManagedDiskIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabricksWorkspaceManagedDiskIdentity | undefined;
    set internalValue(value: DatabricksWorkspaceManagedDiskIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DatabricksWorkspaceManagedDiskIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabricksWorkspaceManagedDiskIdentityOutputReference;
}
export interface DatabricksWorkspaceStorageAccountIdentity {
}
export declare function databricksWorkspaceStorageAccountIdentityToTerraform(struct?: DatabricksWorkspaceStorageAccountIdentity): any;
export declare function databricksWorkspaceStorageAccountIdentityToHclTerraform(struct?: DatabricksWorkspaceStorageAccountIdentity): any;
export declare class DatabricksWorkspaceStorageAccountIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatabricksWorkspaceStorageAccountIdentity | undefined;
    set internalValue(value: DatabricksWorkspaceStorageAccountIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DatabricksWorkspaceStorageAccountIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatabricksWorkspaceStorageAccountIdentityOutputReference;
}
export interface DatabricksWorkspaceCustomParameters {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#machine_learning_workspace_id DatabricksWorkspace#machine_learning_workspace_id}
    */
    readonly machineLearningWorkspaceId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#nat_gateway_name DatabricksWorkspace#nat_gateway_name}
    */
    readonly natGatewayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#no_public_ip DatabricksWorkspace#no_public_ip}
    */
    readonly noPublicIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#private_subnet_name DatabricksWorkspace#private_subnet_name}
    */
    readonly privateSubnetName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#private_subnet_network_security_group_association_id DatabricksWorkspace#private_subnet_network_security_group_association_id}
    */
    readonly privateSubnetNetworkSecurityGroupAssociationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#public_ip_name DatabricksWorkspace#public_ip_name}
    */
    readonly publicIpName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#public_subnet_name DatabricksWorkspace#public_subnet_name}
    */
    readonly publicSubnetName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#public_subnet_network_security_group_association_id DatabricksWorkspace#public_subnet_network_security_group_association_id}
    */
    readonly publicSubnetNetworkSecurityGroupAssociationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#storage_account_name DatabricksWorkspace#storage_account_name}
    */
    readonly storageAccountName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#storage_account_sku_name DatabricksWorkspace#storage_account_sku_name}
    */
    readonly storageAccountSkuName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#virtual_network_id DatabricksWorkspace#virtual_network_id}
    */
    readonly virtualNetworkId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#vnet_address_prefix DatabricksWorkspace#vnet_address_prefix}
    */
    readonly vnetAddressPrefix?: string;
}
export declare function databricksWorkspaceCustomParametersToTerraform(struct?: DatabricksWorkspaceCustomParametersOutputReference | DatabricksWorkspaceCustomParameters): any;
export declare function databricksWorkspaceCustomParametersToHclTerraform(struct?: DatabricksWorkspaceCustomParametersOutputReference | DatabricksWorkspaceCustomParameters): any;
export declare class DatabricksWorkspaceCustomParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabricksWorkspaceCustomParameters | undefined;
    set internalValue(value: DatabricksWorkspaceCustomParameters | undefined);
    private _machineLearningWorkspaceId?;
    get machineLearningWorkspaceId(): string;
    set machineLearningWorkspaceId(value: string);
    resetMachineLearningWorkspaceId(): void;
    get machineLearningWorkspaceIdInput(): string | undefined;
    private _natGatewayName?;
    get natGatewayName(): string;
    set natGatewayName(value: string);
    resetNatGatewayName(): void;
    get natGatewayNameInput(): string | undefined;
    private _noPublicIp?;
    get noPublicIp(): boolean | cdktf.IResolvable;
    set noPublicIp(value: boolean | cdktf.IResolvable);
    resetNoPublicIp(): void;
    get noPublicIpInput(): boolean | cdktf.IResolvable | undefined;
    private _privateSubnetName?;
    get privateSubnetName(): string;
    set privateSubnetName(value: string);
    resetPrivateSubnetName(): void;
    get privateSubnetNameInput(): string | undefined;
    private _privateSubnetNetworkSecurityGroupAssociationId?;
    get privateSubnetNetworkSecurityGroupAssociationId(): string;
    set privateSubnetNetworkSecurityGroupAssociationId(value: string);
    resetPrivateSubnetNetworkSecurityGroupAssociationId(): void;
    get privateSubnetNetworkSecurityGroupAssociationIdInput(): string | undefined;
    private _publicIpName?;
    get publicIpName(): string;
    set publicIpName(value: string);
    resetPublicIpName(): void;
    get publicIpNameInput(): string | undefined;
    private _publicSubnetName?;
    get publicSubnetName(): string;
    set publicSubnetName(value: string);
    resetPublicSubnetName(): void;
    get publicSubnetNameInput(): string | undefined;
    private _publicSubnetNetworkSecurityGroupAssociationId?;
    get publicSubnetNetworkSecurityGroupAssociationId(): string;
    set publicSubnetNetworkSecurityGroupAssociationId(value: string);
    resetPublicSubnetNetworkSecurityGroupAssociationId(): void;
    get publicSubnetNetworkSecurityGroupAssociationIdInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    resetStorageAccountName(): void;
    get storageAccountNameInput(): string | undefined;
    private _storageAccountSkuName?;
    get storageAccountSkuName(): string;
    set storageAccountSkuName(value: string);
    resetStorageAccountSkuName(): void;
    get storageAccountSkuNameInput(): string | undefined;
    private _virtualNetworkId?;
    get virtualNetworkId(): string;
    set virtualNetworkId(value: string);
    resetVirtualNetworkId(): void;
    get virtualNetworkIdInput(): string | undefined;
    private _vnetAddressPrefix?;
    get vnetAddressPrefix(): string;
    set vnetAddressPrefix(value: string);
    resetVnetAddressPrefix(): void;
    get vnetAddressPrefixInput(): string | undefined;
}
export interface DatabricksWorkspaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#create DatabricksWorkspace#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#delete DatabricksWorkspace#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#read DatabricksWorkspace#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#update DatabricksWorkspace#update}
    */
    readonly update?: string;
}
export declare function databricksWorkspaceTimeoutsToTerraform(struct?: DatabricksWorkspaceTimeouts | cdktf.IResolvable): any;
export declare function databricksWorkspaceTimeoutsToHclTerraform(struct?: DatabricksWorkspaceTimeouts | cdktf.IResolvable): any;
export declare class DatabricksWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatabricksWorkspaceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DatabricksWorkspaceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace azurerm_databricks_workspace}
*/
export declare class DatabricksWorkspace extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_databricks_workspace";
    /**
    * Generates CDKTF code for importing a DatabricksWorkspace resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DatabricksWorkspace to import
    * @param importFromId The id of the existing DatabricksWorkspace that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DatabricksWorkspace to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/databricks_workspace azurerm_databricks_workspace} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatabricksWorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: DatabricksWorkspaceConfig);
    private _customerManagedKeyEnabled?;
    get customerManagedKeyEnabled(): boolean | cdktf.IResolvable;
    set customerManagedKeyEnabled(value: boolean | cdktf.IResolvable);
    resetCustomerManagedKeyEnabled(): void;
    get customerManagedKeyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get diskEncryptionSetId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _infrastructureEncryptionEnabled?;
    get infrastructureEncryptionEnabled(): boolean | cdktf.IResolvable;
    set infrastructureEncryptionEnabled(value: boolean | cdktf.IResolvable);
    resetInfrastructureEncryptionEnabled(): void;
    get infrastructureEncryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _loadBalancerBackendAddressPoolId?;
    get loadBalancerBackendAddressPoolId(): string;
    set loadBalancerBackendAddressPoolId(value: string);
    resetLoadBalancerBackendAddressPoolId(): void;
    get loadBalancerBackendAddressPoolIdInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managedDiskCmkKeyVaultId?;
    get managedDiskCmkKeyVaultId(): string;
    set managedDiskCmkKeyVaultId(value: string);
    resetManagedDiskCmkKeyVaultId(): void;
    get managedDiskCmkKeyVaultIdInput(): string | undefined;
    private _managedDiskCmkKeyVaultKeyId?;
    get managedDiskCmkKeyVaultKeyId(): string;
    set managedDiskCmkKeyVaultKeyId(value: string);
    resetManagedDiskCmkKeyVaultKeyId(): void;
    get managedDiskCmkKeyVaultKeyIdInput(): string | undefined;
    private _managedDiskCmkRotationToLatestVersionEnabled?;
    get managedDiskCmkRotationToLatestVersionEnabled(): boolean | cdktf.IResolvable;
    set managedDiskCmkRotationToLatestVersionEnabled(value: boolean | cdktf.IResolvable);
    resetManagedDiskCmkRotationToLatestVersionEnabled(): void;
    get managedDiskCmkRotationToLatestVersionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _managedDiskIdentity;
    get managedDiskIdentity(): DatabricksWorkspaceManagedDiskIdentityList;
    get managedResourceGroupId(): string;
    private _managedResourceGroupName?;
    get managedResourceGroupName(): string;
    set managedResourceGroupName(value: string);
    resetManagedResourceGroupName(): void;
    get managedResourceGroupNameInput(): string | undefined;
    private _managedServicesCmkKeyVaultId?;
    get managedServicesCmkKeyVaultId(): string;
    set managedServicesCmkKeyVaultId(value: string);
    resetManagedServicesCmkKeyVaultId(): void;
    get managedServicesCmkKeyVaultIdInput(): string | undefined;
    private _managedServicesCmkKeyVaultKeyId?;
    get managedServicesCmkKeyVaultKeyId(): string;
    set managedServicesCmkKeyVaultKeyId(value: string);
    resetManagedServicesCmkKeyVaultKeyId(): void;
    get managedServicesCmkKeyVaultKeyIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkSecurityGroupRulesRequired?;
    get networkSecurityGroupRulesRequired(): string;
    set networkSecurityGroupRulesRequired(value: string);
    resetNetworkSecurityGroupRulesRequired(): void;
    get networkSecurityGroupRulesRequiredInput(): string | undefined;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _storageAccountIdentity;
    get storageAccountIdentity(): DatabricksWorkspaceStorageAccountIdentityList;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get workspaceId(): string;
    get workspaceUrl(): string;
    private _customParameters;
    get customParameters(): DatabricksWorkspaceCustomParametersOutputReference;
    putCustomParameters(value: DatabricksWorkspaceCustomParameters): void;
    resetCustomParameters(): void;
    get customParametersInput(): DatabricksWorkspaceCustomParameters | undefined;
    private _timeouts;
    get timeouts(): DatabricksWorkspaceTimeoutsOutputReference;
    putTimeouts(value: DatabricksWorkspaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DatabricksWorkspaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
