/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DevCenterCatalogConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#dev_center_id DevCenterCatalog#dev_center_id}
    */
    readonly devCenterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#id DevCenterCatalog#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#name DevCenterCatalog#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#resource_group_name DevCenterCatalog#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * catalog_adogit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#catalog_adogit DevCenterCatalog#catalog_adogit}
    */
    readonly catalogAdogit?: DevCenterCatalogCatalogAdogit;
    /**
    * catalog_github block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#catalog_github DevCenterCatalog#catalog_github}
    */
    readonly catalogGithub?: DevCenterCatalogCatalogGithub;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#timeouts DevCenterCatalog#timeouts}
    */
    readonly timeouts?: DevCenterCatalogTimeouts;
}
export interface DevCenterCatalogCatalogAdogit {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#branch DevCenterCatalog#branch}
    */
    readonly branch: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#key_vault_key_url DevCenterCatalog#key_vault_key_url}
    */
    readonly keyVaultKeyUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#path DevCenterCatalog#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#uri DevCenterCatalog#uri}
    */
    readonly uri: string;
}
export declare function devCenterCatalogCatalogAdogitToTerraform(struct?: DevCenterCatalogCatalogAdogitOutputReference | DevCenterCatalogCatalogAdogit): any;
export declare function devCenterCatalogCatalogAdogitToHclTerraform(struct?: DevCenterCatalogCatalogAdogitOutputReference | DevCenterCatalogCatalogAdogit): any;
export declare class DevCenterCatalogCatalogAdogitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DevCenterCatalogCatalogAdogit | undefined;
    set internalValue(value: DevCenterCatalogCatalogAdogit | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    get branchInput(): string | undefined;
    private _keyVaultKeyUrl?;
    get keyVaultKeyUrl(): string;
    set keyVaultKeyUrl(value: string);
    get keyVaultKeyUrlInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface DevCenterCatalogCatalogGithub {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#branch DevCenterCatalog#branch}
    */
    readonly branch: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#key_vault_key_url DevCenterCatalog#key_vault_key_url}
    */
    readonly keyVaultKeyUrl: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#path DevCenterCatalog#path}
    */
    readonly path: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#uri DevCenterCatalog#uri}
    */
    readonly uri: string;
}
export declare function devCenterCatalogCatalogGithubToTerraform(struct?: DevCenterCatalogCatalogGithubOutputReference | DevCenterCatalogCatalogGithub): any;
export declare function devCenterCatalogCatalogGithubToHclTerraform(struct?: DevCenterCatalogCatalogGithubOutputReference | DevCenterCatalogCatalogGithub): any;
export declare class DevCenterCatalogCatalogGithubOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DevCenterCatalogCatalogGithub | undefined;
    set internalValue(value: DevCenterCatalogCatalogGithub | undefined);
    private _branch?;
    get branch(): string;
    set branch(value: string);
    get branchInput(): string | undefined;
    private _keyVaultKeyUrl?;
    get keyVaultKeyUrl(): string;
    set keyVaultKeyUrl(value: string);
    get keyVaultKeyUrlInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    get pathInput(): string | undefined;
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
}
export interface DevCenterCatalogTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#create DevCenterCatalog#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#delete DevCenterCatalog#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#read DevCenterCatalog#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#update DevCenterCatalog#update}
    */
    readonly update?: string;
}
export declare function devCenterCatalogTimeoutsToTerraform(struct?: DevCenterCatalogTimeouts | cdktf.IResolvable): any;
export declare function devCenterCatalogTimeoutsToHclTerraform(struct?: DevCenterCatalogTimeouts | cdktf.IResolvable): any;
export declare class DevCenterCatalogTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DevCenterCatalogTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DevCenterCatalogTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog azurerm_dev_center_catalog}
*/
export declare class DevCenterCatalog extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_dev_center_catalog";
    /**
    * Generates CDKTF code for importing a DevCenterCatalog resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DevCenterCatalog to import
    * @param importFromId The id of the existing DevCenterCatalog that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DevCenterCatalog to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/dev_center_catalog azurerm_dev_center_catalog} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DevCenterCatalogConfig
    */
    constructor(scope: Construct, id: string, config: DevCenterCatalogConfig);
    private _devCenterId?;
    get devCenterId(): string;
    set devCenterId(value: string);
    get devCenterIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _catalogAdogit;
    get catalogAdogit(): DevCenterCatalogCatalogAdogitOutputReference;
    putCatalogAdogit(value: DevCenterCatalogCatalogAdogit): void;
    resetCatalogAdogit(): void;
    get catalogAdogitInput(): DevCenterCatalogCatalogAdogit | undefined;
    private _catalogGithub;
    get catalogGithub(): DevCenterCatalogCatalogGithubOutputReference;
    putCatalogGithub(value: DevCenterCatalogCatalogGithub): void;
    resetCatalogGithub(): void;
    get catalogGithubInput(): DevCenterCatalogCatalogGithub | undefined;
    private _timeouts;
    get timeouts(): DevCenterCatalogTimeoutsOutputReference;
    putTimeouts(value: DevCenterCatalogTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DevCenterCatalogTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
