/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ElasticSanVolumeGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#elastic_san_id ElasticSanVolumeGroup#elastic_san_id}
    */
    readonly elasticSanId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#encryption_type ElasticSanVolumeGroup#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#id ElasticSanVolumeGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#name ElasticSanVolumeGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#protocol_type ElasticSanVolumeGroup#protocol_type}
    */
    readonly protocolType?: string;
    /**
    * encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#encryption ElasticSanVolumeGroup#encryption}
    */
    readonly encryption?: ElasticSanVolumeGroupEncryption;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#identity ElasticSanVolumeGroup#identity}
    */
    readonly identity?: ElasticSanVolumeGroupIdentity;
    /**
    * network_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#network_rule ElasticSanVolumeGroup#network_rule}
    */
    readonly networkRule?: ElasticSanVolumeGroupNetworkRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#timeouts ElasticSanVolumeGroup#timeouts}
    */
    readonly timeouts?: ElasticSanVolumeGroupTimeouts;
}
export interface ElasticSanVolumeGroupEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#key_vault_key_id ElasticSanVolumeGroup#key_vault_key_id}
    */
    readonly keyVaultKeyId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#user_assigned_identity_id ElasticSanVolumeGroup#user_assigned_identity_id}
    */
    readonly userAssignedIdentityId?: string;
}
export declare function elasticSanVolumeGroupEncryptionToTerraform(struct?: ElasticSanVolumeGroupEncryptionOutputReference | ElasticSanVolumeGroupEncryption): any;
export declare function elasticSanVolumeGroupEncryptionToHclTerraform(struct?: ElasticSanVolumeGroupEncryptionOutputReference | ElasticSanVolumeGroupEncryption): any;
export declare class ElasticSanVolumeGroupEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElasticSanVolumeGroupEncryption | undefined;
    set internalValue(value: ElasticSanVolumeGroupEncryption | undefined);
    get currentVersionedKeyExpirationTimestamp(): string;
    get currentVersionedKeyId(): string;
    private _keyVaultKeyId?;
    get keyVaultKeyId(): string;
    set keyVaultKeyId(value: string);
    get keyVaultKeyIdInput(): string | undefined;
    get lastKeyRotationTimestamp(): string;
    private _userAssignedIdentityId?;
    get userAssignedIdentityId(): string;
    set userAssignedIdentityId(value: string);
    resetUserAssignedIdentityId(): void;
    get userAssignedIdentityIdInput(): string | undefined;
}
export interface ElasticSanVolumeGroupIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#identity_ids ElasticSanVolumeGroup#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#type ElasticSanVolumeGroup#type}
    */
    readonly type: string;
}
export declare function elasticSanVolumeGroupIdentityToTerraform(struct?: ElasticSanVolumeGroupIdentityOutputReference | ElasticSanVolumeGroupIdentity): any;
export declare function elasticSanVolumeGroupIdentityToHclTerraform(struct?: ElasticSanVolumeGroupIdentityOutputReference | ElasticSanVolumeGroupIdentity): any;
export declare class ElasticSanVolumeGroupIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElasticSanVolumeGroupIdentity | undefined;
    set internalValue(value: ElasticSanVolumeGroupIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface ElasticSanVolumeGroupNetworkRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#action ElasticSanVolumeGroup#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#subnet_id ElasticSanVolumeGroup#subnet_id}
    */
    readonly subnetId: string;
}
export declare function elasticSanVolumeGroupNetworkRuleToTerraform(struct?: ElasticSanVolumeGroupNetworkRule | cdktf.IResolvable): any;
export declare function elasticSanVolumeGroupNetworkRuleToHclTerraform(struct?: ElasticSanVolumeGroupNetworkRule | cdktf.IResolvable): any;
export declare class ElasticSanVolumeGroupNetworkRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ElasticSanVolumeGroupNetworkRule | cdktf.IResolvable | undefined;
    set internalValue(value: ElasticSanVolumeGroupNetworkRule | cdktf.IResolvable | undefined);
    private _action?;
    get action(): string;
    set action(value: string);
    resetAction(): void;
    get actionInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
}
export declare class ElasticSanVolumeGroupNetworkRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ElasticSanVolumeGroupNetworkRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ElasticSanVolumeGroupNetworkRuleOutputReference;
}
export interface ElasticSanVolumeGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#create ElasticSanVolumeGroup#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#delete ElasticSanVolumeGroup#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#read ElasticSanVolumeGroup#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#update ElasticSanVolumeGroup#update}
    */
    readonly update?: string;
}
export declare function elasticSanVolumeGroupTimeoutsToTerraform(struct?: ElasticSanVolumeGroupTimeouts | cdktf.IResolvable): any;
export declare function elasticSanVolumeGroupTimeoutsToHclTerraform(struct?: ElasticSanVolumeGroupTimeouts | cdktf.IResolvable): any;
export declare class ElasticSanVolumeGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ElasticSanVolumeGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ElasticSanVolumeGroupTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group azurerm_elastic_san_volume_group}
*/
export declare class ElasticSanVolumeGroup extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_elastic_san_volume_group";
    /**
    * Generates CDKTF code for importing a ElasticSanVolumeGroup resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ElasticSanVolumeGroup to import
    * @param importFromId The id of the existing ElasticSanVolumeGroup that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ElasticSanVolumeGroup to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/elastic_san_volume_group azurerm_elastic_san_volume_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ElasticSanVolumeGroupConfig
    */
    constructor(scope: Construct, id: string, config: ElasticSanVolumeGroupConfig);
    private _elasticSanId?;
    get elasticSanId(): string;
    set elasticSanId(value: string);
    get elasticSanIdInput(): string | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _protocolType?;
    get protocolType(): string;
    set protocolType(value: string);
    resetProtocolType(): void;
    get protocolTypeInput(): string | undefined;
    private _encryption;
    get encryption(): ElasticSanVolumeGroupEncryptionOutputReference;
    putEncryption(value: ElasticSanVolumeGroupEncryption): void;
    resetEncryption(): void;
    get encryptionInput(): ElasticSanVolumeGroupEncryption | undefined;
    private _identity;
    get identity(): ElasticSanVolumeGroupIdentityOutputReference;
    putIdentity(value: ElasticSanVolumeGroupIdentity): void;
    resetIdentity(): void;
    get identityInput(): ElasticSanVolumeGroupIdentity | undefined;
    private _networkRule;
    get networkRule(): ElasticSanVolumeGroupNetworkRuleList;
    putNetworkRule(value: ElasticSanVolumeGroupNetworkRule[] | cdktf.IResolvable): void;
    resetNetworkRule(): void;
    get networkRuleInput(): cdktf.IResolvable | ElasticSanVolumeGroupNetworkRule[] | undefined;
    private _timeouts;
    get timeouts(): ElasticSanVolumeGroupTimeoutsOutputReference;
    putTimeouts(value: ElasticSanVolumeGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ElasticSanVolumeGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
