/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface FirewallApplicationRuleCollectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#action FirewallApplicationRuleCollection#action}
    */
    readonly action: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#azure_firewall_name FirewallApplicationRuleCollection#azure_firewall_name}
    */
    readonly azureFirewallName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#id FirewallApplicationRuleCollection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#name FirewallApplicationRuleCollection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#priority FirewallApplicationRuleCollection#priority}
    */
    readonly priority: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#resource_group_name FirewallApplicationRuleCollection#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#rule FirewallApplicationRuleCollection#rule}
    */
    readonly rule: FirewallApplicationRuleCollectionRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#timeouts FirewallApplicationRuleCollection#timeouts}
    */
    readonly timeouts?: FirewallApplicationRuleCollectionTimeouts;
}
export interface FirewallApplicationRuleCollectionRuleProtocol {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#port FirewallApplicationRuleCollection#port}
    */
    readonly port: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#type FirewallApplicationRuleCollection#type}
    */
    readonly type: string;
}
export declare function firewallApplicationRuleCollectionRuleProtocolToTerraform(struct?: FirewallApplicationRuleCollectionRuleProtocol | cdktf.IResolvable): any;
export declare function firewallApplicationRuleCollectionRuleProtocolToHclTerraform(struct?: FirewallApplicationRuleCollectionRuleProtocol | cdktf.IResolvable): any;
export declare class FirewallApplicationRuleCollectionRuleProtocolOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirewallApplicationRuleCollectionRuleProtocol | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallApplicationRuleCollectionRuleProtocol | cdktf.IResolvable | undefined);
    private _port?;
    get port(): number;
    set port(value: number);
    get portInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class FirewallApplicationRuleCollectionRuleProtocolList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FirewallApplicationRuleCollectionRuleProtocol[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirewallApplicationRuleCollectionRuleProtocolOutputReference;
}
export interface FirewallApplicationRuleCollectionRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#description FirewallApplicationRuleCollection#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#fqdn_tags FirewallApplicationRuleCollection#fqdn_tags}
    */
    readonly fqdnTags?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#name FirewallApplicationRuleCollection#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#source_addresses FirewallApplicationRuleCollection#source_addresses}
    */
    readonly sourceAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#source_ip_groups FirewallApplicationRuleCollection#source_ip_groups}
    */
    readonly sourceIpGroups?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#target_fqdns FirewallApplicationRuleCollection#target_fqdns}
    */
    readonly targetFqdns?: string[];
    /**
    * protocol block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#protocol FirewallApplicationRuleCollection#protocol}
    */
    readonly protocol?: FirewallApplicationRuleCollectionRuleProtocol[] | cdktf.IResolvable;
}
export declare function firewallApplicationRuleCollectionRuleToTerraform(struct?: FirewallApplicationRuleCollectionRule | cdktf.IResolvable): any;
export declare function firewallApplicationRuleCollectionRuleToHclTerraform(struct?: FirewallApplicationRuleCollectionRule | cdktf.IResolvable): any;
export declare class FirewallApplicationRuleCollectionRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): FirewallApplicationRuleCollectionRule | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallApplicationRuleCollectionRule | cdktf.IResolvable | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _fqdnTags?;
    get fqdnTags(): string[];
    set fqdnTags(value: string[]);
    resetFqdnTags(): void;
    get fqdnTagsInput(): string[] | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _sourceAddresses?;
    get sourceAddresses(): string[];
    set sourceAddresses(value: string[]);
    resetSourceAddresses(): void;
    get sourceAddressesInput(): string[] | undefined;
    private _sourceIpGroups?;
    get sourceIpGroups(): string[];
    set sourceIpGroups(value: string[]);
    resetSourceIpGroups(): void;
    get sourceIpGroupsInput(): string[] | undefined;
    private _targetFqdns?;
    get targetFqdns(): string[];
    set targetFqdns(value: string[]);
    resetTargetFqdns(): void;
    get targetFqdnsInput(): string[] | undefined;
    private _protocol;
    get protocol(): FirewallApplicationRuleCollectionRuleProtocolList;
    putProtocol(value: FirewallApplicationRuleCollectionRuleProtocol[] | cdktf.IResolvable): void;
    resetProtocol(): void;
    get protocolInput(): cdktf.IResolvable | FirewallApplicationRuleCollectionRuleProtocol[] | undefined;
}
export declare class FirewallApplicationRuleCollectionRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: FirewallApplicationRuleCollectionRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): FirewallApplicationRuleCollectionRuleOutputReference;
}
export interface FirewallApplicationRuleCollectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#create FirewallApplicationRuleCollection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#delete FirewallApplicationRuleCollection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#read FirewallApplicationRuleCollection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#update FirewallApplicationRuleCollection#update}
    */
    readonly update?: string;
}
export declare function firewallApplicationRuleCollectionTimeoutsToTerraform(struct?: FirewallApplicationRuleCollectionTimeouts | cdktf.IResolvable): any;
export declare function firewallApplicationRuleCollectionTimeoutsToHclTerraform(struct?: FirewallApplicationRuleCollectionTimeouts | cdktf.IResolvable): any;
export declare class FirewallApplicationRuleCollectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): FirewallApplicationRuleCollectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: FirewallApplicationRuleCollectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection azurerm_firewall_application_rule_collection}
*/
export declare class FirewallApplicationRuleCollection extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_firewall_application_rule_collection";
    /**
    * Generates CDKTF code for importing a FirewallApplicationRuleCollection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the FirewallApplicationRuleCollection to import
    * @param importFromId The id of the existing FirewallApplicationRuleCollection that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the FirewallApplicationRuleCollection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/firewall_application_rule_collection azurerm_firewall_application_rule_collection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options FirewallApplicationRuleCollectionConfig
    */
    constructor(scope: Construct, id: string, config: FirewallApplicationRuleCollectionConfig);
    private _action?;
    get action(): string;
    set action(value: string);
    get actionInput(): string | undefined;
    private _azureFirewallName?;
    get azureFirewallName(): string;
    set azureFirewallName(value: string);
    get azureFirewallNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _rule;
    get rule(): FirewallApplicationRuleCollectionRuleList;
    putRule(value: FirewallApplicationRuleCollectionRule[] | cdktf.IResolvable): void;
    get ruleInput(): cdktf.IResolvable | FirewallApplicationRuleCollectionRule[] | undefined;
    private _timeouts;
    get timeouts(): FirewallApplicationRuleCollectionTimeoutsOutputReference;
    putTimeouts(value: FirewallApplicationRuleCollectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | FirewallApplicationRuleCollectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
