/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KubernetesFleetMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/kubernetes_fleet_member#group KubernetesFleetMember#group}
    */
    readonly group?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/kubernetes_fleet_member#id KubernetesFleetMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/kubernetes_fleet_member#kubernetes_cluster_id KubernetesFleetMember#kubernetes_cluster_id}
    */
    readonly kubernetesClusterId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/kubernetes_fleet_member#kubernetes_fleet_id KubernetesFleetMember#kubernetes_fleet_id}
    */
    readonly kubernetesFleetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/kubernetes_fleet_member#name KubernetesFleetMember#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/kubernetes_fleet_member#timeouts KubernetesFleetMember#timeouts}
    */
    readonly timeouts?: KubernetesFleetMemberTimeouts;
}
export interface KubernetesFleetMemberTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/kubernetes_fleet_member#create KubernetesFleetMember#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/kubernetes_fleet_member#delete KubernetesFleetMember#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/kubernetes_fleet_member#read KubernetesFleetMember#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/kubernetes_fleet_member#update KubernetesFleetMember#update}
    */
    readonly update?: string;
}
export declare function kubernetesFleetMemberTimeoutsToTerraform(struct?: KubernetesFleetMemberTimeouts | cdktf.IResolvable): any;
export declare function kubernetesFleetMemberTimeoutsToHclTerraform(struct?: KubernetesFleetMemberTimeouts | cdktf.IResolvable): any;
export declare class KubernetesFleetMemberTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KubernetesFleetMemberTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KubernetesFleetMemberTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/kubernetes_fleet_member azurerm_kubernetes_fleet_member}
*/
export declare class KubernetesFleetMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_kubernetes_fleet_member";
    /**
    * Generates CDKTF code for importing a KubernetesFleetMember resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the KubernetesFleetMember to import
    * @param importFromId The id of the existing KubernetesFleetMember that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/kubernetes_fleet_member#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the KubernetesFleetMember to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/kubernetes_fleet_member azurerm_kubernetes_fleet_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KubernetesFleetMemberConfig
    */
    constructor(scope: Construct, id: string, config: KubernetesFleetMemberConfig);
    private _group?;
    get group(): string;
    set group(value: string);
    resetGroup(): void;
    get groupInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _kubernetesClusterId?;
    get kubernetesClusterId(): string;
    set kubernetesClusterId(value: string);
    get kubernetesClusterIdInput(): string | undefined;
    private _kubernetesFleetId?;
    get kubernetesFleetId(): string;
    set kubernetesFleetId(value: string);
    get kubernetesFleetIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): KubernetesFleetMemberTimeoutsOutputReference;
    putTimeouts(value: KubernetesFleetMemberTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KubernetesFleetMemberTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
