/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MediaStreamingPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#default_content_key_policy_name MediaStreamingPolicy#default_content_key_policy_name}
    */
    readonly defaultContentKeyPolicyName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#id MediaStreamingPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#media_services_account_name MediaStreamingPolicy#media_services_account_name}
    */
    readonly mediaServicesAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#name MediaStreamingPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#resource_group_name MediaStreamingPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * common_encryption_cbcs block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#common_encryption_cbcs MediaStreamingPolicy#common_encryption_cbcs}
    */
    readonly commonEncryptionCbcs?: MediaStreamingPolicyCommonEncryptionCbcs;
    /**
    * common_encryption_cenc block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#common_encryption_cenc MediaStreamingPolicy#common_encryption_cenc}
    */
    readonly commonEncryptionCenc?: MediaStreamingPolicyCommonEncryptionCenc;
    /**
    * envelope_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#envelope_encryption MediaStreamingPolicy#envelope_encryption}
    */
    readonly envelopeEncryption?: MediaStreamingPolicyEnvelopeEncryption;
    /**
    * no_encryption_enabled_protocols block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#no_encryption_enabled_protocols MediaStreamingPolicy#no_encryption_enabled_protocols}
    */
    readonly noEncryptionEnabledProtocols?: MediaStreamingPolicyNoEncryptionEnabledProtocols;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#timeouts MediaStreamingPolicy#timeouts}
    */
    readonly timeouts?: MediaStreamingPolicyTimeouts;
}
export interface MediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#custom_keys_acquisition_url_template MediaStreamingPolicy#custom_keys_acquisition_url_template}
    */
    readonly customKeysAcquisitionUrlTemplate: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryptionToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryptionOutputReference | MediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryption): any;
export declare function mediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryptionToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryptionOutputReference | MediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryption): any;
export declare class MediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryption | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryption | undefined);
    private _customKeysAcquisitionUrlTemplate?;
    get customKeysAcquisitionUrlTemplate(): string;
    set customKeysAcquisitionUrlTemplate(value: string);
    get customKeysAcquisitionUrlTemplateInput(): string | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#label MediaStreamingPolicy#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#policy_name MediaStreamingPolicy#policy_name}
    */
    readonly policyName?: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyOutputReference | MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey): any;
export declare function mediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyOutputReference | MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey): any;
export declare class MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    resetPolicyName(): void;
    get policyNameInput(): string | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#allow_persistent_license MediaStreamingPolicy#allow_persistent_license}
    */
    readonly allowPersistentLicense?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#custom_license_acquisition_url_template MediaStreamingPolicy#custom_license_acquisition_url_template}
    */
    readonly customLicenseAcquisitionUrlTemplate?: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCbcsDrmFairplayToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsDrmFairplayOutputReference | MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay): any;
export declare function mediaStreamingPolicyCommonEncryptionCbcsDrmFairplayToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsDrmFairplayOutputReference | MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay): any;
export declare class MediaStreamingPolicyCommonEncryptionCbcsDrmFairplayOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay | undefined);
    private _allowPersistentLicense?;
    get allowPersistentLicense(): boolean | cdktf.IResolvable;
    set allowPersistentLicense(value: boolean | cdktf.IResolvable);
    resetAllowPersistentLicense(): void;
    get allowPersistentLicenseInput(): boolean | cdktf.IResolvable | undefined;
    private _customLicenseAcquisitionUrlTemplate?;
    get customLicenseAcquisitionUrlTemplate(): string;
    set customLicenseAcquisitionUrlTemplate(value: string);
    resetCustomLicenseAcquisitionUrlTemplate(): void;
    get customLicenseAcquisitionUrlTemplateInput(): string | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#dash MediaStreamingPolicy#dash}
    */
    readonly dash?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#download MediaStreamingPolicy#download}
    */
    readonly download?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#hls MediaStreamingPolicy#hls}
    */
    readonly hls?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#smooth_streaming MediaStreamingPolicy#smooth_streaming}
    */
    readonly smoothStreaming?: boolean | cdktf.IResolvable;
}
export declare function mediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsOutputReference | MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols): any;
export declare function mediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsOutputReference | MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols): any;
export declare class MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols | undefined);
    private _dash?;
    get dash(): boolean | cdktf.IResolvable;
    set dash(value: boolean | cdktf.IResolvable);
    resetDash(): void;
    get dashInput(): boolean | cdktf.IResolvable | undefined;
    private _download?;
    get download(): boolean | cdktf.IResolvable;
    set download(value: boolean | cdktf.IResolvable);
    resetDownload(): void;
    get downloadInput(): boolean | cdktf.IResolvable | undefined;
    private _hls?;
    get hls(): boolean | cdktf.IResolvable;
    set hls(value: boolean | cdktf.IResolvable);
    resetHls(): void;
    get hlsInput(): boolean | cdktf.IResolvable | undefined;
    private _smoothStreaming?;
    get smoothStreaming(): boolean | cdktf.IResolvable;
    set smoothStreaming(value: boolean | cdktf.IResolvable);
    resetSmoothStreaming(): void;
    get smoothStreamingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCbcs {
    /**
    * clear_key_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#clear_key_encryption MediaStreamingPolicy#clear_key_encryption}
    */
    readonly clearKeyEncryption?: MediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryption;
    /**
    * default_content_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#default_content_key MediaStreamingPolicy#default_content_key}
    */
    readonly defaultContentKey?: MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey;
    /**
    * drm_fairplay block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#drm_fairplay MediaStreamingPolicy#drm_fairplay}
    */
    readonly drmFairplay?: MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay;
    /**
    * enabled_protocols block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#enabled_protocols MediaStreamingPolicy#enabled_protocols}
    */
    readonly enabledProtocols?: MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols;
}
export declare function mediaStreamingPolicyCommonEncryptionCbcsToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsOutputReference | MediaStreamingPolicyCommonEncryptionCbcs): any;
export declare function mediaStreamingPolicyCommonEncryptionCbcsToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCbcsOutputReference | MediaStreamingPolicyCommonEncryptionCbcs): any;
export declare class MediaStreamingPolicyCommonEncryptionCbcsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCbcs | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCbcs | undefined);
    private _clearKeyEncryption;
    get clearKeyEncryption(): MediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryptionOutputReference;
    putClearKeyEncryption(value: MediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryption): void;
    resetClearKeyEncryption(): void;
    get clearKeyEncryptionInput(): MediaStreamingPolicyCommonEncryptionCbcsClearKeyEncryption | undefined;
    private _defaultContentKey;
    get defaultContentKey(): MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKeyOutputReference;
    putDefaultContentKey(value: MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey): void;
    resetDefaultContentKey(): void;
    get defaultContentKeyInput(): MediaStreamingPolicyCommonEncryptionCbcsDefaultContentKey | undefined;
    private _drmFairplay;
    get drmFairplay(): MediaStreamingPolicyCommonEncryptionCbcsDrmFairplayOutputReference;
    putDrmFairplay(value: MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay): void;
    resetDrmFairplay(): void;
    get drmFairplayInput(): MediaStreamingPolicyCommonEncryptionCbcsDrmFairplay | undefined;
    private _enabledProtocols;
    get enabledProtocols(): MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocolsOutputReference;
    putEnabledProtocols(value: MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols): void;
    resetEnabledProtocols(): void;
    get enabledProtocolsInput(): MediaStreamingPolicyCommonEncryptionCbcsEnabledProtocols | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCencClearKeyEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#custom_keys_acquisition_url_template MediaStreamingPolicy#custom_keys_acquisition_url_template}
    */
    readonly customKeysAcquisitionUrlTemplate: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCencClearKeyEncryptionToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencClearKeyEncryptionOutputReference | MediaStreamingPolicyCommonEncryptionCencClearKeyEncryption): any;
export declare function mediaStreamingPolicyCommonEncryptionCencClearKeyEncryptionToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencClearKeyEncryptionOutputReference | MediaStreamingPolicyCommonEncryptionCencClearKeyEncryption): any;
export declare class MediaStreamingPolicyCommonEncryptionCencClearKeyEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencClearKeyEncryption | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencClearKeyEncryption | undefined);
    private _customKeysAcquisitionUrlTemplate?;
    get customKeysAcquisitionUrlTemplate(): string;
    set customKeysAcquisitionUrlTemplate(value: string);
    get customKeysAcquisitionUrlTemplateInput(): string | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCencClearTrackCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#operation MediaStreamingPolicy#operation}
    */
    readonly operation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#property MediaStreamingPolicy#property}
    */
    readonly property: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#value MediaStreamingPolicy#value}
    */
    readonly value: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCencClearTrackConditionToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencClearTrackCondition | cdktf.IResolvable): any;
export declare function mediaStreamingPolicyCommonEncryptionCencClearTrackConditionToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencClearTrackCondition | cdktf.IResolvable): any;
export declare class MediaStreamingPolicyCommonEncryptionCencClearTrackConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencClearTrackCondition | cdktf.IResolvable | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencClearTrackCondition | cdktf.IResolvable | undefined);
    private _operation?;
    get operation(): string;
    set operation(value: string);
    get operationInput(): string | undefined;
    private _property?;
    get property(): string;
    set property(value: string);
    get propertyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class MediaStreamingPolicyCommonEncryptionCencClearTrackConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaStreamingPolicyCommonEncryptionCencClearTrackCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaStreamingPolicyCommonEncryptionCencClearTrackConditionOutputReference;
}
export interface MediaStreamingPolicyCommonEncryptionCencClearTrack {
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#condition MediaStreamingPolicy#condition}
    */
    readonly condition: MediaStreamingPolicyCommonEncryptionCencClearTrackCondition[] | cdktf.IResolvable;
}
export declare function mediaStreamingPolicyCommonEncryptionCencClearTrackToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencClearTrack | cdktf.IResolvable): any;
export declare function mediaStreamingPolicyCommonEncryptionCencClearTrackToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencClearTrack | cdktf.IResolvable): any;
export declare class MediaStreamingPolicyCommonEncryptionCencClearTrackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencClearTrack | cdktf.IResolvable | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencClearTrack | cdktf.IResolvable | undefined);
    private _condition;
    get condition(): MediaStreamingPolicyCommonEncryptionCencClearTrackConditionList;
    putCondition(value: MediaStreamingPolicyCommonEncryptionCencClearTrackCondition[] | cdktf.IResolvable): void;
    get conditionInput(): cdktf.IResolvable | MediaStreamingPolicyCommonEncryptionCencClearTrackCondition[] | undefined;
}
export declare class MediaStreamingPolicyCommonEncryptionCencClearTrackList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaStreamingPolicyCommonEncryptionCencClearTrack[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaStreamingPolicyCommonEncryptionCencClearTrackOutputReference;
}
export interface MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackCondition {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#operation MediaStreamingPolicy#operation}
    */
    readonly operation: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#property MediaStreamingPolicy#property}
    */
    readonly property: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#value MediaStreamingPolicy#value}
    */
    readonly value: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackConditionToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackCondition | cdktf.IResolvable): any;
export declare function mediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackConditionToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackCondition | cdktf.IResolvable): any;
export declare class MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackCondition | cdktf.IResolvable | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackCondition | cdktf.IResolvable | undefined);
    private _operation?;
    get operation(): string;
    set operation(value: string);
    get operationInput(): string | undefined;
    private _property?;
    get property(): string;
    set property(value: string);
    get propertyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackConditionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackCondition[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackConditionOutputReference;
}
export interface MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrack {
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#condition MediaStreamingPolicy#condition}
    */
    readonly condition: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackCondition[] | cdktf.IResolvable;
}
export declare function mediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrack | cdktf.IResolvable): any;
export declare function mediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrack | cdktf.IResolvable): any;
export declare class MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrack | cdktf.IResolvable | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrack | cdktf.IResolvable | undefined);
    private _condition;
    get condition(): MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackConditionList;
    putCondition(value: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackCondition[] | cdktf.IResolvable): void;
    get conditionInput(): cdktf.IResolvable | MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackCondition[] | undefined;
}
export declare class MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrack[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackOutputReference;
}
export interface MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMapping {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#label MediaStreamingPolicy#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#policy_name MediaStreamingPolicy#policy_name}
    */
    readonly policyName?: string;
    /**
    * track block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#track MediaStreamingPolicy#track}
    */
    readonly track: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrack[] | cdktf.IResolvable;
}
export declare function mediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMapping | cdktf.IResolvable): any;
export declare function mediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMapping | cdktf.IResolvable): any;
export declare class MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMapping | cdktf.IResolvable | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMapping | cdktf.IResolvable | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    resetPolicyName(): void;
    get policyNameInput(): string | undefined;
    private _track;
    get track(): MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrackList;
    putTrack(value: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrack[] | cdktf.IResolvable): void;
    get trackInput(): cdktf.IResolvable | MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingTrack[] | undefined;
}
export declare class MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMapping[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingOutputReference;
}
export interface MediaStreamingPolicyCommonEncryptionCencDefaultContentKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#label MediaStreamingPolicy#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#policy_name MediaStreamingPolicy#policy_name}
    */
    readonly policyName?: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCencDefaultContentKeyToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencDefaultContentKeyOutputReference | MediaStreamingPolicyCommonEncryptionCencDefaultContentKey): any;
export declare function mediaStreamingPolicyCommonEncryptionCencDefaultContentKeyToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencDefaultContentKeyOutputReference | MediaStreamingPolicyCommonEncryptionCencDefaultContentKey): any;
export declare class MediaStreamingPolicyCommonEncryptionCencDefaultContentKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencDefaultContentKey | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencDefaultContentKey | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    resetPolicyName(): void;
    get policyNameInput(): string | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCencDrmPlayready {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#custom_attributes MediaStreamingPolicy#custom_attributes}
    */
    readonly customAttributes?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#custom_license_acquisition_url_template MediaStreamingPolicy#custom_license_acquisition_url_template}
    */
    readonly customLicenseAcquisitionUrlTemplate?: string;
}
export declare function mediaStreamingPolicyCommonEncryptionCencDrmPlayreadyToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencDrmPlayreadyOutputReference | MediaStreamingPolicyCommonEncryptionCencDrmPlayready): any;
export declare function mediaStreamingPolicyCommonEncryptionCencDrmPlayreadyToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencDrmPlayreadyOutputReference | MediaStreamingPolicyCommonEncryptionCencDrmPlayready): any;
export declare class MediaStreamingPolicyCommonEncryptionCencDrmPlayreadyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencDrmPlayready | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencDrmPlayready | undefined);
    private _customAttributes?;
    get customAttributes(): string;
    set customAttributes(value: string);
    resetCustomAttributes(): void;
    get customAttributesInput(): string | undefined;
    private _customLicenseAcquisitionUrlTemplate?;
    get customLicenseAcquisitionUrlTemplate(): string;
    set customLicenseAcquisitionUrlTemplate(value: string);
    resetCustomLicenseAcquisitionUrlTemplate(): void;
    get customLicenseAcquisitionUrlTemplateInput(): string | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCencEnabledProtocols {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#dash MediaStreamingPolicy#dash}
    */
    readonly dash?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#download MediaStreamingPolicy#download}
    */
    readonly download?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#hls MediaStreamingPolicy#hls}
    */
    readonly hls?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#smooth_streaming MediaStreamingPolicy#smooth_streaming}
    */
    readonly smoothStreaming?: boolean | cdktf.IResolvable;
}
export declare function mediaStreamingPolicyCommonEncryptionCencEnabledProtocolsToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencEnabledProtocolsOutputReference | MediaStreamingPolicyCommonEncryptionCencEnabledProtocols): any;
export declare function mediaStreamingPolicyCommonEncryptionCencEnabledProtocolsToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencEnabledProtocolsOutputReference | MediaStreamingPolicyCommonEncryptionCencEnabledProtocols): any;
export declare class MediaStreamingPolicyCommonEncryptionCencEnabledProtocolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCencEnabledProtocols | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCencEnabledProtocols | undefined);
    private _dash?;
    get dash(): boolean | cdktf.IResolvable;
    set dash(value: boolean | cdktf.IResolvable);
    resetDash(): void;
    get dashInput(): boolean | cdktf.IResolvable | undefined;
    private _download?;
    get download(): boolean | cdktf.IResolvable;
    set download(value: boolean | cdktf.IResolvable);
    resetDownload(): void;
    get downloadInput(): boolean | cdktf.IResolvable | undefined;
    private _hls?;
    get hls(): boolean | cdktf.IResolvable;
    set hls(value: boolean | cdktf.IResolvable);
    resetHls(): void;
    get hlsInput(): boolean | cdktf.IResolvable | undefined;
    private _smoothStreaming?;
    get smoothStreaming(): boolean | cdktf.IResolvable;
    set smoothStreaming(value: boolean | cdktf.IResolvable);
    resetSmoothStreaming(): void;
    get smoothStreamingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MediaStreamingPolicyCommonEncryptionCenc {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#drm_widevine_custom_license_acquisition_url_template MediaStreamingPolicy#drm_widevine_custom_license_acquisition_url_template}
    */
    readonly drmWidevineCustomLicenseAcquisitionUrlTemplate?: string;
    /**
    * clear_key_encryption block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#clear_key_encryption MediaStreamingPolicy#clear_key_encryption}
    */
    readonly clearKeyEncryption?: MediaStreamingPolicyCommonEncryptionCencClearKeyEncryption;
    /**
    * clear_track block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#clear_track MediaStreamingPolicy#clear_track}
    */
    readonly clearTrack?: MediaStreamingPolicyCommonEncryptionCencClearTrack[] | cdktf.IResolvable;
    /**
    * content_key_to_track_mapping block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#content_key_to_track_mapping MediaStreamingPolicy#content_key_to_track_mapping}
    */
    readonly contentKeyToTrackMapping?: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMapping[] | cdktf.IResolvable;
    /**
    * default_content_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#default_content_key MediaStreamingPolicy#default_content_key}
    */
    readonly defaultContentKey?: MediaStreamingPolicyCommonEncryptionCencDefaultContentKey;
    /**
    * drm_playready block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#drm_playready MediaStreamingPolicy#drm_playready}
    */
    readonly drmPlayready?: MediaStreamingPolicyCommonEncryptionCencDrmPlayready;
    /**
    * enabled_protocols block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#enabled_protocols MediaStreamingPolicy#enabled_protocols}
    */
    readonly enabledProtocols?: MediaStreamingPolicyCommonEncryptionCencEnabledProtocols;
}
export declare function mediaStreamingPolicyCommonEncryptionCencToTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencOutputReference | MediaStreamingPolicyCommonEncryptionCenc): any;
export declare function mediaStreamingPolicyCommonEncryptionCencToHclTerraform(struct?: MediaStreamingPolicyCommonEncryptionCencOutputReference | MediaStreamingPolicyCommonEncryptionCenc): any;
export declare class MediaStreamingPolicyCommonEncryptionCencOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyCommonEncryptionCenc | undefined;
    set internalValue(value: MediaStreamingPolicyCommonEncryptionCenc | undefined);
    private _drmWidevineCustomLicenseAcquisitionUrlTemplate?;
    get drmWidevineCustomLicenseAcquisitionUrlTemplate(): string;
    set drmWidevineCustomLicenseAcquisitionUrlTemplate(value: string);
    resetDrmWidevineCustomLicenseAcquisitionUrlTemplate(): void;
    get drmWidevineCustomLicenseAcquisitionUrlTemplateInput(): string | undefined;
    private _clearKeyEncryption;
    get clearKeyEncryption(): MediaStreamingPolicyCommonEncryptionCencClearKeyEncryptionOutputReference;
    putClearKeyEncryption(value: MediaStreamingPolicyCommonEncryptionCencClearKeyEncryption): void;
    resetClearKeyEncryption(): void;
    get clearKeyEncryptionInput(): MediaStreamingPolicyCommonEncryptionCencClearKeyEncryption | undefined;
    private _clearTrack;
    get clearTrack(): MediaStreamingPolicyCommonEncryptionCencClearTrackList;
    putClearTrack(value: MediaStreamingPolicyCommonEncryptionCencClearTrack[] | cdktf.IResolvable): void;
    resetClearTrack(): void;
    get clearTrackInput(): cdktf.IResolvable | MediaStreamingPolicyCommonEncryptionCencClearTrack[] | undefined;
    private _contentKeyToTrackMapping;
    get contentKeyToTrackMapping(): MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMappingList;
    putContentKeyToTrackMapping(value: MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMapping[] | cdktf.IResolvable): void;
    resetContentKeyToTrackMapping(): void;
    get contentKeyToTrackMappingInput(): cdktf.IResolvable | MediaStreamingPolicyCommonEncryptionCencContentKeyToTrackMapping[] | undefined;
    private _defaultContentKey;
    get defaultContentKey(): MediaStreamingPolicyCommonEncryptionCencDefaultContentKeyOutputReference;
    putDefaultContentKey(value: MediaStreamingPolicyCommonEncryptionCencDefaultContentKey): void;
    resetDefaultContentKey(): void;
    get defaultContentKeyInput(): MediaStreamingPolicyCommonEncryptionCencDefaultContentKey | undefined;
    private _drmPlayready;
    get drmPlayready(): MediaStreamingPolicyCommonEncryptionCencDrmPlayreadyOutputReference;
    putDrmPlayready(value: MediaStreamingPolicyCommonEncryptionCencDrmPlayready): void;
    resetDrmPlayready(): void;
    get drmPlayreadyInput(): MediaStreamingPolicyCommonEncryptionCencDrmPlayready | undefined;
    private _enabledProtocols;
    get enabledProtocols(): MediaStreamingPolicyCommonEncryptionCencEnabledProtocolsOutputReference;
    putEnabledProtocols(value: MediaStreamingPolicyCommonEncryptionCencEnabledProtocols): void;
    resetEnabledProtocols(): void;
    get enabledProtocolsInput(): MediaStreamingPolicyCommonEncryptionCencEnabledProtocols | undefined;
}
export interface MediaStreamingPolicyEnvelopeEncryptionDefaultContentKey {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#label MediaStreamingPolicy#label}
    */
    readonly label?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#policy_name MediaStreamingPolicy#policy_name}
    */
    readonly policyName?: string;
}
export declare function mediaStreamingPolicyEnvelopeEncryptionDefaultContentKeyToTerraform(struct?: MediaStreamingPolicyEnvelopeEncryptionDefaultContentKeyOutputReference | MediaStreamingPolicyEnvelopeEncryptionDefaultContentKey): any;
export declare function mediaStreamingPolicyEnvelopeEncryptionDefaultContentKeyToHclTerraform(struct?: MediaStreamingPolicyEnvelopeEncryptionDefaultContentKeyOutputReference | MediaStreamingPolicyEnvelopeEncryptionDefaultContentKey): any;
export declare class MediaStreamingPolicyEnvelopeEncryptionDefaultContentKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyEnvelopeEncryptionDefaultContentKey | undefined;
    set internalValue(value: MediaStreamingPolicyEnvelopeEncryptionDefaultContentKey | undefined);
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    private _policyName?;
    get policyName(): string;
    set policyName(value: string);
    resetPolicyName(): void;
    get policyNameInput(): string | undefined;
}
export interface MediaStreamingPolicyEnvelopeEncryptionEnabledProtocols {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#dash MediaStreamingPolicy#dash}
    */
    readonly dash?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#download MediaStreamingPolicy#download}
    */
    readonly download?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#hls MediaStreamingPolicy#hls}
    */
    readonly hls?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#smooth_streaming MediaStreamingPolicy#smooth_streaming}
    */
    readonly smoothStreaming?: boolean | cdktf.IResolvable;
}
export declare function mediaStreamingPolicyEnvelopeEncryptionEnabledProtocolsToTerraform(struct?: MediaStreamingPolicyEnvelopeEncryptionEnabledProtocolsOutputReference | MediaStreamingPolicyEnvelopeEncryptionEnabledProtocols): any;
export declare function mediaStreamingPolicyEnvelopeEncryptionEnabledProtocolsToHclTerraform(struct?: MediaStreamingPolicyEnvelopeEncryptionEnabledProtocolsOutputReference | MediaStreamingPolicyEnvelopeEncryptionEnabledProtocols): any;
export declare class MediaStreamingPolicyEnvelopeEncryptionEnabledProtocolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyEnvelopeEncryptionEnabledProtocols | undefined;
    set internalValue(value: MediaStreamingPolicyEnvelopeEncryptionEnabledProtocols | undefined);
    private _dash?;
    get dash(): boolean | cdktf.IResolvable;
    set dash(value: boolean | cdktf.IResolvable);
    resetDash(): void;
    get dashInput(): boolean | cdktf.IResolvable | undefined;
    private _download?;
    get download(): boolean | cdktf.IResolvable;
    set download(value: boolean | cdktf.IResolvable);
    resetDownload(): void;
    get downloadInput(): boolean | cdktf.IResolvable | undefined;
    private _hls?;
    get hls(): boolean | cdktf.IResolvable;
    set hls(value: boolean | cdktf.IResolvable);
    resetHls(): void;
    get hlsInput(): boolean | cdktf.IResolvable | undefined;
    private _smoothStreaming?;
    get smoothStreaming(): boolean | cdktf.IResolvable;
    set smoothStreaming(value: boolean | cdktf.IResolvable);
    resetSmoothStreaming(): void;
    get smoothStreamingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MediaStreamingPolicyEnvelopeEncryption {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#custom_keys_acquisition_url_template MediaStreamingPolicy#custom_keys_acquisition_url_template}
    */
    readonly customKeysAcquisitionUrlTemplate?: string;
    /**
    * default_content_key block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#default_content_key MediaStreamingPolicy#default_content_key}
    */
    readonly defaultContentKey?: MediaStreamingPolicyEnvelopeEncryptionDefaultContentKey;
    /**
    * enabled_protocols block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#enabled_protocols MediaStreamingPolicy#enabled_protocols}
    */
    readonly enabledProtocols?: MediaStreamingPolicyEnvelopeEncryptionEnabledProtocols;
}
export declare function mediaStreamingPolicyEnvelopeEncryptionToTerraform(struct?: MediaStreamingPolicyEnvelopeEncryptionOutputReference | MediaStreamingPolicyEnvelopeEncryption): any;
export declare function mediaStreamingPolicyEnvelopeEncryptionToHclTerraform(struct?: MediaStreamingPolicyEnvelopeEncryptionOutputReference | MediaStreamingPolicyEnvelopeEncryption): any;
export declare class MediaStreamingPolicyEnvelopeEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyEnvelopeEncryption | undefined;
    set internalValue(value: MediaStreamingPolicyEnvelopeEncryption | undefined);
    private _customKeysAcquisitionUrlTemplate?;
    get customKeysAcquisitionUrlTemplate(): string;
    set customKeysAcquisitionUrlTemplate(value: string);
    resetCustomKeysAcquisitionUrlTemplate(): void;
    get customKeysAcquisitionUrlTemplateInput(): string | undefined;
    private _defaultContentKey;
    get defaultContentKey(): MediaStreamingPolicyEnvelopeEncryptionDefaultContentKeyOutputReference;
    putDefaultContentKey(value: MediaStreamingPolicyEnvelopeEncryptionDefaultContentKey): void;
    resetDefaultContentKey(): void;
    get defaultContentKeyInput(): MediaStreamingPolicyEnvelopeEncryptionDefaultContentKey | undefined;
    private _enabledProtocols;
    get enabledProtocols(): MediaStreamingPolicyEnvelopeEncryptionEnabledProtocolsOutputReference;
    putEnabledProtocols(value: MediaStreamingPolicyEnvelopeEncryptionEnabledProtocols): void;
    resetEnabledProtocols(): void;
    get enabledProtocolsInput(): MediaStreamingPolicyEnvelopeEncryptionEnabledProtocols | undefined;
}
export interface MediaStreamingPolicyNoEncryptionEnabledProtocols {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#dash MediaStreamingPolicy#dash}
    */
    readonly dash?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#download MediaStreamingPolicy#download}
    */
    readonly download?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#hls MediaStreamingPolicy#hls}
    */
    readonly hls?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#smooth_streaming MediaStreamingPolicy#smooth_streaming}
    */
    readonly smoothStreaming?: boolean | cdktf.IResolvable;
}
export declare function mediaStreamingPolicyNoEncryptionEnabledProtocolsToTerraform(struct?: MediaStreamingPolicyNoEncryptionEnabledProtocolsOutputReference | MediaStreamingPolicyNoEncryptionEnabledProtocols): any;
export declare function mediaStreamingPolicyNoEncryptionEnabledProtocolsToHclTerraform(struct?: MediaStreamingPolicyNoEncryptionEnabledProtocolsOutputReference | MediaStreamingPolicyNoEncryptionEnabledProtocols): any;
export declare class MediaStreamingPolicyNoEncryptionEnabledProtocolsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyNoEncryptionEnabledProtocols | undefined;
    set internalValue(value: MediaStreamingPolicyNoEncryptionEnabledProtocols | undefined);
    private _dash?;
    get dash(): boolean | cdktf.IResolvable;
    set dash(value: boolean | cdktf.IResolvable);
    resetDash(): void;
    get dashInput(): boolean | cdktf.IResolvable | undefined;
    private _download?;
    get download(): boolean | cdktf.IResolvable;
    set download(value: boolean | cdktf.IResolvable);
    resetDownload(): void;
    get downloadInput(): boolean | cdktf.IResolvable | undefined;
    private _hls?;
    get hls(): boolean | cdktf.IResolvable;
    set hls(value: boolean | cdktf.IResolvable);
    resetHls(): void;
    get hlsInput(): boolean | cdktf.IResolvable | undefined;
    private _smoothStreaming?;
    get smoothStreaming(): boolean | cdktf.IResolvable;
    set smoothStreaming(value: boolean | cdktf.IResolvable);
    resetSmoothStreaming(): void;
    get smoothStreamingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface MediaStreamingPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#create MediaStreamingPolicy#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#delete MediaStreamingPolicy#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#read MediaStreamingPolicy#read}
    */
    readonly read?: string;
}
export declare function mediaStreamingPolicyTimeoutsToTerraform(struct?: MediaStreamingPolicyTimeouts | cdktf.IResolvable): any;
export declare function mediaStreamingPolicyTimeoutsToHclTerraform(struct?: MediaStreamingPolicyTimeouts | cdktf.IResolvable): any;
export declare class MediaStreamingPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MediaStreamingPolicyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MediaStreamingPolicyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy azurerm_media_streaming_policy}
*/
export declare class MediaStreamingPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_media_streaming_policy";
    /**
    * Generates CDKTF code for importing a MediaStreamingPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MediaStreamingPolicy to import
    * @param importFromId The id of the existing MediaStreamingPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MediaStreamingPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/media_streaming_policy azurerm_media_streaming_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MediaStreamingPolicyConfig
    */
    constructor(scope: Construct, id: string, config: MediaStreamingPolicyConfig);
    private _defaultContentKeyPolicyName?;
    get defaultContentKeyPolicyName(): string;
    set defaultContentKeyPolicyName(value: string);
    resetDefaultContentKeyPolicyName(): void;
    get defaultContentKeyPolicyNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mediaServicesAccountName?;
    get mediaServicesAccountName(): string;
    set mediaServicesAccountName(value: string);
    get mediaServicesAccountNameInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _commonEncryptionCbcs;
    get commonEncryptionCbcs(): MediaStreamingPolicyCommonEncryptionCbcsOutputReference;
    putCommonEncryptionCbcs(value: MediaStreamingPolicyCommonEncryptionCbcs): void;
    resetCommonEncryptionCbcs(): void;
    get commonEncryptionCbcsInput(): MediaStreamingPolicyCommonEncryptionCbcs | undefined;
    private _commonEncryptionCenc;
    get commonEncryptionCenc(): MediaStreamingPolicyCommonEncryptionCencOutputReference;
    putCommonEncryptionCenc(value: MediaStreamingPolicyCommonEncryptionCenc): void;
    resetCommonEncryptionCenc(): void;
    get commonEncryptionCencInput(): MediaStreamingPolicyCommonEncryptionCenc | undefined;
    private _envelopeEncryption;
    get envelopeEncryption(): MediaStreamingPolicyEnvelopeEncryptionOutputReference;
    putEnvelopeEncryption(value: MediaStreamingPolicyEnvelopeEncryption): void;
    resetEnvelopeEncryption(): void;
    get envelopeEncryptionInput(): MediaStreamingPolicyEnvelopeEncryption | undefined;
    private _noEncryptionEnabledProtocols;
    get noEncryptionEnabledProtocols(): MediaStreamingPolicyNoEncryptionEnabledProtocolsOutputReference;
    putNoEncryptionEnabledProtocols(value: MediaStreamingPolicyNoEncryptionEnabledProtocols): void;
    resetNoEncryptionEnabledProtocols(): void;
    get noEncryptionEnabledProtocolsInput(): MediaStreamingPolicyNoEncryptionEnabledProtocols | undefined;
    private _timeouts;
    get timeouts(): MediaStreamingPolicyTimeoutsOutputReference;
    putTimeouts(value: MediaStreamingPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MediaStreamingPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
