/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivateDnsZoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#id PrivateDnsZone#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#name PrivateDnsZone#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#resource_group_name PrivateDnsZone#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#tags PrivateDnsZone#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * soa_record block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#soa_record PrivateDnsZone#soa_record}
    */
    readonly soaRecord?: PrivateDnsZoneSoaRecord;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#timeouts PrivateDnsZone#timeouts}
    */
    readonly timeouts?: PrivateDnsZoneTimeouts;
}
export interface PrivateDnsZoneSoaRecord {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#email PrivateDnsZone#email}
    */
    readonly email: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#expire_time PrivateDnsZone#expire_time}
    */
    readonly expireTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#minimum_ttl PrivateDnsZone#minimum_ttl}
    */
    readonly minimumTtl?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#refresh_time PrivateDnsZone#refresh_time}
    */
    readonly refreshTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#retry_time PrivateDnsZone#retry_time}
    */
    readonly retryTime?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#tags PrivateDnsZone#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#ttl PrivateDnsZone#ttl}
    */
    readonly ttl?: number;
}
export declare function privateDnsZoneSoaRecordToTerraform(struct?: PrivateDnsZoneSoaRecordOutputReference | PrivateDnsZoneSoaRecord): any;
export declare function privateDnsZoneSoaRecordToHclTerraform(struct?: PrivateDnsZoneSoaRecordOutputReference | PrivateDnsZoneSoaRecord): any;
export declare class PrivateDnsZoneSoaRecordOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivateDnsZoneSoaRecord | undefined;
    set internalValue(value: PrivateDnsZoneSoaRecord | undefined);
    private _email?;
    get email(): string;
    set email(value: string);
    get emailInput(): string | undefined;
    private _expireTime?;
    get expireTime(): number;
    set expireTime(value: number);
    resetExpireTime(): void;
    get expireTimeInput(): number | undefined;
    get fqdn(): string;
    get hostName(): string;
    private _minimumTtl?;
    get minimumTtl(): number;
    set minimumTtl(value: number);
    resetMinimumTtl(): void;
    get minimumTtlInput(): number | undefined;
    private _refreshTime?;
    get refreshTime(): number;
    set refreshTime(value: number);
    resetRefreshTime(): void;
    get refreshTimeInput(): number | undefined;
    private _retryTime?;
    get retryTime(): number;
    set retryTime(value: number);
    resetRetryTime(): void;
    get retryTimeInput(): number | undefined;
    get serialNumber(): number;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
}
export interface PrivateDnsZoneTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#create PrivateDnsZone#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#delete PrivateDnsZone#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#read PrivateDnsZone#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#update PrivateDnsZone#update}
    */
    readonly update?: string;
}
export declare function privateDnsZoneTimeoutsToTerraform(struct?: PrivateDnsZoneTimeouts | cdktf.IResolvable): any;
export declare function privateDnsZoneTimeoutsToHclTerraform(struct?: PrivateDnsZoneTimeouts | cdktf.IResolvable): any;
export declare class PrivateDnsZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivateDnsZoneTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PrivateDnsZoneTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone azurerm_private_dns_zone}
*/
export declare class PrivateDnsZone extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_private_dns_zone";
    /**
    * Generates CDKTF code for importing a PrivateDnsZone resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PrivateDnsZone to import
    * @param importFromId The id of the existing PrivateDnsZone that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PrivateDnsZone to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/private_dns_zone azurerm_private_dns_zone} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivateDnsZoneConfig
    */
    constructor(scope: Construct, id: string, config: PrivateDnsZoneConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get maxNumberOfRecordSets(): number;
    get maxNumberOfVirtualNetworkLinks(): number;
    get maxNumberOfVirtualNetworkLinksWithRegistration(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get numberOfRecordSets(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _soaRecord;
    get soaRecord(): PrivateDnsZoneSoaRecordOutputReference;
    putSoaRecord(value: PrivateDnsZoneSoaRecord): void;
    resetSoaRecord(): void;
    get soaRecordInput(): PrivateDnsZoneSoaRecord | undefined;
    private _timeouts;
    get timeouts(): PrivateDnsZoneTimeoutsOutputReference;
    putTimeouts(value: PrivateDnsZoneTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PrivateDnsZoneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
