/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceFabricClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#add_on_features ServiceFabricCluster#add_on_features}
    */
    readonly addOnFeatures?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#cluster_code_version ServiceFabricCluster#cluster_code_version}
    */
    readonly clusterCodeVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#id ServiceFabricCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#location ServiceFabricCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#management_endpoint ServiceFabricCluster#management_endpoint}
    */
    readonly managementEndpoint: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#name ServiceFabricCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#reliability_level ServiceFabricCluster#reliability_level}
    */
    readonly reliabilityLevel: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#resource_group_name ServiceFabricCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#service_fabric_zonal_upgrade_mode ServiceFabricCluster#service_fabric_zonal_upgrade_mode}
    */
    readonly serviceFabricZonalUpgradeMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#tags ServiceFabricCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#upgrade_mode ServiceFabricCluster#upgrade_mode}
    */
    readonly upgradeMode: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#vm_image ServiceFabricCluster#vm_image}
    */
    readonly vmImage: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#vmss_zonal_upgrade_mode ServiceFabricCluster#vmss_zonal_upgrade_mode}
    */
    readonly vmssZonalUpgradeMode?: string;
    /**
    * azure_active_directory block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#azure_active_directory ServiceFabricCluster#azure_active_directory}
    */
    readonly azureActiveDirectory?: ServiceFabricClusterAzureActiveDirectory;
    /**
    * certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#certificate ServiceFabricCluster#certificate}
    */
    readonly certificate?: ServiceFabricClusterCertificate;
    /**
    * certificate_common_names block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#certificate_common_names ServiceFabricCluster#certificate_common_names}
    */
    readonly certificateCommonNames?: ServiceFabricClusterCertificateCommonNames;
    /**
    * client_certificate_common_name block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#client_certificate_common_name ServiceFabricCluster#client_certificate_common_name}
    */
    readonly clientCertificateCommonName?: ServiceFabricClusterClientCertificateCommonName[] | cdktf.IResolvable;
    /**
    * client_certificate_thumbprint block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#client_certificate_thumbprint ServiceFabricCluster#client_certificate_thumbprint}
    */
    readonly clientCertificateThumbprint?: ServiceFabricClusterClientCertificateThumbprint[] | cdktf.IResolvable;
    /**
    * diagnostics_config block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#diagnostics_config ServiceFabricCluster#diagnostics_config}
    */
    readonly diagnosticsConfig?: ServiceFabricClusterDiagnosticsConfig;
    /**
    * fabric_settings block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#fabric_settings ServiceFabricCluster#fabric_settings}
    */
    readonly fabricSettings?: ServiceFabricClusterFabricSettings[] | cdktf.IResolvable;
    /**
    * node_type block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#node_type ServiceFabricCluster#node_type}
    */
    readonly nodeType: ServiceFabricClusterNodeType[] | cdktf.IResolvable;
    /**
    * reverse_proxy_certificate block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#reverse_proxy_certificate ServiceFabricCluster#reverse_proxy_certificate}
    */
    readonly reverseProxyCertificate?: ServiceFabricClusterReverseProxyCertificate;
    /**
    * reverse_proxy_certificate_common_names block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#reverse_proxy_certificate_common_names ServiceFabricCluster#reverse_proxy_certificate_common_names}
    */
    readonly reverseProxyCertificateCommonNames?: ServiceFabricClusterReverseProxyCertificateCommonNames;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#timeouts ServiceFabricCluster#timeouts}
    */
    readonly timeouts?: ServiceFabricClusterTimeouts;
    /**
    * upgrade_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#upgrade_policy ServiceFabricCluster#upgrade_policy}
    */
    readonly upgradePolicy?: ServiceFabricClusterUpgradePolicy;
}
export interface ServiceFabricClusterAzureActiveDirectory {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#client_application_id ServiceFabricCluster#client_application_id}
    */
    readonly clientApplicationId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#cluster_application_id ServiceFabricCluster#cluster_application_id}
    */
    readonly clusterApplicationId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#tenant_id ServiceFabricCluster#tenant_id}
    */
    readonly tenantId: string;
}
export declare function serviceFabricClusterAzureActiveDirectoryToTerraform(struct?: ServiceFabricClusterAzureActiveDirectoryOutputReference | ServiceFabricClusterAzureActiveDirectory): any;
export declare function serviceFabricClusterAzureActiveDirectoryToHclTerraform(struct?: ServiceFabricClusterAzureActiveDirectoryOutputReference | ServiceFabricClusterAzureActiveDirectory): any;
export declare class ServiceFabricClusterAzureActiveDirectoryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricClusterAzureActiveDirectory | undefined;
    set internalValue(value: ServiceFabricClusterAzureActiveDirectory | undefined);
    private _clientApplicationId?;
    get clientApplicationId(): string;
    set clientApplicationId(value: string);
    get clientApplicationIdInput(): string | undefined;
    private _clusterApplicationId?;
    get clusterApplicationId(): string;
    set clusterApplicationId(value: string);
    get clusterApplicationIdInput(): string | undefined;
    private _tenantId?;
    get tenantId(): string;
    set tenantId(value: string);
    get tenantIdInput(): string | undefined;
}
export interface ServiceFabricClusterCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#thumbprint ServiceFabricCluster#thumbprint}
    */
    readonly thumbprint: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#thumbprint_secondary ServiceFabricCluster#thumbprint_secondary}
    */
    readonly thumbprintSecondary?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#x509_store_name ServiceFabricCluster#x509_store_name}
    */
    readonly x509StoreName: string;
}
export declare function serviceFabricClusterCertificateToTerraform(struct?: ServiceFabricClusterCertificateOutputReference | ServiceFabricClusterCertificate): any;
export declare function serviceFabricClusterCertificateToHclTerraform(struct?: ServiceFabricClusterCertificateOutputReference | ServiceFabricClusterCertificate): any;
export declare class ServiceFabricClusterCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricClusterCertificate | undefined;
    set internalValue(value: ServiceFabricClusterCertificate | undefined);
    private _thumbprint?;
    get thumbprint(): string;
    set thumbprint(value: string);
    get thumbprintInput(): string | undefined;
    private _thumbprintSecondary?;
    get thumbprintSecondary(): string;
    set thumbprintSecondary(value: string);
    resetThumbprintSecondary(): void;
    get thumbprintSecondaryInput(): string | undefined;
    private _x509StoreName?;
    get x509StoreName(): string;
    set x509StoreName(value: string);
    get x509StoreNameInput(): string | undefined;
}
export interface ServiceFabricClusterCertificateCommonNamesCommonNames {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#certificate_common_name ServiceFabricCluster#certificate_common_name}
    */
    readonly certificateCommonName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#certificate_issuer_thumbprint ServiceFabricCluster#certificate_issuer_thumbprint}
    */
    readonly certificateIssuerThumbprint?: string;
}
export declare function serviceFabricClusterCertificateCommonNamesCommonNamesToTerraform(struct?: ServiceFabricClusterCertificateCommonNamesCommonNames | cdktf.IResolvable): any;
export declare function serviceFabricClusterCertificateCommonNamesCommonNamesToHclTerraform(struct?: ServiceFabricClusterCertificateCommonNamesCommonNames | cdktf.IResolvable): any;
export declare class ServiceFabricClusterCertificateCommonNamesCommonNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceFabricClusterCertificateCommonNamesCommonNames | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceFabricClusterCertificateCommonNamesCommonNames | cdktf.IResolvable | undefined);
    private _certificateCommonName?;
    get certificateCommonName(): string;
    set certificateCommonName(value: string);
    get certificateCommonNameInput(): string | undefined;
    private _certificateIssuerThumbprint?;
    get certificateIssuerThumbprint(): string;
    set certificateIssuerThumbprint(value: string);
    resetCertificateIssuerThumbprint(): void;
    get certificateIssuerThumbprintInput(): string | undefined;
}
export declare class ServiceFabricClusterCertificateCommonNamesCommonNamesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServiceFabricClusterCertificateCommonNamesCommonNames[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceFabricClusterCertificateCommonNamesCommonNamesOutputReference;
}
export interface ServiceFabricClusterCertificateCommonNames {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#x509_store_name ServiceFabricCluster#x509_store_name}
    */
    readonly x509StoreName: string;
    /**
    * common_names block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#common_names ServiceFabricCluster#common_names}
    */
    readonly commonNames: ServiceFabricClusterCertificateCommonNamesCommonNames[] | cdktf.IResolvable;
}
export declare function serviceFabricClusterCertificateCommonNamesToTerraform(struct?: ServiceFabricClusterCertificateCommonNamesOutputReference | ServiceFabricClusterCertificateCommonNames): any;
export declare function serviceFabricClusterCertificateCommonNamesToHclTerraform(struct?: ServiceFabricClusterCertificateCommonNamesOutputReference | ServiceFabricClusterCertificateCommonNames): any;
export declare class ServiceFabricClusterCertificateCommonNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricClusterCertificateCommonNames | undefined;
    set internalValue(value: ServiceFabricClusterCertificateCommonNames | undefined);
    private _x509StoreName?;
    get x509StoreName(): string;
    set x509StoreName(value: string);
    get x509StoreNameInput(): string | undefined;
    private _commonNames;
    get commonNames(): ServiceFabricClusterCertificateCommonNamesCommonNamesList;
    putCommonNames(value: ServiceFabricClusterCertificateCommonNamesCommonNames[] | cdktf.IResolvable): void;
    get commonNamesInput(): cdktf.IResolvable | ServiceFabricClusterCertificateCommonNamesCommonNames[] | undefined;
}
export interface ServiceFabricClusterClientCertificateCommonName {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#common_name ServiceFabricCluster#common_name}
    */
    readonly commonName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#is_admin ServiceFabricCluster#is_admin}
    */
    readonly isAdmin: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#issuer_thumbprint ServiceFabricCluster#issuer_thumbprint}
    */
    readonly issuerThumbprint?: string;
}
export declare function serviceFabricClusterClientCertificateCommonNameToTerraform(struct?: ServiceFabricClusterClientCertificateCommonName | cdktf.IResolvable): any;
export declare function serviceFabricClusterClientCertificateCommonNameToHclTerraform(struct?: ServiceFabricClusterClientCertificateCommonName | cdktf.IResolvable): any;
export declare class ServiceFabricClusterClientCertificateCommonNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceFabricClusterClientCertificateCommonName | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceFabricClusterClientCertificateCommonName | cdktf.IResolvable | undefined);
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    private _isAdmin?;
    get isAdmin(): boolean | cdktf.IResolvable;
    set isAdmin(value: boolean | cdktf.IResolvable);
    get isAdminInput(): boolean | cdktf.IResolvable | undefined;
    private _issuerThumbprint?;
    get issuerThumbprint(): string;
    set issuerThumbprint(value: string);
    resetIssuerThumbprint(): void;
    get issuerThumbprintInput(): string | undefined;
}
export declare class ServiceFabricClusterClientCertificateCommonNameList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServiceFabricClusterClientCertificateCommonName[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceFabricClusterClientCertificateCommonNameOutputReference;
}
export interface ServiceFabricClusterClientCertificateThumbprint {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#is_admin ServiceFabricCluster#is_admin}
    */
    readonly isAdmin: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#thumbprint ServiceFabricCluster#thumbprint}
    */
    readonly thumbprint: string;
}
export declare function serviceFabricClusterClientCertificateThumbprintToTerraform(struct?: ServiceFabricClusterClientCertificateThumbprint | cdktf.IResolvable): any;
export declare function serviceFabricClusterClientCertificateThumbprintToHclTerraform(struct?: ServiceFabricClusterClientCertificateThumbprint | cdktf.IResolvable): any;
export declare class ServiceFabricClusterClientCertificateThumbprintOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceFabricClusterClientCertificateThumbprint | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceFabricClusterClientCertificateThumbprint | cdktf.IResolvable | undefined);
    private _isAdmin?;
    get isAdmin(): boolean | cdktf.IResolvable;
    set isAdmin(value: boolean | cdktf.IResolvable);
    get isAdminInput(): boolean | cdktf.IResolvable | undefined;
    private _thumbprint?;
    get thumbprint(): string;
    set thumbprint(value: string);
    get thumbprintInput(): string | undefined;
}
export declare class ServiceFabricClusterClientCertificateThumbprintList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServiceFabricClusterClientCertificateThumbprint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceFabricClusterClientCertificateThumbprintOutputReference;
}
export interface ServiceFabricClusterDiagnosticsConfig {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#blob_endpoint ServiceFabricCluster#blob_endpoint}
    */
    readonly blobEndpoint: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#protected_account_key_name ServiceFabricCluster#protected_account_key_name}
    */
    readonly protectedAccountKeyName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#queue_endpoint ServiceFabricCluster#queue_endpoint}
    */
    readonly queueEndpoint: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#storage_account_name ServiceFabricCluster#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#table_endpoint ServiceFabricCluster#table_endpoint}
    */
    readonly tableEndpoint: string;
}
export declare function serviceFabricClusterDiagnosticsConfigToTerraform(struct?: ServiceFabricClusterDiagnosticsConfigOutputReference | ServiceFabricClusterDiagnosticsConfig): any;
export declare function serviceFabricClusterDiagnosticsConfigToHclTerraform(struct?: ServiceFabricClusterDiagnosticsConfigOutputReference | ServiceFabricClusterDiagnosticsConfig): any;
export declare class ServiceFabricClusterDiagnosticsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricClusterDiagnosticsConfig | undefined;
    set internalValue(value: ServiceFabricClusterDiagnosticsConfig | undefined);
    private _blobEndpoint?;
    get blobEndpoint(): string;
    set blobEndpoint(value: string);
    get blobEndpointInput(): string | undefined;
    private _protectedAccountKeyName?;
    get protectedAccountKeyName(): string;
    set protectedAccountKeyName(value: string);
    get protectedAccountKeyNameInput(): string | undefined;
    private _queueEndpoint?;
    get queueEndpoint(): string;
    set queueEndpoint(value: string);
    get queueEndpointInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    private _tableEndpoint?;
    get tableEndpoint(): string;
    set tableEndpoint(value: string);
    get tableEndpointInput(): string | undefined;
}
export interface ServiceFabricClusterFabricSettings {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#name ServiceFabricCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#parameters ServiceFabricCluster#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
}
export declare function serviceFabricClusterFabricSettingsToTerraform(struct?: ServiceFabricClusterFabricSettings | cdktf.IResolvable): any;
export declare function serviceFabricClusterFabricSettingsToHclTerraform(struct?: ServiceFabricClusterFabricSettings | cdktf.IResolvable): any;
export declare class ServiceFabricClusterFabricSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceFabricClusterFabricSettings | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceFabricClusterFabricSettings | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class ServiceFabricClusterFabricSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServiceFabricClusterFabricSettings[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceFabricClusterFabricSettingsOutputReference;
}
export interface ServiceFabricClusterNodeTypeApplicationPorts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#end_port ServiceFabricCluster#end_port}
    */
    readonly endPort: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#start_port ServiceFabricCluster#start_port}
    */
    readonly startPort: number;
}
export declare function serviceFabricClusterNodeTypeApplicationPortsToTerraform(struct?: ServiceFabricClusterNodeTypeApplicationPortsOutputReference | ServiceFabricClusterNodeTypeApplicationPorts): any;
export declare function serviceFabricClusterNodeTypeApplicationPortsToHclTerraform(struct?: ServiceFabricClusterNodeTypeApplicationPortsOutputReference | ServiceFabricClusterNodeTypeApplicationPorts): any;
export declare class ServiceFabricClusterNodeTypeApplicationPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricClusterNodeTypeApplicationPorts | undefined;
    set internalValue(value: ServiceFabricClusterNodeTypeApplicationPorts | undefined);
    private _endPort?;
    get endPort(): number;
    set endPort(value: number);
    get endPortInput(): number | undefined;
    private _startPort?;
    get startPort(): number;
    set startPort(value: number);
    get startPortInput(): number | undefined;
}
export interface ServiceFabricClusterNodeTypeEphemeralPorts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#end_port ServiceFabricCluster#end_port}
    */
    readonly endPort: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#start_port ServiceFabricCluster#start_port}
    */
    readonly startPort: number;
}
export declare function serviceFabricClusterNodeTypeEphemeralPortsToTerraform(struct?: ServiceFabricClusterNodeTypeEphemeralPortsOutputReference | ServiceFabricClusterNodeTypeEphemeralPorts): any;
export declare function serviceFabricClusterNodeTypeEphemeralPortsToHclTerraform(struct?: ServiceFabricClusterNodeTypeEphemeralPortsOutputReference | ServiceFabricClusterNodeTypeEphemeralPorts): any;
export declare class ServiceFabricClusterNodeTypeEphemeralPortsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricClusterNodeTypeEphemeralPorts | undefined;
    set internalValue(value: ServiceFabricClusterNodeTypeEphemeralPorts | undefined);
    private _endPort?;
    get endPort(): number;
    set endPort(value: number);
    get endPortInput(): number | undefined;
    private _startPort?;
    get startPort(): number;
    set startPort(value: number);
    get startPortInput(): number | undefined;
}
export interface ServiceFabricClusterNodeType {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#capacities ServiceFabricCluster#capacities}
    */
    readonly capacities?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#client_endpoint_port ServiceFabricCluster#client_endpoint_port}
    */
    readonly clientEndpointPort: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#durability_level ServiceFabricCluster#durability_level}
    */
    readonly durabilityLevel?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#http_endpoint_port ServiceFabricCluster#http_endpoint_port}
    */
    readonly httpEndpointPort: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#instance_count ServiceFabricCluster#instance_count}
    */
    readonly instanceCount: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#is_primary ServiceFabricCluster#is_primary}
    */
    readonly isPrimary: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#is_stateless ServiceFabricCluster#is_stateless}
    */
    readonly isStateless?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#multiple_availability_zones ServiceFabricCluster#multiple_availability_zones}
    */
    readonly multipleAvailabilityZones?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#name ServiceFabricCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#placement_properties ServiceFabricCluster#placement_properties}
    */
    readonly placementProperties?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#reverse_proxy_endpoint_port ServiceFabricCluster#reverse_proxy_endpoint_port}
    */
    readonly reverseProxyEndpointPort?: number;
    /**
    * application_ports block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#application_ports ServiceFabricCluster#application_ports}
    */
    readonly applicationPorts?: ServiceFabricClusterNodeTypeApplicationPorts;
    /**
    * ephemeral_ports block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#ephemeral_ports ServiceFabricCluster#ephemeral_ports}
    */
    readonly ephemeralPorts?: ServiceFabricClusterNodeTypeEphemeralPorts;
}
export declare function serviceFabricClusterNodeTypeToTerraform(struct?: ServiceFabricClusterNodeType | cdktf.IResolvable): any;
export declare function serviceFabricClusterNodeTypeToHclTerraform(struct?: ServiceFabricClusterNodeType | cdktf.IResolvable): any;
export declare class ServiceFabricClusterNodeTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceFabricClusterNodeType | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceFabricClusterNodeType | cdktf.IResolvable | undefined);
    private _capacities?;
    get capacities(): {
        [key: string]: string;
    };
    set capacities(value: {
        [key: string]: string;
    });
    resetCapacities(): void;
    get capacitiesInput(): {
        [key: string]: string;
    } | undefined;
    private _clientEndpointPort?;
    get clientEndpointPort(): number;
    set clientEndpointPort(value: number);
    get clientEndpointPortInput(): number | undefined;
    private _durabilityLevel?;
    get durabilityLevel(): string;
    set durabilityLevel(value: string);
    resetDurabilityLevel(): void;
    get durabilityLevelInput(): string | undefined;
    private _httpEndpointPort?;
    get httpEndpointPort(): number;
    set httpEndpointPort(value: number);
    get httpEndpointPortInput(): number | undefined;
    private _instanceCount?;
    get instanceCount(): number;
    set instanceCount(value: number);
    get instanceCountInput(): number | undefined;
    private _isPrimary?;
    get isPrimary(): boolean | cdktf.IResolvable;
    set isPrimary(value: boolean | cdktf.IResolvable);
    get isPrimaryInput(): boolean | cdktf.IResolvable | undefined;
    private _isStateless?;
    get isStateless(): boolean | cdktf.IResolvable;
    set isStateless(value: boolean | cdktf.IResolvable);
    resetIsStateless(): void;
    get isStatelessInput(): boolean | cdktf.IResolvable | undefined;
    private _multipleAvailabilityZones?;
    get multipleAvailabilityZones(): boolean | cdktf.IResolvable;
    set multipleAvailabilityZones(value: boolean | cdktf.IResolvable);
    resetMultipleAvailabilityZones(): void;
    get multipleAvailabilityZonesInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _placementProperties?;
    get placementProperties(): {
        [key: string]: string;
    };
    set placementProperties(value: {
        [key: string]: string;
    });
    resetPlacementProperties(): void;
    get placementPropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _reverseProxyEndpointPort?;
    get reverseProxyEndpointPort(): number;
    set reverseProxyEndpointPort(value: number);
    resetReverseProxyEndpointPort(): void;
    get reverseProxyEndpointPortInput(): number | undefined;
    private _applicationPorts;
    get applicationPorts(): ServiceFabricClusterNodeTypeApplicationPortsOutputReference;
    putApplicationPorts(value: ServiceFabricClusterNodeTypeApplicationPorts): void;
    resetApplicationPorts(): void;
    get applicationPortsInput(): ServiceFabricClusterNodeTypeApplicationPorts | undefined;
    private _ephemeralPorts;
    get ephemeralPorts(): ServiceFabricClusterNodeTypeEphemeralPortsOutputReference;
    putEphemeralPorts(value: ServiceFabricClusterNodeTypeEphemeralPorts): void;
    resetEphemeralPorts(): void;
    get ephemeralPortsInput(): ServiceFabricClusterNodeTypeEphemeralPorts | undefined;
}
export declare class ServiceFabricClusterNodeTypeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServiceFabricClusterNodeType[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceFabricClusterNodeTypeOutputReference;
}
export interface ServiceFabricClusterReverseProxyCertificate {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#thumbprint ServiceFabricCluster#thumbprint}
    */
    readonly thumbprint: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#thumbprint_secondary ServiceFabricCluster#thumbprint_secondary}
    */
    readonly thumbprintSecondary?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#x509_store_name ServiceFabricCluster#x509_store_name}
    */
    readonly x509StoreName: string;
}
export declare function serviceFabricClusterReverseProxyCertificateToTerraform(struct?: ServiceFabricClusterReverseProxyCertificateOutputReference | ServiceFabricClusterReverseProxyCertificate): any;
export declare function serviceFabricClusterReverseProxyCertificateToHclTerraform(struct?: ServiceFabricClusterReverseProxyCertificateOutputReference | ServiceFabricClusterReverseProxyCertificate): any;
export declare class ServiceFabricClusterReverseProxyCertificateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricClusterReverseProxyCertificate | undefined;
    set internalValue(value: ServiceFabricClusterReverseProxyCertificate | undefined);
    private _thumbprint?;
    get thumbprint(): string;
    set thumbprint(value: string);
    get thumbprintInput(): string | undefined;
    private _thumbprintSecondary?;
    get thumbprintSecondary(): string;
    set thumbprintSecondary(value: string);
    resetThumbprintSecondary(): void;
    get thumbprintSecondaryInput(): string | undefined;
    private _x509StoreName?;
    get x509StoreName(): string;
    set x509StoreName(value: string);
    get x509StoreNameInput(): string | undefined;
}
export interface ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#certificate_common_name ServiceFabricCluster#certificate_common_name}
    */
    readonly certificateCommonName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#certificate_issuer_thumbprint ServiceFabricCluster#certificate_issuer_thumbprint}
    */
    readonly certificateIssuerThumbprint?: string;
}
export declare function serviceFabricClusterReverseProxyCertificateCommonNamesCommonNamesToTerraform(struct?: ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames | cdktf.IResolvable): any;
export declare function serviceFabricClusterReverseProxyCertificateCommonNamesCommonNamesToHclTerraform(struct?: ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames | cdktf.IResolvable): any;
export declare class ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames | cdktf.IResolvable | undefined);
    private _certificateCommonName?;
    get certificateCommonName(): string;
    set certificateCommonName(value: string);
    get certificateCommonNameInput(): string | undefined;
    private _certificateIssuerThumbprint?;
    get certificateIssuerThumbprint(): string;
    set certificateIssuerThumbprint(value: string);
    resetCertificateIssuerThumbprint(): void;
    get certificateIssuerThumbprintInput(): string | undefined;
}
export declare class ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNamesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNamesOutputReference;
}
export interface ServiceFabricClusterReverseProxyCertificateCommonNames {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#x509_store_name ServiceFabricCluster#x509_store_name}
    */
    readonly x509StoreName: string;
    /**
    * common_names block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#common_names ServiceFabricCluster#common_names}
    */
    readonly commonNames: ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames[] | cdktf.IResolvable;
}
export declare function serviceFabricClusterReverseProxyCertificateCommonNamesToTerraform(struct?: ServiceFabricClusterReverseProxyCertificateCommonNamesOutputReference | ServiceFabricClusterReverseProxyCertificateCommonNames): any;
export declare function serviceFabricClusterReverseProxyCertificateCommonNamesToHclTerraform(struct?: ServiceFabricClusterReverseProxyCertificateCommonNamesOutputReference | ServiceFabricClusterReverseProxyCertificateCommonNames): any;
export declare class ServiceFabricClusterReverseProxyCertificateCommonNamesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricClusterReverseProxyCertificateCommonNames | undefined;
    set internalValue(value: ServiceFabricClusterReverseProxyCertificateCommonNames | undefined);
    private _x509StoreName?;
    get x509StoreName(): string;
    set x509StoreName(value: string);
    get x509StoreNameInput(): string | undefined;
    private _commonNames;
    get commonNames(): ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNamesList;
    putCommonNames(value: ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames[] | cdktf.IResolvable): void;
    get commonNamesInput(): cdktf.IResolvable | ServiceFabricClusterReverseProxyCertificateCommonNamesCommonNames[] | undefined;
}
export interface ServiceFabricClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#create ServiceFabricCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#delete ServiceFabricCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#read ServiceFabricCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#update ServiceFabricCluster#update}
    */
    readonly update?: string;
}
export declare function serviceFabricClusterTimeoutsToTerraform(struct?: ServiceFabricClusterTimeouts | cdktf.IResolvable): any;
export declare function serviceFabricClusterTimeoutsToHclTerraform(struct?: ServiceFabricClusterTimeouts | cdktf.IResolvable): any;
export declare class ServiceFabricClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceFabricClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ServiceFabricClusterUpgradePolicyDeltaHealthPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#max_delta_unhealthy_applications_percent ServiceFabricCluster#max_delta_unhealthy_applications_percent}
    */
    readonly maxDeltaUnhealthyApplicationsPercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#max_delta_unhealthy_nodes_percent ServiceFabricCluster#max_delta_unhealthy_nodes_percent}
    */
    readonly maxDeltaUnhealthyNodesPercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#max_upgrade_domain_delta_unhealthy_nodes_percent ServiceFabricCluster#max_upgrade_domain_delta_unhealthy_nodes_percent}
    */
    readonly maxUpgradeDomainDeltaUnhealthyNodesPercent?: number;
}
export declare function serviceFabricClusterUpgradePolicyDeltaHealthPolicyToTerraform(struct?: ServiceFabricClusterUpgradePolicyDeltaHealthPolicyOutputReference | ServiceFabricClusterUpgradePolicyDeltaHealthPolicy): any;
export declare function serviceFabricClusterUpgradePolicyDeltaHealthPolicyToHclTerraform(struct?: ServiceFabricClusterUpgradePolicyDeltaHealthPolicyOutputReference | ServiceFabricClusterUpgradePolicyDeltaHealthPolicy): any;
export declare class ServiceFabricClusterUpgradePolicyDeltaHealthPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricClusterUpgradePolicyDeltaHealthPolicy | undefined;
    set internalValue(value: ServiceFabricClusterUpgradePolicyDeltaHealthPolicy | undefined);
    private _maxDeltaUnhealthyApplicationsPercent?;
    get maxDeltaUnhealthyApplicationsPercent(): number;
    set maxDeltaUnhealthyApplicationsPercent(value: number);
    resetMaxDeltaUnhealthyApplicationsPercent(): void;
    get maxDeltaUnhealthyApplicationsPercentInput(): number | undefined;
    private _maxDeltaUnhealthyNodesPercent?;
    get maxDeltaUnhealthyNodesPercent(): number;
    set maxDeltaUnhealthyNodesPercent(value: number);
    resetMaxDeltaUnhealthyNodesPercent(): void;
    get maxDeltaUnhealthyNodesPercentInput(): number | undefined;
    private _maxUpgradeDomainDeltaUnhealthyNodesPercent?;
    get maxUpgradeDomainDeltaUnhealthyNodesPercent(): number;
    set maxUpgradeDomainDeltaUnhealthyNodesPercent(value: number);
    resetMaxUpgradeDomainDeltaUnhealthyNodesPercent(): void;
    get maxUpgradeDomainDeltaUnhealthyNodesPercentInput(): number | undefined;
}
export interface ServiceFabricClusterUpgradePolicyHealthPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#max_unhealthy_applications_percent ServiceFabricCluster#max_unhealthy_applications_percent}
    */
    readonly maxUnhealthyApplicationsPercent?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#max_unhealthy_nodes_percent ServiceFabricCluster#max_unhealthy_nodes_percent}
    */
    readonly maxUnhealthyNodesPercent?: number;
}
export declare function serviceFabricClusterUpgradePolicyHealthPolicyToTerraform(struct?: ServiceFabricClusterUpgradePolicyHealthPolicyOutputReference | ServiceFabricClusterUpgradePolicyHealthPolicy): any;
export declare function serviceFabricClusterUpgradePolicyHealthPolicyToHclTerraform(struct?: ServiceFabricClusterUpgradePolicyHealthPolicyOutputReference | ServiceFabricClusterUpgradePolicyHealthPolicy): any;
export declare class ServiceFabricClusterUpgradePolicyHealthPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricClusterUpgradePolicyHealthPolicy | undefined;
    set internalValue(value: ServiceFabricClusterUpgradePolicyHealthPolicy | undefined);
    private _maxUnhealthyApplicationsPercent?;
    get maxUnhealthyApplicationsPercent(): number;
    set maxUnhealthyApplicationsPercent(value: number);
    resetMaxUnhealthyApplicationsPercent(): void;
    get maxUnhealthyApplicationsPercentInput(): number | undefined;
    private _maxUnhealthyNodesPercent?;
    get maxUnhealthyNodesPercent(): number;
    set maxUnhealthyNodesPercent(value: number);
    resetMaxUnhealthyNodesPercent(): void;
    get maxUnhealthyNodesPercentInput(): number | undefined;
}
export interface ServiceFabricClusterUpgradePolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#force_restart_enabled ServiceFabricCluster#force_restart_enabled}
    */
    readonly forceRestartEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#health_check_retry_timeout ServiceFabricCluster#health_check_retry_timeout}
    */
    readonly healthCheckRetryTimeout?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#health_check_stable_duration ServiceFabricCluster#health_check_stable_duration}
    */
    readonly healthCheckStableDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#health_check_wait_duration ServiceFabricCluster#health_check_wait_duration}
    */
    readonly healthCheckWaitDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#upgrade_domain_timeout ServiceFabricCluster#upgrade_domain_timeout}
    */
    readonly upgradeDomainTimeout?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#upgrade_replica_set_check_timeout ServiceFabricCluster#upgrade_replica_set_check_timeout}
    */
    readonly upgradeReplicaSetCheckTimeout?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#upgrade_timeout ServiceFabricCluster#upgrade_timeout}
    */
    readonly upgradeTimeout?: string;
    /**
    * delta_health_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#delta_health_policy ServiceFabricCluster#delta_health_policy}
    */
    readonly deltaHealthPolicy?: ServiceFabricClusterUpgradePolicyDeltaHealthPolicy;
    /**
    * health_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#health_policy ServiceFabricCluster#health_policy}
    */
    readonly healthPolicy?: ServiceFabricClusterUpgradePolicyHealthPolicy;
}
export declare function serviceFabricClusterUpgradePolicyToTerraform(struct?: ServiceFabricClusterUpgradePolicyOutputReference | ServiceFabricClusterUpgradePolicy): any;
export declare function serviceFabricClusterUpgradePolicyToHclTerraform(struct?: ServiceFabricClusterUpgradePolicyOutputReference | ServiceFabricClusterUpgradePolicy): any;
export declare class ServiceFabricClusterUpgradePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFabricClusterUpgradePolicy | undefined;
    set internalValue(value: ServiceFabricClusterUpgradePolicy | undefined);
    private _forceRestartEnabled?;
    get forceRestartEnabled(): boolean | cdktf.IResolvable;
    set forceRestartEnabled(value: boolean | cdktf.IResolvable);
    resetForceRestartEnabled(): void;
    get forceRestartEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _healthCheckRetryTimeout?;
    get healthCheckRetryTimeout(): string;
    set healthCheckRetryTimeout(value: string);
    resetHealthCheckRetryTimeout(): void;
    get healthCheckRetryTimeoutInput(): string | undefined;
    private _healthCheckStableDuration?;
    get healthCheckStableDuration(): string;
    set healthCheckStableDuration(value: string);
    resetHealthCheckStableDuration(): void;
    get healthCheckStableDurationInput(): string | undefined;
    private _healthCheckWaitDuration?;
    get healthCheckWaitDuration(): string;
    set healthCheckWaitDuration(value: string);
    resetHealthCheckWaitDuration(): void;
    get healthCheckWaitDurationInput(): string | undefined;
    private _upgradeDomainTimeout?;
    get upgradeDomainTimeout(): string;
    set upgradeDomainTimeout(value: string);
    resetUpgradeDomainTimeout(): void;
    get upgradeDomainTimeoutInput(): string | undefined;
    private _upgradeReplicaSetCheckTimeout?;
    get upgradeReplicaSetCheckTimeout(): string;
    set upgradeReplicaSetCheckTimeout(value: string);
    resetUpgradeReplicaSetCheckTimeout(): void;
    get upgradeReplicaSetCheckTimeoutInput(): string | undefined;
    private _upgradeTimeout?;
    get upgradeTimeout(): string;
    set upgradeTimeout(value: string);
    resetUpgradeTimeout(): void;
    get upgradeTimeoutInput(): string | undefined;
    private _deltaHealthPolicy;
    get deltaHealthPolicy(): ServiceFabricClusterUpgradePolicyDeltaHealthPolicyOutputReference;
    putDeltaHealthPolicy(value: ServiceFabricClusterUpgradePolicyDeltaHealthPolicy): void;
    resetDeltaHealthPolicy(): void;
    get deltaHealthPolicyInput(): ServiceFabricClusterUpgradePolicyDeltaHealthPolicy | undefined;
    private _healthPolicy;
    get healthPolicy(): ServiceFabricClusterUpgradePolicyHealthPolicyOutputReference;
    putHealthPolicy(value: ServiceFabricClusterUpgradePolicyHealthPolicy): void;
    resetHealthPolicy(): void;
    get healthPolicyInput(): ServiceFabricClusterUpgradePolicyHealthPolicy | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster azurerm_service_fabric_cluster}
*/
export declare class ServiceFabricCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_service_fabric_cluster";
    /**
    * Generates CDKTF code for importing a ServiceFabricCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ServiceFabricCluster to import
    * @param importFromId The id of the existing ServiceFabricCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ServiceFabricCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/service_fabric_cluster azurerm_service_fabric_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceFabricClusterConfig
    */
    constructor(scope: Construct, id: string, config: ServiceFabricClusterConfig);
    private _addOnFeatures?;
    get addOnFeatures(): string[];
    set addOnFeatures(value: string[]);
    resetAddOnFeatures(): void;
    get addOnFeaturesInput(): string[] | undefined;
    private _clusterCodeVersion?;
    get clusterCodeVersion(): string;
    set clusterCodeVersion(value: string);
    resetClusterCodeVersion(): void;
    get clusterCodeVersionInput(): string | undefined;
    get clusterEndpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _managementEndpoint?;
    get managementEndpoint(): string;
    set managementEndpoint(value: string);
    get managementEndpointInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _reliabilityLevel?;
    get reliabilityLevel(): string;
    set reliabilityLevel(value: string);
    get reliabilityLevelInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceFabricZonalUpgradeMode?;
    get serviceFabricZonalUpgradeMode(): string;
    set serviceFabricZonalUpgradeMode(value: string);
    resetServiceFabricZonalUpgradeMode(): void;
    get serviceFabricZonalUpgradeModeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _upgradeMode?;
    get upgradeMode(): string;
    set upgradeMode(value: string);
    get upgradeModeInput(): string | undefined;
    private _vmImage?;
    get vmImage(): string;
    set vmImage(value: string);
    get vmImageInput(): string | undefined;
    private _vmssZonalUpgradeMode?;
    get vmssZonalUpgradeMode(): string;
    set vmssZonalUpgradeMode(value: string);
    resetVmssZonalUpgradeMode(): void;
    get vmssZonalUpgradeModeInput(): string | undefined;
    private _azureActiveDirectory;
    get azureActiveDirectory(): ServiceFabricClusterAzureActiveDirectoryOutputReference;
    putAzureActiveDirectory(value: ServiceFabricClusterAzureActiveDirectory): void;
    resetAzureActiveDirectory(): void;
    get azureActiveDirectoryInput(): ServiceFabricClusterAzureActiveDirectory | undefined;
    private _certificate;
    get certificate(): ServiceFabricClusterCertificateOutputReference;
    putCertificate(value: ServiceFabricClusterCertificate): void;
    resetCertificate(): void;
    get certificateInput(): ServiceFabricClusterCertificate | undefined;
    private _certificateCommonNames;
    get certificateCommonNames(): ServiceFabricClusterCertificateCommonNamesOutputReference;
    putCertificateCommonNames(value: ServiceFabricClusterCertificateCommonNames): void;
    resetCertificateCommonNames(): void;
    get certificateCommonNamesInput(): ServiceFabricClusterCertificateCommonNames | undefined;
    private _clientCertificateCommonName;
    get clientCertificateCommonName(): ServiceFabricClusterClientCertificateCommonNameList;
    putClientCertificateCommonName(value: ServiceFabricClusterClientCertificateCommonName[] | cdktf.IResolvable): void;
    resetClientCertificateCommonName(): void;
    get clientCertificateCommonNameInput(): cdktf.IResolvable | ServiceFabricClusterClientCertificateCommonName[] | undefined;
    private _clientCertificateThumbprint;
    get clientCertificateThumbprint(): ServiceFabricClusterClientCertificateThumbprintList;
    putClientCertificateThumbprint(value: ServiceFabricClusterClientCertificateThumbprint[] | cdktf.IResolvable): void;
    resetClientCertificateThumbprint(): void;
    get clientCertificateThumbprintInput(): cdktf.IResolvable | ServiceFabricClusterClientCertificateThumbprint[] | undefined;
    private _diagnosticsConfig;
    get diagnosticsConfig(): ServiceFabricClusterDiagnosticsConfigOutputReference;
    putDiagnosticsConfig(value: ServiceFabricClusterDiagnosticsConfig): void;
    resetDiagnosticsConfig(): void;
    get diagnosticsConfigInput(): ServiceFabricClusterDiagnosticsConfig | undefined;
    private _fabricSettings;
    get fabricSettings(): ServiceFabricClusterFabricSettingsList;
    putFabricSettings(value: ServiceFabricClusterFabricSettings[] | cdktf.IResolvable): void;
    resetFabricSettings(): void;
    get fabricSettingsInput(): cdktf.IResolvable | ServiceFabricClusterFabricSettings[] | undefined;
    private _nodeType;
    get nodeType(): ServiceFabricClusterNodeTypeList;
    putNodeType(value: ServiceFabricClusterNodeType[] | cdktf.IResolvable): void;
    get nodeTypeInput(): cdktf.IResolvable | ServiceFabricClusterNodeType[] | undefined;
    private _reverseProxyCertificate;
    get reverseProxyCertificate(): ServiceFabricClusterReverseProxyCertificateOutputReference;
    putReverseProxyCertificate(value: ServiceFabricClusterReverseProxyCertificate): void;
    resetReverseProxyCertificate(): void;
    get reverseProxyCertificateInput(): ServiceFabricClusterReverseProxyCertificate | undefined;
    private _reverseProxyCertificateCommonNames;
    get reverseProxyCertificateCommonNames(): ServiceFabricClusterReverseProxyCertificateCommonNamesOutputReference;
    putReverseProxyCertificateCommonNames(value: ServiceFabricClusterReverseProxyCertificateCommonNames): void;
    resetReverseProxyCertificateCommonNames(): void;
    get reverseProxyCertificateCommonNamesInput(): ServiceFabricClusterReverseProxyCertificateCommonNames | undefined;
    private _timeouts;
    get timeouts(): ServiceFabricClusterTimeoutsOutputReference;
    putTimeouts(value: ServiceFabricClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ServiceFabricClusterTimeouts | undefined;
    private _upgradePolicy;
    get upgradePolicy(): ServiceFabricClusterUpgradePolicyOutputReference;
    putUpgradePolicy(value: ServiceFabricClusterUpgradePolicy): void;
    resetUpgradePolicy(): void;
    get upgradePolicyInput(): ServiceFabricClusterUpgradePolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
