/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#collation SqlDatabase#collation}
    */
    readonly collation?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#create_mode SqlDatabase#create_mode}
    */
    readonly createMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#edition SqlDatabase#edition}
    */
    readonly edition?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#elastic_pool_name SqlDatabase#elastic_pool_name}
    */
    readonly elasticPoolName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#id SqlDatabase#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#location SqlDatabase#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#max_size_bytes SqlDatabase#max_size_bytes}
    */
    readonly maxSizeBytes?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#max_size_gb SqlDatabase#max_size_gb}
    */
    readonly maxSizeGb?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#name SqlDatabase#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#read_scale SqlDatabase#read_scale}
    */
    readonly readScale?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#requested_service_objective_id SqlDatabase#requested_service_objective_id}
    */
    readonly requestedServiceObjectiveId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#requested_service_objective_name SqlDatabase#requested_service_objective_name}
    */
    readonly requestedServiceObjectiveName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#resource_group_name SqlDatabase#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#restore_point_in_time SqlDatabase#restore_point_in_time}
    */
    readonly restorePointInTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#server_name SqlDatabase#server_name}
    */
    readonly serverName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#source_database_deletion_date SqlDatabase#source_database_deletion_date}
    */
    readonly sourceDatabaseDeletionDate?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#source_database_id SqlDatabase#source_database_id}
    */
    readonly sourceDatabaseId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#tags SqlDatabase#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#zone_redundant SqlDatabase#zone_redundant}
    */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
    /**
    * import block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#import SqlDatabase#import}
    */
    readonly import?: SqlDatabaseImport;
    /**
    * threat_detection_policy block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#threat_detection_policy SqlDatabase#threat_detection_policy}
    */
    readonly threatDetectionPolicy?: SqlDatabaseThreatDetectionPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#timeouts SqlDatabase#timeouts}
    */
    readonly timeouts?: SqlDatabaseTimeouts;
}
export interface SqlDatabaseImport {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#administrator_login SqlDatabase#administrator_login}
    */
    readonly administratorLogin: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#administrator_login_password SqlDatabase#administrator_login_password}
    */
    readonly administratorLoginPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#authentication_type SqlDatabase#authentication_type}
    */
    readonly authenticationType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#operation_mode SqlDatabase#operation_mode}
    */
    readonly operationMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#storage_key SqlDatabase#storage_key}
    */
    readonly storageKey: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#storage_key_type SqlDatabase#storage_key_type}
    */
    readonly storageKeyType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#storage_uri SqlDatabase#storage_uri}
    */
    readonly storageUri: string;
}
export declare function sqlDatabaseImportToTerraform(struct?: SqlDatabaseImportOutputReference | SqlDatabaseImport): any;
export declare function sqlDatabaseImportToHclTerraform(struct?: SqlDatabaseImportOutputReference | SqlDatabaseImport): any;
export declare class SqlDatabaseImportOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseImport | undefined;
    set internalValue(value: SqlDatabaseImport | undefined);
    private _administratorLogin?;
    get administratorLogin(): string;
    set administratorLogin(value: string);
    get administratorLoginInput(): string | undefined;
    private _administratorLoginPassword?;
    get administratorLoginPassword(): string;
    set administratorLoginPassword(value: string);
    get administratorLoginPasswordInput(): string | undefined;
    private _authenticationType?;
    get authenticationType(): string;
    set authenticationType(value: string);
    get authenticationTypeInput(): string | undefined;
    private _operationMode?;
    get operationMode(): string;
    set operationMode(value: string);
    resetOperationMode(): void;
    get operationModeInput(): string | undefined;
    private _storageKey?;
    get storageKey(): string;
    set storageKey(value: string);
    get storageKeyInput(): string | undefined;
    private _storageKeyType?;
    get storageKeyType(): string;
    set storageKeyType(value: string);
    get storageKeyTypeInput(): string | undefined;
    private _storageUri?;
    get storageUri(): string;
    set storageUri(value: string);
    get storageUriInput(): string | undefined;
}
export interface SqlDatabaseThreatDetectionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#disabled_alerts SqlDatabase#disabled_alerts}
    */
    readonly disabledAlerts?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#email_account_admins SqlDatabase#email_account_admins}
    */
    readonly emailAccountAdmins?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#email_addresses SqlDatabase#email_addresses}
    */
    readonly emailAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#retention_days SqlDatabase#retention_days}
    */
    readonly retentionDays?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#state SqlDatabase#state}
    */
    readonly state?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#storage_account_access_key SqlDatabase#storage_account_access_key}
    */
    readonly storageAccountAccessKey?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#storage_endpoint SqlDatabase#storage_endpoint}
    */
    readonly storageEndpoint?: string;
}
export declare function sqlDatabaseThreatDetectionPolicyToTerraform(struct?: SqlDatabaseThreatDetectionPolicyOutputReference | SqlDatabaseThreatDetectionPolicy): any;
export declare function sqlDatabaseThreatDetectionPolicyToHclTerraform(struct?: SqlDatabaseThreatDetectionPolicyOutputReference | SqlDatabaseThreatDetectionPolicy): any;
export declare class SqlDatabaseThreatDetectionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseThreatDetectionPolicy | undefined;
    set internalValue(value: SqlDatabaseThreatDetectionPolicy | undefined);
    private _disabledAlerts?;
    get disabledAlerts(): string[];
    set disabledAlerts(value: string[]);
    resetDisabledAlerts(): void;
    get disabledAlertsInput(): string[] | undefined;
    private _emailAccountAdmins?;
    get emailAccountAdmins(): string;
    set emailAccountAdmins(value: string);
    resetEmailAccountAdmins(): void;
    get emailAccountAdminsInput(): string | undefined;
    private _emailAddresses?;
    get emailAddresses(): string[];
    set emailAddresses(value: string[]);
    resetEmailAddresses(): void;
    get emailAddressesInput(): string[] | undefined;
    private _retentionDays?;
    get retentionDays(): number;
    set retentionDays(value: number);
    resetRetentionDays(): void;
    get retentionDaysInput(): number | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _storageAccountAccessKey?;
    get storageAccountAccessKey(): string;
    set storageAccountAccessKey(value: string);
    resetStorageAccountAccessKey(): void;
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageEndpoint?;
    get storageEndpoint(): string;
    set storageEndpoint(value: string);
    resetStorageEndpoint(): void;
    get storageEndpointInput(): string | undefined;
}
export interface SqlDatabaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#create SqlDatabase#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#delete SqlDatabase#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#read SqlDatabase#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#update SqlDatabase#update}
    */
    readonly update?: string;
}
export declare function sqlDatabaseTimeoutsToTerraform(struct?: SqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare function sqlDatabaseTimeoutsToHclTerraform(struct?: SqlDatabaseTimeouts | cdktf.IResolvable): any;
export declare class SqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SqlDatabaseTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SqlDatabaseTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database azurerm_sql_database}
*/
export declare class SqlDatabase extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_sql_database";
    /**
    * Generates CDKTF code for importing a SqlDatabase resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SqlDatabase to import
    * @param importFromId The id of the existing SqlDatabase that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SqlDatabase to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/sql_database azurerm_sql_database} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SqlDatabaseConfig
    */
    constructor(scope: Construct, id: string, config: SqlDatabaseConfig);
    private _collation?;
    get collation(): string;
    set collation(value: string);
    resetCollation(): void;
    get collationInput(): string | undefined;
    private _createMode?;
    get createMode(): string;
    set createMode(value: string);
    resetCreateMode(): void;
    get createModeInput(): string | undefined;
    get creationDate(): string;
    get defaultSecondaryLocation(): string;
    private _edition?;
    get edition(): string;
    set edition(value: string);
    resetEdition(): void;
    get editionInput(): string | undefined;
    private _elasticPoolName?;
    get elasticPoolName(): string;
    set elasticPoolName(value: string);
    resetElasticPoolName(): void;
    get elasticPoolNameInput(): string | undefined;
    get encryption(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _maxSizeBytes?;
    get maxSizeBytes(): string;
    set maxSizeBytes(value: string);
    resetMaxSizeBytes(): void;
    get maxSizeBytesInput(): string | undefined;
    private _maxSizeGb?;
    get maxSizeGb(): string;
    set maxSizeGb(value: string);
    resetMaxSizeGb(): void;
    get maxSizeGbInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _readScale?;
    get readScale(): boolean | cdktf.IResolvable;
    set readScale(value: boolean | cdktf.IResolvable);
    resetReadScale(): void;
    get readScaleInput(): boolean | cdktf.IResolvable | undefined;
    private _requestedServiceObjectiveId?;
    get requestedServiceObjectiveId(): string;
    set requestedServiceObjectiveId(value: string);
    resetRequestedServiceObjectiveId(): void;
    get requestedServiceObjectiveIdInput(): string | undefined;
    private _requestedServiceObjectiveName?;
    get requestedServiceObjectiveName(): string;
    set requestedServiceObjectiveName(value: string);
    resetRequestedServiceObjectiveName(): void;
    get requestedServiceObjectiveNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _restorePointInTime?;
    get restorePointInTime(): string;
    set restorePointInTime(value: string);
    resetRestorePointInTime(): void;
    get restorePointInTimeInput(): string | undefined;
    private _serverName?;
    get serverName(): string;
    set serverName(value: string);
    get serverNameInput(): string | undefined;
    private _sourceDatabaseDeletionDate?;
    get sourceDatabaseDeletionDate(): string;
    set sourceDatabaseDeletionDate(value: string);
    resetSourceDatabaseDeletionDate(): void;
    get sourceDatabaseDeletionDateInput(): string | undefined;
    private _sourceDatabaseId?;
    get sourceDatabaseId(): string;
    set sourceDatabaseId(value: string);
    resetSourceDatabaseId(): void;
    get sourceDatabaseIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _zoneRedundant?;
    get zoneRedundant(): boolean | cdktf.IResolvable;
    set zoneRedundant(value: boolean | cdktf.IResolvable);
    resetZoneRedundant(): void;
    get zoneRedundantInput(): boolean | cdktf.IResolvable | undefined;
    private _import;
    get import(): SqlDatabaseImportOutputReference;
    putImport(value: SqlDatabaseImport): void;
    resetImport(): void;
    get importInput(): SqlDatabaseImport | undefined;
    private _threatDetectionPolicy;
    get threatDetectionPolicy(): SqlDatabaseThreatDetectionPolicyOutputReference;
    putThreatDetectionPolicy(value: SqlDatabaseThreatDetectionPolicy): void;
    resetThreatDetectionPolicy(): void;
    get threatDetectionPolicyInput(): SqlDatabaseThreatDetectionPolicy | undefined;
    private _timeouts;
    get timeouts(): SqlDatabaseTimeoutsOutputReference;
    putTimeouts(value: SqlDatabaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SqlDatabaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
