/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageMoverAgentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent#arc_virtual_machine_id StorageMoverAgent#arc_virtual_machine_id}
    */
    readonly arcVirtualMachineId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent#arc_virtual_machine_uuid StorageMoverAgent#arc_virtual_machine_uuid}
    */
    readonly arcVirtualMachineUuid: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent#description StorageMoverAgent#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent#id StorageMoverAgent#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent#name StorageMoverAgent#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent#storage_mover_id StorageMoverAgent#storage_mover_id}
    */
    readonly storageMoverId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent#timeouts StorageMoverAgent#timeouts}
    */
    readonly timeouts?: StorageMoverAgentTimeouts;
}
export interface StorageMoverAgentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent#create StorageMoverAgent#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent#delete StorageMoverAgent#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent#read StorageMoverAgent#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent#update StorageMoverAgent#update}
    */
    readonly update?: string;
}
export declare function storageMoverAgentTimeoutsToTerraform(struct?: StorageMoverAgentTimeouts | cdktf.IResolvable): any;
export declare function storageMoverAgentTimeoutsToHclTerraform(struct?: StorageMoverAgentTimeouts | cdktf.IResolvable): any;
export declare class StorageMoverAgentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageMoverAgentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageMoverAgentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent azurerm_storage_mover_agent}
*/
export declare class StorageMoverAgent extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_storage_mover_agent";
    /**
    * Generates CDKTF code for importing a StorageMoverAgent resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the StorageMoverAgent to import
    * @param importFromId The id of the existing StorageMoverAgent that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the StorageMoverAgent to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.99.0/docs/resources/storage_mover_agent azurerm_storage_mover_agent} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageMoverAgentConfig
    */
    constructor(scope: Construct, id: string, config: StorageMoverAgentConfig);
    private _arcVirtualMachineId?;
    get arcVirtualMachineId(): string;
    set arcVirtualMachineId(value: string);
    get arcVirtualMachineIdInput(): string | undefined;
    private _arcVirtualMachineUuid?;
    get arcVirtualMachineUuid(): string;
    set arcVirtualMachineUuid(value: string);
    get arcVirtualMachineUuidInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageMoverId?;
    get storageMoverId(): string;
    set storageMoverId(value: string);
    get storageMoverIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): StorageMoverAgentTimeoutsOutputReference;
    putTimeouts(value: StorageMoverAgentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageMoverAgentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
