# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecurityProjectArgs', 'SecurityProject']

@pulumi.input_type
class SecurityProjectArgs:
    def __init__(__self__, *,
                 region_id: pulumi.Input[str],
                 admin_features_package: Optional[pulumi.Input[str]] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_types: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProjectProductTypeArgs']]]] = None):
        """
        The set of arguments for constructing a SecurityProject resource.
        :param pulumi.Input[str] region_id: Unique human-readable identifier for a region in Elastic Cloud.
        :param pulumi.Input[str] admin_features_package: admin features package (BYOK, BYOIDP, CCS, CCR)
        :param pulumi.Input[str] alias: A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        :param pulumi.Input[str] name: Descriptive name for a project.
        """
        pulumi.set(__self__, "region_id", region_id)
        if admin_features_package is not None:
            pulumi.set(__self__, "admin_features_package", admin_features_package)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_types is not None:
            pulumi.set(__self__, "product_types", product_types)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Input[str]:
        """
        Unique human-readable identifier for a region in Elastic Cloud.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "region_id", value)

    @property
    @pulumi.getter(name="adminFeaturesPackage")
    def admin_features_package(self) -> Optional[pulumi.Input[str]]:
        """
        admin features package (BYOK, BYOIDP, CCS, CCR)
        """
        return pulumi.get(self, "admin_features_package")

    @admin_features_package.setter
    def admin_features_package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_features_package", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Descriptive name for a project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="productTypes")
    def product_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProjectProductTypeArgs']]]]:
        return pulumi.get(self, "product_types")

    @product_types.setter
    def product_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProjectProductTypeArgs']]]]):
        pulumi.set(self, "product_types", value)


@pulumi.input_type
class _SecurityProjectState:
    def __init__(__self__, *,
                 admin_features_package: Optional[pulumi.Input[str]] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 cloud_id: Optional[pulumi.Input[str]] = None,
                 credentials: Optional[pulumi.Input['SecurityProjectCredentialsArgs']] = None,
                 endpoints: Optional[pulumi.Input['SecurityProjectEndpointsArgs']] = None,
                 metadata: Optional[pulumi.Input['SecurityProjectMetadataArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_types: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProjectProductTypeArgs']]]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecurityProject resources.
        :param pulumi.Input[str] admin_features_package: admin features package (BYOK, BYOIDP, CCS, CCR)
        :param pulumi.Input[str] alias: A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        :param pulumi.Input[str] cloud_id: The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana.
        :param pulumi.Input['SecurityProjectCredentialsArgs'] credentials: Basic auth credentials to access the Elasticsearch API.
        :param pulumi.Input['SecurityProjectEndpointsArgs'] endpoints: The endpoints to access the different apps of the project.
        :param pulumi.Input['SecurityProjectMetadataArgs'] metadata: Additional details about the project.
        :param pulumi.Input[str] name: Descriptive name for a project.
        :param pulumi.Input[str] region_id: Unique human-readable identifier for a region in Elastic Cloud.
        :param pulumi.Input[str] type: the type of the project
        """
        if admin_features_package is not None:
            pulumi.set(__self__, "admin_features_package", admin_features_package)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if product_types is not None:
            pulumi.set(__self__, "product_types", product_types)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="adminFeaturesPackage")
    def admin_features_package(self) -> Optional[pulumi.Input[str]]:
        """
        admin features package (BYOK, BYOIDP, CCS, CCR)
        """
        return pulumi.get(self, "admin_features_package")

    @admin_features_package.setter
    def admin_features_package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_features_package", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana.
        """
        return pulumi.get(self, "cloud_id")

    @cloud_id.setter
    def cloud_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_id", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['SecurityProjectCredentialsArgs']]:
        """
        Basic auth credentials to access the Elasticsearch API.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['SecurityProjectCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input['SecurityProjectEndpointsArgs']]:
        """
        The endpoints to access the different apps of the project.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input['SecurityProjectEndpointsArgs']]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['SecurityProjectMetadataArgs']]:
        """
        Additional details about the project.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['SecurityProjectMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Descriptive name for a project.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="productTypes")
    def product_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProjectProductTypeArgs']]]]:
        return pulumi.get(self, "product_types")

    @product_types.setter
    def product_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecurityProjectProductTypeArgs']]]]):
        pulumi.set(self, "product_types", value)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique human-readable identifier for a region in Elastic Cloud.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        the type of the project
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class SecurityProject(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_features_package: Optional[pulumi.Input[str]] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityProjectProductTypeArgs', 'SecurityProjectProductTypeArgsDict']]]]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Technical preview

        This functionality is in technical preview and may be changed or removed in a future release.
        Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ec as ec

        my_project = ec.SecurityProject("my_project",
            name="my_project",
            region_id="aws-us-east-1")
        ```

        ## Import

        Projects can be imported using the `id`, for example:

        ```sh
        $ pulumi import ec:index/securityProject:SecurityProject id 320b7b540dfc967a7a649c18e2fce4ed
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_features_package: admin features package (BYOK, BYOIDP, CCS, CCR)
        :param pulumi.Input[str] alias: A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        :param pulumi.Input[str] name: Descriptive name for a project.
        :param pulumi.Input[str] region_id: Unique human-readable identifier for a region in Elastic Cloud.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecurityProjectArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Technical preview

        This functionality is in technical preview and may be changed or removed in a future release.
        Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ec as ec

        my_project = ec.SecurityProject("my_project",
            name="my_project",
            region_id="aws-us-east-1")
        ```

        ## Import

        Projects can be imported using the `id`, for example:

        ```sh
        $ pulumi import ec:index/securityProject:SecurityProject id 320b7b540dfc967a7a649c18e2fce4ed
        ```

        :param str resource_name: The name of the resource.
        :param SecurityProjectArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecurityProjectArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_features_package: Optional[pulumi.Input[str]] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 product_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityProjectProductTypeArgs', 'SecurityProjectProductTypeArgsDict']]]]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecurityProjectArgs.__new__(SecurityProjectArgs)

            __props__.__dict__["admin_features_package"] = admin_features_package
            __props__.__dict__["alias"] = alias
            __props__.__dict__["name"] = name
            __props__.__dict__["product_types"] = product_types
            if region_id is None and not opts.urn:
                raise TypeError("Missing required property 'region_id'")
            __props__.__dict__["region_id"] = region_id
            __props__.__dict__["cloud_id"] = None
            __props__.__dict__["credentials"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["metadata"] = None
            __props__.__dict__["type"] = None
        super(SecurityProject, __self__).__init__(
            'ec:index/securityProject:SecurityProject',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_features_package: Optional[pulumi.Input[str]] = None,
            alias: Optional[pulumi.Input[str]] = None,
            cloud_id: Optional[pulumi.Input[str]] = None,
            credentials: Optional[pulumi.Input[Union['SecurityProjectCredentialsArgs', 'SecurityProjectCredentialsArgsDict']]] = None,
            endpoints: Optional[pulumi.Input[Union['SecurityProjectEndpointsArgs', 'SecurityProjectEndpointsArgsDict']]] = None,
            metadata: Optional[pulumi.Input[Union['SecurityProjectMetadataArgs', 'SecurityProjectMetadataArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            product_types: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SecurityProjectProductTypeArgs', 'SecurityProjectProductTypeArgsDict']]]]] = None,
            region_id: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'SecurityProject':
        """
        Get an existing SecurityProject resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_features_package: admin features package (BYOK, BYOIDP, CCS, CCR)
        :param pulumi.Input[str] alias: A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        :param pulumi.Input[str] cloud_id: The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana.
        :param pulumi.Input[Union['SecurityProjectCredentialsArgs', 'SecurityProjectCredentialsArgsDict']] credentials: Basic auth credentials to access the Elasticsearch API.
        :param pulumi.Input[Union['SecurityProjectEndpointsArgs', 'SecurityProjectEndpointsArgsDict']] endpoints: The endpoints to access the different apps of the project.
        :param pulumi.Input[Union['SecurityProjectMetadataArgs', 'SecurityProjectMetadataArgsDict']] metadata: Additional details about the project.
        :param pulumi.Input[str] name: Descriptive name for a project.
        :param pulumi.Input[str] region_id: Unique human-readable identifier for a region in Elastic Cloud.
        :param pulumi.Input[str] type: the type of the project
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecurityProjectState.__new__(_SecurityProjectState)

        __props__.__dict__["admin_features_package"] = admin_features_package
        __props__.__dict__["alias"] = alias
        __props__.__dict__["cloud_id"] = cloud_id
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["product_types"] = product_types
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["type"] = type
        return SecurityProject(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminFeaturesPackage")
    def admin_features_package(self) -> pulumi.Output[str]:
        """
        admin features package (BYOK, BYOIDP, CCS, CCR)
        """
        return pulumi.get(self, "admin_features_package")

    @property
    @pulumi.getter
    def alias(self) -> pulumi.Output[str]:
        """
        A custom domain label compatible with RFC-1035 standards. Derived from the project name by default.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> pulumi.Output[str]:
        """
        The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana.
        """
        return pulumi.get(self, "cloud_id")

    @property
    @pulumi.getter
    def credentials(self) -> pulumi.Output['outputs.SecurityProjectCredentials']:
        """
        Basic auth credentials to access the Elasticsearch API.
        """
        return pulumi.get(self, "credentials")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output['outputs.SecurityProjectEndpoints']:
        """
        The endpoints to access the different apps of the project.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def metadata(self) -> pulumi.Output['outputs.SecurityProjectMetadata']:
        """
        Additional details about the project.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Descriptive name for a project.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="productTypes")
    def product_types(self) -> pulumi.Output[Sequence['outputs.SecurityProjectProductType']]:
        return pulumi.get(self, "product_types")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[str]:
        """
        Unique human-readable identifier for a region in Elastic Cloud.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        the type of the project
        """
        return pulumi.get(self, "type")

