/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface Aadb2CDirectoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Country code of the B2C tenant. See https://aka.ms/B2CDataResidency for valid country codes.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#country_code Aadb2CDirectory#country_code}
    */
    readonly countryCode?: string;
    /**
    * Location in which the B2C tenant is hosted and data resides. See https://aka.ms/B2CDataResidency for more information.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#data_residency_location Aadb2CDirectory#data_residency_location}
    */
    readonly dataResidencyLocation: string;
    /**
    * The initial display name of the B2C tenant.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#display_name Aadb2CDirectory#display_name}
    */
    readonly displayName?: string;
    /**
    * Domain name of the B2C tenant, including onmicrosoft.com suffix.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#domain_name Aadb2CDirectory#domain_name}
    */
    readonly domainName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#id Aadb2CDirectory#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#resource_group_name Aadb2CDirectory#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Billing SKU for the B2C tenant. See https://aka.ms/b2cBilling for more information.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#sku_name Aadb2CDirectory#sku_name}
    */
    readonly skuName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#tags Aadb2CDirectory#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#timeouts Aadb2CDirectory#timeouts}
    */
    readonly timeouts?: Aadb2CDirectoryTimeouts;
}
export interface Aadb2CDirectoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#create Aadb2CDirectory#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#delete Aadb2CDirectory#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#read Aadb2CDirectory#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#update Aadb2CDirectory#update}
    */
    readonly update?: string;
}
export declare function aadb2CDirectoryTimeoutsToTerraform(struct?: Aadb2CDirectoryTimeouts | cdktf.IResolvable): any;
export declare function aadb2CDirectoryTimeoutsToHclTerraform(struct?: Aadb2CDirectoryTimeouts | cdktf.IResolvable): any;
export declare class Aadb2CDirectoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): Aadb2CDirectoryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: Aadb2CDirectoryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory azurerm_aadb2c_directory}
*/
export declare class Aadb2CDirectory extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_aadb2c_directory";
    /**
    * Generates CDKTF code for importing a Aadb2CDirectory resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Aadb2CDirectory to import
    * @param importFromId The id of the existing Aadb2CDirectory that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Aadb2CDirectory to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/aadb2c_directory azurerm_aadb2c_directory} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options Aadb2CDirectoryConfig
    */
    constructor(scope: Construct, id: string, config: Aadb2CDirectoryConfig);
    get billingType(): string;
    private _countryCode?;
    get countryCode(): string;
    set countryCode(value: string);
    resetCountryCode(): void;
    get countryCodeInput(): string | undefined;
    private _dataResidencyLocation?;
    get dataResidencyLocation(): string;
    set dataResidencyLocation(value: string);
    get dataResidencyLocationInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _domainName?;
    get domainName(): string;
    set domainName(value: string);
    get domainNameInput(): string | undefined;
    get effectiveStartDate(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    get skuName(): string;
    set skuName(value: string);
    get skuNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get tenantId(): string;
    private _timeouts;
    get timeouts(): Aadb2CDirectoryTimeoutsOutputReference;
    putTimeouts(value: Aadb2CDirectoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): Aadb2CDirectoryTimeouts | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
