/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AnalysisServicesServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#admin_users AnalysisServicesServer#admin_users}
    */
    readonly adminUsers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#backup_blob_container_uri AnalysisServicesServer#backup_blob_container_uri}
    */
    readonly backupBlobContainerUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#enable_power_bi_service AnalysisServicesServer#enable_power_bi_service}
    */
    readonly enablePowerBiService?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#id AnalysisServicesServer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#location AnalysisServicesServer#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#name AnalysisServicesServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#querypool_connection_mode AnalysisServicesServer#querypool_connection_mode}
    */
    readonly querypoolConnectionMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#resource_group_name AnalysisServicesServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#sku AnalysisServicesServer#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#tags AnalysisServicesServer#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * ipv4_firewall_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#ipv4_firewall_rule AnalysisServicesServer#ipv4_firewall_rule}
    */
    readonly ipv4FirewallRule?: AnalysisServicesServerIpv4FirewallRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#timeouts AnalysisServicesServer#timeouts}
    */
    readonly timeouts?: AnalysisServicesServerTimeouts;
}
export interface AnalysisServicesServerIpv4FirewallRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#name AnalysisServicesServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#range_end AnalysisServicesServer#range_end}
    */
    readonly rangeEnd: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#range_start AnalysisServicesServer#range_start}
    */
    readonly rangeStart: string;
}
export declare function analysisServicesServerIpv4FirewallRuleToTerraform(struct?: AnalysisServicesServerIpv4FirewallRule | cdktf.IResolvable): any;
export declare function analysisServicesServerIpv4FirewallRuleToHclTerraform(struct?: AnalysisServicesServerIpv4FirewallRule | cdktf.IResolvable): any;
export declare class AnalysisServicesServerIpv4FirewallRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AnalysisServicesServerIpv4FirewallRule | cdktf.IResolvable | undefined;
    set internalValue(value: AnalysisServicesServerIpv4FirewallRule | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _rangeEnd?;
    get rangeEnd(): string;
    set rangeEnd(value: string);
    get rangeEndInput(): string | undefined;
    private _rangeStart?;
    get rangeStart(): string;
    set rangeStart(value: string);
    get rangeStartInput(): string | undefined;
}
export declare class AnalysisServicesServerIpv4FirewallRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AnalysisServicesServerIpv4FirewallRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AnalysisServicesServerIpv4FirewallRuleOutputReference;
}
export interface AnalysisServicesServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#create AnalysisServicesServer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#delete AnalysisServicesServer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#read AnalysisServicesServer#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#update AnalysisServicesServer#update}
    */
    readonly update?: string;
}
export declare function analysisServicesServerTimeoutsToTerraform(struct?: AnalysisServicesServerTimeouts | cdktf.IResolvable): any;
export declare function analysisServicesServerTimeoutsToHclTerraform(struct?: AnalysisServicesServerTimeouts | cdktf.IResolvable): any;
export declare class AnalysisServicesServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AnalysisServicesServerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AnalysisServicesServerTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server azurerm_analysis_services_server}
*/
export declare class AnalysisServicesServer extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_analysis_services_server";
    /**
    * Generates CDKTF code for importing a AnalysisServicesServer resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AnalysisServicesServer to import
    * @param importFromId The id of the existing AnalysisServicesServer that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AnalysisServicesServer to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/analysis_services_server azurerm_analysis_services_server} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AnalysisServicesServerConfig
    */
    constructor(scope: Construct, id: string, config: AnalysisServicesServerConfig);
    private _adminUsers?;
    get adminUsers(): string[];
    set adminUsers(value: string[]);
    resetAdminUsers(): void;
    get adminUsersInput(): string[] | undefined;
    private _backupBlobContainerUri?;
    get backupBlobContainerUri(): string;
    set backupBlobContainerUri(value: string);
    resetBackupBlobContainerUri(): void;
    get backupBlobContainerUriInput(): string | undefined;
    private _enablePowerBiService?;
    get enablePowerBiService(): boolean | cdktf.IResolvable;
    set enablePowerBiService(value: boolean | cdktf.IResolvable);
    resetEnablePowerBiService(): void;
    get enablePowerBiServiceInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _querypoolConnectionMode?;
    get querypoolConnectionMode(): string;
    set querypoolConnectionMode(value: string);
    resetQuerypoolConnectionMode(): void;
    get querypoolConnectionModeInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get serverFullName(): string;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _ipv4FirewallRule;
    get ipv4FirewallRule(): AnalysisServicesServerIpv4FirewallRuleList;
    putIpv4FirewallRule(value: AnalysisServicesServerIpv4FirewallRule[] | cdktf.IResolvable): void;
    resetIpv4FirewallRule(): void;
    get ipv4FirewallRuleInput(): cdktf.IResolvable | AnalysisServicesServerIpv4FirewallRule[] | undefined;
    private _timeouts;
    get timeouts(): AnalysisServicesServerTimeoutsOutputReference;
    putTimeouts(value: AnalysisServicesServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AnalysisServicesServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
