/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementEmailTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template#api_management_name ApiManagementEmailTemplate#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template#body ApiManagementEmailTemplate#body}
    */
    readonly body: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template#id ApiManagementEmailTemplate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template#resource_group_name ApiManagementEmailTemplate#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template#subject ApiManagementEmailTemplate#subject}
    */
    readonly subject: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template#template_name ApiManagementEmailTemplate#template_name}
    */
    readonly templateName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template#timeouts ApiManagementEmailTemplate#timeouts}
    */
    readonly timeouts?: ApiManagementEmailTemplateTimeouts;
}
export interface ApiManagementEmailTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template#create ApiManagementEmailTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template#delete ApiManagementEmailTemplate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template#read ApiManagementEmailTemplate#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template#update ApiManagementEmailTemplate#update}
    */
    readonly update?: string;
}
export declare function apiManagementEmailTemplateTimeoutsToTerraform(struct?: ApiManagementEmailTemplateTimeouts | cdktf.IResolvable): any;
export declare function apiManagementEmailTemplateTimeoutsToHclTerraform(struct?: ApiManagementEmailTemplateTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementEmailTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementEmailTemplateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementEmailTemplateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template azurerm_api_management_email_template}
*/
export declare class ApiManagementEmailTemplate extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_email_template";
    /**
    * Generates CDKTF code for importing a ApiManagementEmailTemplate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiManagementEmailTemplate to import
    * @param importFromId The id of the existing ApiManagementEmailTemplate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiManagementEmailTemplate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_email_template azurerm_api_management_email_template} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementEmailTemplateConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementEmailTemplateConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _body?;
    get body(): string;
    set body(value: string);
    get bodyInput(): string | undefined;
    get description(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _subject?;
    get subject(): string;
    set subject(value: string);
    get subjectInput(): string | undefined;
    private _templateName?;
    get templateName(): string;
    set templateName(value: string);
    get templateNameInput(): string | undefined;
    get title(): string;
    private _timeouts;
    get timeouts(): ApiManagementEmailTemplateTimeoutsOutputReference;
    putTimeouts(value: ApiManagementEmailTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementEmailTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
