/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementIdentityProviderFacebookConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_identity_provider_facebook#api_management_name ApiManagementIdentityProviderFacebook#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_identity_provider_facebook#app_id ApiManagementIdentityProviderFacebook#app_id}
    */
    readonly appId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_identity_provider_facebook#app_secret ApiManagementIdentityProviderFacebook#app_secret}
    */
    readonly appSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_identity_provider_facebook#id ApiManagementIdentityProviderFacebook#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_identity_provider_facebook#resource_group_name ApiManagementIdentityProviderFacebook#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_identity_provider_facebook#timeouts ApiManagementIdentityProviderFacebook#timeouts}
    */
    readonly timeouts?: ApiManagementIdentityProviderFacebookTimeouts;
}
export interface ApiManagementIdentityProviderFacebookTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_identity_provider_facebook#create ApiManagementIdentityProviderFacebook#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_identity_provider_facebook#delete ApiManagementIdentityProviderFacebook#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_identity_provider_facebook#read ApiManagementIdentityProviderFacebook#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_identity_provider_facebook#update ApiManagementIdentityProviderFacebook#update}
    */
    readonly update?: string;
}
export declare function apiManagementIdentityProviderFacebookTimeoutsToTerraform(struct?: ApiManagementIdentityProviderFacebookTimeouts | cdktf.IResolvable): any;
export declare function apiManagementIdentityProviderFacebookTimeoutsToHclTerraform(struct?: ApiManagementIdentityProviderFacebookTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementIdentityProviderFacebookTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApiManagementIdentityProviderFacebookTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApiManagementIdentityProviderFacebookTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_identity_provider_facebook azurerm_api_management_identity_provider_facebook}
*/
export declare class ApiManagementIdentityProviderFacebook extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_api_management_identity_provider_facebook";
    /**
    * Generates CDKTF code for importing a ApiManagementIdentityProviderFacebook resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiManagementIdentityProviderFacebook to import
    * @param importFromId The id of the existing ApiManagementIdentityProviderFacebook that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_identity_provider_facebook#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiManagementIdentityProviderFacebook to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/api_management_identity_provider_facebook azurerm_api_management_identity_provider_facebook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementIdentityProviderFacebookConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementIdentityProviderFacebookConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _appId?;
    get appId(): string;
    set appId(value: string);
    get appIdInput(): string | undefined;
    private _appSecret?;
    get appSecret(): string;
    set appSecret(value: string);
    get appSecretInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementIdentityProviderFacebookTimeoutsOutputReference;
    putTimeouts(value: ApiManagementIdentityProviderFacebookTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApiManagementIdentityProviderFacebookTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
