/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationInsightsStandardWebTestConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#application_insights_id ApplicationInsightsStandardWebTest#application_insights_id}
    */
    readonly applicationInsightsId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#description ApplicationInsightsStandardWebTest#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#enabled ApplicationInsightsStandardWebTest#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#frequency ApplicationInsightsStandardWebTest#frequency}
    */
    readonly frequency?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#geo_locations ApplicationInsightsStandardWebTest#geo_locations}
    */
    readonly geoLocations: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#id ApplicationInsightsStandardWebTest#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#location ApplicationInsightsStandardWebTest#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#name ApplicationInsightsStandardWebTest#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#resource_group_name ApplicationInsightsStandardWebTest#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#retry_enabled ApplicationInsightsStandardWebTest#retry_enabled}
    */
    readonly retryEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#tags ApplicationInsightsStandardWebTest#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#timeout ApplicationInsightsStandardWebTest#timeout}
    */
    readonly timeout?: number;
    /**
    * request block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#request ApplicationInsightsStandardWebTest#request}
    */
    readonly request: ApplicationInsightsStandardWebTestRequest;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#timeouts ApplicationInsightsStandardWebTest#timeouts}
    */
    readonly timeouts?: ApplicationInsightsStandardWebTestTimeouts;
    /**
    * validation_rules block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#validation_rules ApplicationInsightsStandardWebTest#validation_rules}
    */
    readonly validationRules?: ApplicationInsightsStandardWebTestValidationRules;
}
export interface ApplicationInsightsStandardWebTestRequestHeader {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#name ApplicationInsightsStandardWebTest#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#value ApplicationInsightsStandardWebTest#value}
    */
    readonly value: string;
}
export declare function applicationInsightsStandardWebTestRequestHeaderToTerraform(struct?: ApplicationInsightsStandardWebTestRequestHeader | cdktf.IResolvable): any;
export declare function applicationInsightsStandardWebTestRequestHeaderToHclTerraform(struct?: ApplicationInsightsStandardWebTestRequestHeader | cdktf.IResolvable): any;
export declare class ApplicationInsightsStandardWebTestRequestHeaderOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApplicationInsightsStandardWebTestRequestHeader | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationInsightsStandardWebTestRequestHeader | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ApplicationInsightsStandardWebTestRequestHeaderList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ApplicationInsightsStandardWebTestRequestHeader[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApplicationInsightsStandardWebTestRequestHeaderOutputReference;
}
export interface ApplicationInsightsStandardWebTestRequest {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#body ApplicationInsightsStandardWebTest#body}
    */
    readonly body?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#follow_redirects_enabled ApplicationInsightsStandardWebTest#follow_redirects_enabled}
    */
    readonly followRedirectsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#http_verb ApplicationInsightsStandardWebTest#http_verb}
    */
    readonly httpVerb?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#parse_dependent_requests_enabled ApplicationInsightsStandardWebTest#parse_dependent_requests_enabled}
    */
    readonly parseDependentRequestsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#url ApplicationInsightsStandardWebTest#url}
    */
    readonly url: string;
    /**
    * header block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#header ApplicationInsightsStandardWebTest#header}
    */
    readonly header?: ApplicationInsightsStandardWebTestRequestHeader[] | cdktf.IResolvable;
}
export declare function applicationInsightsStandardWebTestRequestToTerraform(struct?: ApplicationInsightsStandardWebTestRequestOutputReference | ApplicationInsightsStandardWebTestRequest): any;
export declare function applicationInsightsStandardWebTestRequestToHclTerraform(struct?: ApplicationInsightsStandardWebTestRequestOutputReference | ApplicationInsightsStandardWebTestRequest): any;
export declare class ApplicationInsightsStandardWebTestRequestOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationInsightsStandardWebTestRequest | undefined;
    set internalValue(value: ApplicationInsightsStandardWebTestRequest | undefined);
    private _body?;
    get body(): string;
    set body(value: string);
    resetBody(): void;
    get bodyInput(): string | undefined;
    private _followRedirectsEnabled?;
    get followRedirectsEnabled(): boolean | cdktf.IResolvable;
    set followRedirectsEnabled(value: boolean | cdktf.IResolvable);
    resetFollowRedirectsEnabled(): void;
    get followRedirectsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpVerb?;
    get httpVerb(): string;
    set httpVerb(value: string);
    resetHttpVerb(): void;
    get httpVerbInput(): string | undefined;
    private _parseDependentRequestsEnabled?;
    get parseDependentRequestsEnabled(): boolean | cdktf.IResolvable;
    set parseDependentRequestsEnabled(value: boolean | cdktf.IResolvable);
    resetParseDependentRequestsEnabled(): void;
    get parseDependentRequestsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    get urlInput(): string | undefined;
    private _header;
    get header(): ApplicationInsightsStandardWebTestRequestHeaderList;
    putHeader(value: ApplicationInsightsStandardWebTestRequestHeader[] | cdktf.IResolvable): void;
    resetHeader(): void;
    get headerInput(): cdktf.IResolvable | ApplicationInsightsStandardWebTestRequestHeader[] | undefined;
}
export interface ApplicationInsightsStandardWebTestTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#create ApplicationInsightsStandardWebTest#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#delete ApplicationInsightsStandardWebTest#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#read ApplicationInsightsStandardWebTest#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#update ApplicationInsightsStandardWebTest#update}
    */
    readonly update?: string;
}
export declare function applicationInsightsStandardWebTestTimeoutsToTerraform(struct?: ApplicationInsightsStandardWebTestTimeouts | cdktf.IResolvable): any;
export declare function applicationInsightsStandardWebTestTimeoutsToHclTerraform(struct?: ApplicationInsightsStandardWebTestTimeouts | cdktf.IResolvable): any;
export declare class ApplicationInsightsStandardWebTestTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationInsightsStandardWebTestTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApplicationInsightsStandardWebTestTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface ApplicationInsightsStandardWebTestValidationRulesContent {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#content_match ApplicationInsightsStandardWebTest#content_match}
    */
    readonly contentMatch: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#ignore_case ApplicationInsightsStandardWebTest#ignore_case}
    */
    readonly ignoreCase?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#pass_if_text_found ApplicationInsightsStandardWebTest#pass_if_text_found}
    */
    readonly passIfTextFound?: boolean | cdktf.IResolvable;
}
export declare function applicationInsightsStandardWebTestValidationRulesContentToTerraform(struct?: ApplicationInsightsStandardWebTestValidationRulesContentOutputReference | ApplicationInsightsStandardWebTestValidationRulesContent): any;
export declare function applicationInsightsStandardWebTestValidationRulesContentToHclTerraform(struct?: ApplicationInsightsStandardWebTestValidationRulesContentOutputReference | ApplicationInsightsStandardWebTestValidationRulesContent): any;
export declare class ApplicationInsightsStandardWebTestValidationRulesContentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationInsightsStandardWebTestValidationRulesContent | undefined;
    set internalValue(value: ApplicationInsightsStandardWebTestValidationRulesContent | undefined);
    private _contentMatch?;
    get contentMatch(): string;
    set contentMatch(value: string);
    get contentMatchInput(): string | undefined;
    private _ignoreCase?;
    get ignoreCase(): boolean | cdktf.IResolvable;
    set ignoreCase(value: boolean | cdktf.IResolvable);
    resetIgnoreCase(): void;
    get ignoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _passIfTextFound?;
    get passIfTextFound(): boolean | cdktf.IResolvable;
    set passIfTextFound(value: boolean | cdktf.IResolvable);
    resetPassIfTextFound(): void;
    get passIfTextFoundInput(): boolean | cdktf.IResolvable | undefined;
}
export interface ApplicationInsightsStandardWebTestValidationRules {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#expected_status_code ApplicationInsightsStandardWebTest#expected_status_code}
    */
    readonly expectedStatusCode?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#ssl_cert_remaining_lifetime ApplicationInsightsStandardWebTest#ssl_cert_remaining_lifetime}
    */
    readonly sslCertRemainingLifetime?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#ssl_check_enabled ApplicationInsightsStandardWebTest#ssl_check_enabled}
    */
    readonly sslCheckEnabled?: boolean | cdktf.IResolvable;
    /**
    * content block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#content ApplicationInsightsStandardWebTest#content}
    */
    readonly content?: ApplicationInsightsStandardWebTestValidationRulesContent;
}
export declare function applicationInsightsStandardWebTestValidationRulesToTerraform(struct?: ApplicationInsightsStandardWebTestValidationRulesOutputReference | ApplicationInsightsStandardWebTestValidationRules): any;
export declare function applicationInsightsStandardWebTestValidationRulesToHclTerraform(struct?: ApplicationInsightsStandardWebTestValidationRulesOutputReference | ApplicationInsightsStandardWebTestValidationRules): any;
export declare class ApplicationInsightsStandardWebTestValidationRulesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApplicationInsightsStandardWebTestValidationRules | undefined;
    set internalValue(value: ApplicationInsightsStandardWebTestValidationRules | undefined);
    private _expectedStatusCode?;
    get expectedStatusCode(): number;
    set expectedStatusCode(value: number);
    resetExpectedStatusCode(): void;
    get expectedStatusCodeInput(): number | undefined;
    private _sslCertRemainingLifetime?;
    get sslCertRemainingLifetime(): number;
    set sslCertRemainingLifetime(value: number);
    resetSslCertRemainingLifetime(): void;
    get sslCertRemainingLifetimeInput(): number | undefined;
    private _sslCheckEnabled?;
    get sslCheckEnabled(): boolean | cdktf.IResolvable;
    set sslCheckEnabled(value: boolean | cdktf.IResolvable);
    resetSslCheckEnabled(): void;
    get sslCheckEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _content;
    get content(): ApplicationInsightsStandardWebTestValidationRulesContentOutputReference;
    putContent(value: ApplicationInsightsStandardWebTestValidationRulesContent): void;
    resetContent(): void;
    get contentInput(): ApplicationInsightsStandardWebTestValidationRulesContent | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test azurerm_application_insights_standard_web_test}
*/
export declare class ApplicationInsightsStandardWebTest extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_application_insights_standard_web_test";
    /**
    * Generates CDKTF code for importing a ApplicationInsightsStandardWebTest resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApplicationInsightsStandardWebTest to import
    * @param importFromId The id of the existing ApplicationInsightsStandardWebTest that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApplicationInsightsStandardWebTest to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/application_insights_standard_web_test azurerm_application_insights_standard_web_test} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationInsightsStandardWebTestConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationInsightsStandardWebTestConfig);
    private _applicationInsightsId?;
    get applicationInsightsId(): string;
    set applicationInsightsId(value: string);
    get applicationInsightsIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _frequency?;
    get frequency(): number;
    set frequency(value: number);
    resetFrequency(): void;
    get frequencyInput(): number | undefined;
    private _geoLocations?;
    get geoLocations(): string[];
    set geoLocations(value: string[]);
    get geoLocationsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _retryEnabled?;
    get retryEnabled(): boolean | cdktf.IResolvable;
    set retryEnabled(value: boolean | cdktf.IResolvable);
    resetRetryEnabled(): void;
    get retryEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get syntheticMonitorId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeout?;
    get timeout(): number;
    set timeout(value: number);
    resetTimeout(): void;
    get timeoutInput(): number | undefined;
    private _request;
    get request(): ApplicationInsightsStandardWebTestRequestOutputReference;
    putRequest(value: ApplicationInsightsStandardWebTestRequest): void;
    get requestInput(): ApplicationInsightsStandardWebTestRequest | undefined;
    private _timeouts;
    get timeouts(): ApplicationInsightsStandardWebTestTimeoutsOutputReference;
    putTimeouts(value: ApplicationInsightsStandardWebTestTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApplicationInsightsStandardWebTestTimeouts | undefined;
    private _validationRules;
    get validationRules(): ApplicationInsightsStandardWebTestValidationRulesOutputReference;
    putValidationRules(value: ApplicationInsightsStandardWebTestValidationRules): void;
    resetValidationRules(): void;
    get validationRulesInput(): ApplicationInsightsStandardWebTestValidationRules | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
