/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomationRunbookConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#automation_account_name AutomationRunbook#automation_account_name}
    */
    readonly automationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#content AutomationRunbook#content}
    */
    readonly content?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#description AutomationRunbook#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#id AutomationRunbook#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#job_schedule AutomationRunbook#job_schedule}
    */
    readonly jobSchedule?: AutomationRunbookJobSchedule[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#location AutomationRunbook#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#log_activity_trace_level AutomationRunbook#log_activity_trace_level}
    */
    readonly logActivityTraceLevel?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#log_progress AutomationRunbook#log_progress}
    */
    readonly logProgress: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#log_verbose AutomationRunbook#log_verbose}
    */
    readonly logVerbose: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#name AutomationRunbook#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#resource_group_name AutomationRunbook#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#runbook_type AutomationRunbook#runbook_type}
    */
    readonly runbookType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#tags AutomationRunbook#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * draft block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#draft AutomationRunbook#draft}
    */
    readonly draft?: AutomationRunbookDraft;
    /**
    * publish_content_link block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#publish_content_link AutomationRunbook#publish_content_link}
    */
    readonly publishContentLink?: AutomationRunbookPublishContentLink;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#timeouts AutomationRunbook#timeouts}
    */
    readonly timeouts?: AutomationRunbookTimeouts;
}
export interface AutomationRunbookJobSchedule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#job_schedule_id AutomationRunbook#job_schedule_id}
    */
    readonly jobScheduleId?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#parameters AutomationRunbook#parameters}
    */
    readonly parameters?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#run_on AutomationRunbook#run_on}
    */
    readonly runOn?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#schedule_name AutomationRunbook#schedule_name}
    */
    readonly scheduleName?: string;
}
export declare function automationRunbookJobScheduleToTerraform(struct?: AutomationRunbookJobSchedule | cdktf.IResolvable): any;
export declare function automationRunbookJobScheduleToHclTerraform(struct?: AutomationRunbookJobSchedule | cdktf.IResolvable): any;
export declare class AutomationRunbookJobScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AutomationRunbookJobSchedule | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationRunbookJobSchedule | cdktf.IResolvable | undefined);
    private _jobScheduleId?;
    get jobScheduleId(): string;
    set jobScheduleId(value: string);
    resetJobScheduleId(): void;
    get jobScheduleIdInput(): string | undefined;
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    };
    set parameters(value: {
        [key: string]: string;
    });
    resetParameters(): void;
    get parametersInput(): {
        [key: string]: string;
    } | undefined;
    private _runOn?;
    get runOn(): string;
    set runOn(value: string);
    resetRunOn(): void;
    get runOnInput(): string | undefined;
    private _scheduleName?;
    get scheduleName(): string;
    set scheduleName(value: string);
    resetScheduleName(): void;
    get scheduleNameInput(): string | undefined;
}
export declare class AutomationRunbookJobScheduleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AutomationRunbookJobSchedule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AutomationRunbookJobScheduleOutputReference;
}
export interface AutomationRunbookDraftContentLinkHash {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#algorithm AutomationRunbook#algorithm}
    */
    readonly algorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#value AutomationRunbook#value}
    */
    readonly value: string;
}
export declare function automationRunbookDraftContentLinkHashToTerraform(struct?: AutomationRunbookDraftContentLinkHashOutputReference | AutomationRunbookDraftContentLinkHash): any;
export declare function automationRunbookDraftContentLinkHashToHclTerraform(struct?: AutomationRunbookDraftContentLinkHashOutputReference | AutomationRunbookDraftContentLinkHash): any;
export declare class AutomationRunbookDraftContentLinkHashOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationRunbookDraftContentLinkHash | undefined;
    set internalValue(value: AutomationRunbookDraftContentLinkHash | undefined);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    get algorithmInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface AutomationRunbookDraftContentLink {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#uri AutomationRunbook#uri}
    */
    readonly uri: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#version AutomationRunbook#version}
    */
    readonly version?: string;
    /**
    * hash block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#hash AutomationRunbook#hash}
    */
    readonly hash?: AutomationRunbookDraftContentLinkHash;
}
export declare function automationRunbookDraftContentLinkToTerraform(struct?: AutomationRunbookDraftContentLinkOutputReference | AutomationRunbookDraftContentLink): any;
export declare function automationRunbookDraftContentLinkToHclTerraform(struct?: AutomationRunbookDraftContentLinkOutputReference | AutomationRunbookDraftContentLink): any;
export declare class AutomationRunbookDraftContentLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationRunbookDraftContentLink | undefined;
    set internalValue(value: AutomationRunbookDraftContentLink | undefined);
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _hash;
    get hash(): AutomationRunbookDraftContentLinkHashOutputReference;
    putHash(value: AutomationRunbookDraftContentLinkHash): void;
    resetHash(): void;
    get hashInput(): AutomationRunbookDraftContentLinkHash | undefined;
}
export interface AutomationRunbookDraftParameters {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#default_value AutomationRunbook#default_value}
    */
    readonly defaultValue?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#key AutomationRunbook#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#mandatory AutomationRunbook#mandatory}
    */
    readonly mandatory?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#position AutomationRunbook#position}
    */
    readonly position?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#type AutomationRunbook#type}
    */
    readonly type: string;
}
export declare function automationRunbookDraftParametersToTerraform(struct?: AutomationRunbookDraftParameters | cdktf.IResolvable): any;
export declare function automationRunbookDraftParametersToHclTerraform(struct?: AutomationRunbookDraftParameters | cdktf.IResolvable): any;
export declare class AutomationRunbookDraftParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): AutomationRunbookDraftParameters | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationRunbookDraftParameters | cdktf.IResolvable | undefined);
    private _defaultValue?;
    get defaultValue(): string;
    set defaultValue(value: string);
    resetDefaultValue(): void;
    get defaultValueInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _mandatory?;
    get mandatory(): boolean | cdktf.IResolvable;
    set mandatory(value: boolean | cdktf.IResolvable);
    resetMandatory(): void;
    get mandatoryInput(): boolean | cdktf.IResolvable | undefined;
    private _position?;
    get position(): number;
    set position(value: number);
    resetPosition(): void;
    get positionInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class AutomationRunbookDraftParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: AutomationRunbookDraftParameters[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): AutomationRunbookDraftParametersOutputReference;
}
export interface AutomationRunbookDraft {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#edit_mode_enabled AutomationRunbook#edit_mode_enabled}
    */
    readonly editModeEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#output_types AutomationRunbook#output_types}
    */
    readonly outputTypes?: string[];
    /**
    * content_link block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#content_link AutomationRunbook#content_link}
    */
    readonly contentLink?: AutomationRunbookDraftContentLink;
    /**
    * parameters block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#parameters AutomationRunbook#parameters}
    */
    readonly parameters?: AutomationRunbookDraftParameters[] | cdktf.IResolvable;
}
export declare function automationRunbookDraftToTerraform(struct?: AutomationRunbookDraftOutputReference | AutomationRunbookDraft): any;
export declare function automationRunbookDraftToHclTerraform(struct?: AutomationRunbookDraftOutputReference | AutomationRunbookDraft): any;
export declare class AutomationRunbookDraftOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationRunbookDraft | undefined;
    set internalValue(value: AutomationRunbookDraft | undefined);
    get creationTime(): string;
    private _editModeEnabled?;
    get editModeEnabled(): boolean | cdktf.IResolvable;
    set editModeEnabled(value: boolean | cdktf.IResolvable);
    resetEditModeEnabled(): void;
    get editModeEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get lastModifiedTime(): string;
    private _outputTypes?;
    get outputTypes(): string[];
    set outputTypes(value: string[]);
    resetOutputTypes(): void;
    get outputTypesInput(): string[] | undefined;
    private _contentLink;
    get contentLink(): AutomationRunbookDraftContentLinkOutputReference;
    putContentLink(value: AutomationRunbookDraftContentLink): void;
    resetContentLink(): void;
    get contentLinkInput(): AutomationRunbookDraftContentLink | undefined;
    private _parameters;
    get parameters(): AutomationRunbookDraftParametersList;
    putParameters(value: AutomationRunbookDraftParameters[] | cdktf.IResolvable): void;
    resetParameters(): void;
    get parametersInput(): cdktf.IResolvable | AutomationRunbookDraftParameters[] | undefined;
}
export interface AutomationRunbookPublishContentLinkHash {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#algorithm AutomationRunbook#algorithm}
    */
    readonly algorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#value AutomationRunbook#value}
    */
    readonly value: string;
}
export declare function automationRunbookPublishContentLinkHashToTerraform(struct?: AutomationRunbookPublishContentLinkHashOutputReference | AutomationRunbookPublishContentLinkHash): any;
export declare function automationRunbookPublishContentLinkHashToHclTerraform(struct?: AutomationRunbookPublishContentLinkHashOutputReference | AutomationRunbookPublishContentLinkHash): any;
export declare class AutomationRunbookPublishContentLinkHashOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationRunbookPublishContentLinkHash | undefined;
    set internalValue(value: AutomationRunbookPublishContentLinkHash | undefined);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    get algorithmInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export interface AutomationRunbookPublishContentLink {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#uri AutomationRunbook#uri}
    */
    readonly uri: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#version AutomationRunbook#version}
    */
    readonly version?: string;
    /**
    * hash block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#hash AutomationRunbook#hash}
    */
    readonly hash?: AutomationRunbookPublishContentLinkHash;
}
export declare function automationRunbookPublishContentLinkToTerraform(struct?: AutomationRunbookPublishContentLinkOutputReference | AutomationRunbookPublishContentLink): any;
export declare function automationRunbookPublishContentLinkToHclTerraform(struct?: AutomationRunbookPublishContentLinkOutputReference | AutomationRunbookPublishContentLink): any;
export declare class AutomationRunbookPublishContentLinkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationRunbookPublishContentLink | undefined;
    set internalValue(value: AutomationRunbookPublishContentLink | undefined);
    private _uri?;
    get uri(): string;
    set uri(value: string);
    get uriInput(): string | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _hash;
    get hash(): AutomationRunbookPublishContentLinkHashOutputReference;
    putHash(value: AutomationRunbookPublishContentLinkHash): void;
    resetHash(): void;
    get hashInput(): AutomationRunbookPublishContentLinkHash | undefined;
}
export interface AutomationRunbookTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#create AutomationRunbook#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#delete AutomationRunbook#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#read AutomationRunbook#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#update AutomationRunbook#update}
    */
    readonly update?: string;
}
export declare function automationRunbookTimeoutsToTerraform(struct?: AutomationRunbookTimeouts | cdktf.IResolvable): any;
export declare function automationRunbookTimeoutsToHclTerraform(struct?: AutomationRunbookTimeouts | cdktf.IResolvable): any;
export declare class AutomationRunbookTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): AutomationRunbookTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: AutomationRunbookTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook azurerm_automation_runbook}
*/
export declare class AutomationRunbook extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_automation_runbook";
    /**
    * Generates CDKTF code for importing a AutomationRunbook resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AutomationRunbook to import
    * @param importFromId The id of the existing AutomationRunbook that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AutomationRunbook to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/automation_runbook azurerm_automation_runbook} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomationRunbookConfig
    */
    constructor(scope: Construct, id: string, config: AutomationRunbookConfig);
    private _automationAccountName?;
    get automationAccountName(): string;
    set automationAccountName(value: string);
    get automationAccountNameInput(): string | undefined;
    private _content?;
    get content(): string;
    set content(value: string);
    resetContent(): void;
    get contentInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jobSchedule;
    get jobSchedule(): AutomationRunbookJobScheduleList;
    putJobSchedule(value: AutomationRunbookJobSchedule[] | cdktf.IResolvable): void;
    resetJobSchedule(): void;
    get jobScheduleInput(): cdktf.IResolvable | AutomationRunbookJobSchedule[] | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _logActivityTraceLevel?;
    get logActivityTraceLevel(): number;
    set logActivityTraceLevel(value: number);
    resetLogActivityTraceLevel(): void;
    get logActivityTraceLevelInput(): number | undefined;
    private _logProgress?;
    get logProgress(): boolean | cdktf.IResolvable;
    set logProgress(value: boolean | cdktf.IResolvable);
    get logProgressInput(): boolean | cdktf.IResolvable | undefined;
    private _logVerbose?;
    get logVerbose(): boolean | cdktf.IResolvable;
    set logVerbose(value: boolean | cdktf.IResolvable);
    get logVerboseInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _runbookType?;
    get runbookType(): string;
    set runbookType(value: string);
    get runbookTypeInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _draft;
    get draft(): AutomationRunbookDraftOutputReference;
    putDraft(value: AutomationRunbookDraft): void;
    resetDraft(): void;
    get draftInput(): AutomationRunbookDraft | undefined;
    private _publishContentLink;
    get publishContentLink(): AutomationRunbookPublishContentLinkOutputReference;
    putPublishContentLink(value: AutomationRunbookPublishContentLink): void;
    resetPublishContentLink(): void;
    get publishContentLinkInput(): AutomationRunbookPublishContentLink | undefined;
    private _timeouts;
    get timeouts(): AutomationRunbookTimeoutsOutputReference;
    putTimeouts(value: AutomationRunbookTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | AutomationRunbookTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
