/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CosmosdbCassandraClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#authentication_method CosmosdbCassandraCluster#authentication_method}
    */
    readonly authenticationMethod?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#client_certificate_pems CosmosdbCassandraCluster#client_certificate_pems}
    */
    readonly clientCertificatePems?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#default_admin_password CosmosdbCassandraCluster#default_admin_password}
    */
    readonly defaultAdminPassword: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#delegated_management_subnet_id CosmosdbCassandraCluster#delegated_management_subnet_id}
    */
    readonly delegatedManagementSubnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#external_gossip_certificate_pems CosmosdbCassandraCluster#external_gossip_certificate_pems}
    */
    readonly externalGossipCertificatePems?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#external_seed_node_ip_addresses CosmosdbCassandraCluster#external_seed_node_ip_addresses}
    */
    readonly externalSeedNodeIpAddresses?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#hours_between_backups CosmosdbCassandraCluster#hours_between_backups}
    */
    readonly hoursBetweenBackups?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#id CosmosdbCassandraCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#location CosmosdbCassandraCluster#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#name CosmosdbCassandraCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#repair_enabled CosmosdbCassandraCluster#repair_enabled}
    */
    readonly repairEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#resource_group_name CosmosdbCassandraCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#tags CosmosdbCassandraCluster#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#version CosmosdbCassandraCluster#version}
    */
    readonly version?: string;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#identity CosmosdbCassandraCluster#identity}
    */
    readonly identity?: CosmosdbCassandraClusterIdentity;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#timeouts CosmosdbCassandraCluster#timeouts}
    */
    readonly timeouts?: CosmosdbCassandraClusterTimeouts;
}
export interface CosmosdbCassandraClusterIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#type CosmosdbCassandraCluster#type}
    */
    readonly type: string;
}
export declare function cosmosdbCassandraClusterIdentityToTerraform(struct?: CosmosdbCassandraClusterIdentityOutputReference | CosmosdbCassandraClusterIdentity): any;
export declare function cosmosdbCassandraClusterIdentityToHclTerraform(struct?: CosmosdbCassandraClusterIdentityOutputReference | CosmosdbCassandraClusterIdentity): any;
export declare class CosmosdbCassandraClusterIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbCassandraClusterIdentity | undefined;
    set internalValue(value: CosmosdbCassandraClusterIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface CosmosdbCassandraClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#create CosmosdbCassandraCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#delete CosmosdbCassandraCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#read CosmosdbCassandraCluster#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#update CosmosdbCassandraCluster#update}
    */
    readonly update?: string;
}
export declare function cosmosdbCassandraClusterTimeoutsToTerraform(struct?: CosmosdbCassandraClusterTimeouts | cdktf.IResolvable): any;
export declare function cosmosdbCassandraClusterTimeoutsToHclTerraform(struct?: CosmosdbCassandraClusterTimeouts | cdktf.IResolvable): any;
export declare class CosmosdbCassandraClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CosmosdbCassandraClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CosmosdbCassandraClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster azurerm_cosmosdb_cassandra_cluster}
*/
export declare class CosmosdbCassandraCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_cosmosdb_cassandra_cluster";
    /**
    * Generates CDKTF code for importing a CosmosdbCassandraCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CosmosdbCassandraCluster to import
    * @param importFromId The id of the existing CosmosdbCassandraCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CosmosdbCassandraCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/cosmosdb_cassandra_cluster azurerm_cosmosdb_cassandra_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CosmosdbCassandraClusterConfig
    */
    constructor(scope: Construct, id: string, config: CosmosdbCassandraClusterConfig);
    private _authenticationMethod?;
    get authenticationMethod(): string;
    set authenticationMethod(value: string);
    resetAuthenticationMethod(): void;
    get authenticationMethodInput(): string | undefined;
    private _clientCertificatePems?;
    get clientCertificatePems(): string[];
    set clientCertificatePems(value: string[]);
    resetClientCertificatePems(): void;
    get clientCertificatePemsInput(): string[] | undefined;
    private _defaultAdminPassword?;
    get defaultAdminPassword(): string;
    set defaultAdminPassword(value: string);
    get defaultAdminPasswordInput(): string | undefined;
    private _delegatedManagementSubnetId?;
    get delegatedManagementSubnetId(): string;
    set delegatedManagementSubnetId(value: string);
    get delegatedManagementSubnetIdInput(): string | undefined;
    private _externalGossipCertificatePems?;
    get externalGossipCertificatePems(): string[];
    set externalGossipCertificatePems(value: string[]);
    resetExternalGossipCertificatePems(): void;
    get externalGossipCertificatePemsInput(): string[] | undefined;
    private _externalSeedNodeIpAddresses?;
    get externalSeedNodeIpAddresses(): string[];
    set externalSeedNodeIpAddresses(value: string[]);
    resetExternalSeedNodeIpAddresses(): void;
    get externalSeedNodeIpAddressesInput(): string[] | undefined;
    private _hoursBetweenBackups?;
    get hoursBetweenBackups(): number;
    set hoursBetweenBackups(value: number);
    resetHoursBetweenBackups(): void;
    get hoursBetweenBackupsInput(): number | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _repairEnabled?;
    get repairEnabled(): boolean | cdktf.IResolvable;
    set repairEnabled(value: boolean | cdktf.IResolvable);
    resetRepairEnabled(): void;
    get repairEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _version?;
    get version(): string;
    set version(value: string);
    resetVersion(): void;
    get versionInput(): string | undefined;
    private _identity;
    get identity(): CosmosdbCassandraClusterIdentityOutputReference;
    putIdentity(value: CosmosdbCassandraClusterIdentity): void;
    resetIdentity(): void;
    get identityInput(): CosmosdbCassandraClusterIdentity | undefined;
    private _timeouts;
    get timeouts(): CosmosdbCassandraClusterTimeoutsOutputReference;
    putTimeouts(value: CosmosdbCassandraClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CosmosdbCassandraClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
