/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApiManagementApiVersionSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management_api_version_set#api_management_name DataAzurermApiManagementApiVersionSet#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management_api_version_set#id DataAzurermApiManagementApiVersionSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management_api_version_set#name DataAzurermApiManagementApiVersionSet#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management_api_version_set#resource_group_name DataAzurermApiManagementApiVersionSet#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management_api_version_set#timeouts DataAzurermApiManagementApiVersionSet#timeouts}
    */
    readonly timeouts?: DataAzurermApiManagementApiVersionSetTimeouts;
}
export interface DataAzurermApiManagementApiVersionSetTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management_api_version_set#read DataAzurermApiManagementApiVersionSet#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApiManagementApiVersionSetTimeoutsToTerraform(struct?: DataAzurermApiManagementApiVersionSetTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermApiManagementApiVersionSetTimeoutsToHclTerraform(struct?: DataAzurermApiManagementApiVersionSetTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApiManagementApiVersionSetTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermApiManagementApiVersionSetTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermApiManagementApiVersionSetTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management_api_version_set azurerm_api_management_api_version_set}
*/
export declare class DataAzurermApiManagementApiVersionSet extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_api_management_api_version_set";
    /**
    * Generates CDKTF code for importing a DataAzurermApiManagementApiVersionSet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermApiManagementApiVersionSet to import
    * @param importFromId The id of the existing DataAzurermApiManagementApiVersionSet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management_api_version_set#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermApiManagementApiVersionSet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management_api_version_set azurerm_api_management_api_version_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApiManagementApiVersionSetConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementApiVersionSetConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    get description(): string;
    get displayName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get versionHeaderName(): string;
    get versionQueryName(): string;
    get versioningScheme(): string;
    private _timeouts;
    get timeouts(): DataAzurermApiManagementApiVersionSetTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApiManagementApiVersionSetTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermApiManagementApiVersionSetTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
