/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApiManagementConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management#id DataAzurermApiManagement#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management#name DataAzurermApiManagement#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management#resource_group_name DataAzurermApiManagement#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management#tags DataAzurermApiManagement#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management#timeouts DataAzurermApiManagement#timeouts}
    */
    readonly timeouts?: DataAzurermApiManagementTimeouts;
}
export interface DataAzurermApiManagementAdditionalLocation {
}
export declare function dataAzurermApiManagementAdditionalLocationToTerraform(struct?: DataAzurermApiManagementAdditionalLocation): any;
export declare function dataAzurermApiManagementAdditionalLocationToHclTerraform(struct?: DataAzurermApiManagementAdditionalLocation): any;
export declare class DataAzurermApiManagementAdditionalLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApiManagementAdditionalLocation | undefined;
    set internalValue(value: DataAzurermApiManagementAdditionalLocation | undefined);
    get capacity(): number;
    get gatewayRegionalUrl(): string;
    get location(): string;
    get privateIpAddresses(): string[];
    get publicIpAddressId(): string;
    get publicIpAddresses(): string[];
    get zones(): string[];
}
export declare class DataAzurermApiManagementAdditionalLocationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApiManagementAdditionalLocationOutputReference;
}
export interface DataAzurermApiManagementHostnameConfigurationDeveloperPortal {
}
export declare function dataAzurermApiManagementHostnameConfigurationDeveloperPortalToTerraform(struct?: DataAzurermApiManagementHostnameConfigurationDeveloperPortal): any;
export declare function dataAzurermApiManagementHostnameConfigurationDeveloperPortalToHclTerraform(struct?: DataAzurermApiManagementHostnameConfigurationDeveloperPortal): any;
export declare class DataAzurermApiManagementHostnameConfigurationDeveloperPortalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApiManagementHostnameConfigurationDeveloperPortal | undefined;
    set internalValue(value: DataAzurermApiManagementHostnameConfigurationDeveloperPortal | undefined);
    get hostName(): string;
    get keyVaultId(): string;
    get negotiateClientCertificate(): cdktf.IResolvable;
}
export declare class DataAzurermApiManagementHostnameConfigurationDeveloperPortalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApiManagementHostnameConfigurationDeveloperPortalOutputReference;
}
export interface DataAzurermApiManagementHostnameConfigurationManagement {
}
export declare function dataAzurermApiManagementHostnameConfigurationManagementToTerraform(struct?: DataAzurermApiManagementHostnameConfigurationManagement): any;
export declare function dataAzurermApiManagementHostnameConfigurationManagementToHclTerraform(struct?: DataAzurermApiManagementHostnameConfigurationManagement): any;
export declare class DataAzurermApiManagementHostnameConfigurationManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApiManagementHostnameConfigurationManagement | undefined;
    set internalValue(value: DataAzurermApiManagementHostnameConfigurationManagement | undefined);
    get hostName(): string;
    get keyVaultId(): string;
    get negotiateClientCertificate(): cdktf.IResolvable;
}
export declare class DataAzurermApiManagementHostnameConfigurationManagementList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApiManagementHostnameConfigurationManagementOutputReference;
}
export interface DataAzurermApiManagementHostnameConfigurationPortal {
}
export declare function dataAzurermApiManagementHostnameConfigurationPortalToTerraform(struct?: DataAzurermApiManagementHostnameConfigurationPortal): any;
export declare function dataAzurermApiManagementHostnameConfigurationPortalToHclTerraform(struct?: DataAzurermApiManagementHostnameConfigurationPortal): any;
export declare class DataAzurermApiManagementHostnameConfigurationPortalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApiManagementHostnameConfigurationPortal | undefined;
    set internalValue(value: DataAzurermApiManagementHostnameConfigurationPortal | undefined);
    get hostName(): string;
    get keyVaultId(): string;
    get negotiateClientCertificate(): cdktf.IResolvable;
}
export declare class DataAzurermApiManagementHostnameConfigurationPortalList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApiManagementHostnameConfigurationPortalOutputReference;
}
export interface DataAzurermApiManagementHostnameConfigurationProxy {
}
export declare function dataAzurermApiManagementHostnameConfigurationProxyToTerraform(struct?: DataAzurermApiManagementHostnameConfigurationProxy): any;
export declare function dataAzurermApiManagementHostnameConfigurationProxyToHclTerraform(struct?: DataAzurermApiManagementHostnameConfigurationProxy): any;
export declare class DataAzurermApiManagementHostnameConfigurationProxyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApiManagementHostnameConfigurationProxy | undefined;
    set internalValue(value: DataAzurermApiManagementHostnameConfigurationProxy | undefined);
    get defaultSslBinding(): cdktf.IResolvable;
    get hostName(): string;
    get keyVaultId(): string;
    get negotiateClientCertificate(): cdktf.IResolvable;
}
export declare class DataAzurermApiManagementHostnameConfigurationProxyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApiManagementHostnameConfigurationProxyOutputReference;
}
export interface DataAzurermApiManagementHostnameConfigurationScm {
}
export declare function dataAzurermApiManagementHostnameConfigurationScmToTerraform(struct?: DataAzurermApiManagementHostnameConfigurationScm): any;
export declare function dataAzurermApiManagementHostnameConfigurationScmToHclTerraform(struct?: DataAzurermApiManagementHostnameConfigurationScm): any;
export declare class DataAzurermApiManagementHostnameConfigurationScmOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApiManagementHostnameConfigurationScm | undefined;
    set internalValue(value: DataAzurermApiManagementHostnameConfigurationScm | undefined);
    get hostName(): string;
    get keyVaultId(): string;
    get negotiateClientCertificate(): cdktf.IResolvable;
}
export declare class DataAzurermApiManagementHostnameConfigurationScmList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApiManagementHostnameConfigurationScmOutputReference;
}
export interface DataAzurermApiManagementHostnameConfiguration {
}
export declare function dataAzurermApiManagementHostnameConfigurationToTerraform(struct?: DataAzurermApiManagementHostnameConfiguration): any;
export declare function dataAzurermApiManagementHostnameConfigurationToHclTerraform(struct?: DataAzurermApiManagementHostnameConfiguration): any;
export declare class DataAzurermApiManagementHostnameConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApiManagementHostnameConfiguration | undefined;
    set internalValue(value: DataAzurermApiManagementHostnameConfiguration | undefined);
    private _developerPortal;
    get developerPortal(): DataAzurermApiManagementHostnameConfigurationDeveloperPortalList;
    private _management;
    get management(): DataAzurermApiManagementHostnameConfigurationManagementList;
    private _portal;
    get portal(): DataAzurermApiManagementHostnameConfigurationPortalList;
    private _proxy;
    get proxy(): DataAzurermApiManagementHostnameConfigurationProxyList;
    private _scm;
    get scm(): DataAzurermApiManagementHostnameConfigurationScmList;
}
export declare class DataAzurermApiManagementHostnameConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApiManagementHostnameConfigurationOutputReference;
}
export interface DataAzurermApiManagementIdentity {
}
export declare function dataAzurermApiManagementIdentityToTerraform(struct?: DataAzurermApiManagementIdentity): any;
export declare function dataAzurermApiManagementIdentityToHclTerraform(struct?: DataAzurermApiManagementIdentity): any;
export declare class DataAzurermApiManagementIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApiManagementIdentity | undefined;
    set internalValue(value: DataAzurermApiManagementIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermApiManagementIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApiManagementIdentityOutputReference;
}
export interface DataAzurermApiManagementTenantAccess {
}
export declare function dataAzurermApiManagementTenantAccessToTerraform(struct?: DataAzurermApiManagementTenantAccess): any;
export declare function dataAzurermApiManagementTenantAccessToHclTerraform(struct?: DataAzurermApiManagementTenantAccess): any;
export declare class DataAzurermApiManagementTenantAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermApiManagementTenantAccess | undefined;
    set internalValue(value: DataAzurermApiManagementTenantAccess | undefined);
    get enabled(): cdktf.IResolvable;
    get primaryKey(): string;
    get secondaryKey(): string;
    get tenantId(): string;
}
export declare class DataAzurermApiManagementTenantAccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermApiManagementTenantAccessOutputReference;
}
export interface DataAzurermApiManagementTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management#read DataAzurermApiManagement#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApiManagementTimeoutsToTerraform(struct?: DataAzurermApiManagementTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermApiManagementTimeoutsToHclTerraform(struct?: DataAzurermApiManagementTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApiManagementTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermApiManagementTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermApiManagementTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management azurerm_api_management}
*/
export declare class DataAzurermApiManagement extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_api_management";
    /**
    * Generates CDKTF code for importing a DataAzurermApiManagement resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermApiManagement to import
    * @param importFromId The id of the existing DataAzurermApiManagement that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermApiManagement to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/api_management azurerm_api_management} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApiManagementConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementConfig);
    private _additionalLocation;
    get additionalLocation(): DataAzurermApiManagementAdditionalLocationList;
    get developerPortalUrl(): string;
    get gatewayRegionalUrl(): string;
    get gatewayUrl(): string;
    private _hostnameConfiguration;
    get hostnameConfiguration(): DataAzurermApiManagementHostnameConfigurationList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermApiManagementIdentityList;
    get location(): string;
    get managementApiUrl(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get notificationSenderEmail(): string;
    get portalUrl(): string;
    get privateIpAddresses(): string[];
    get publicIpAddressId(): string;
    get publicIpAddresses(): string[];
    get publisherEmail(): string;
    get publisherName(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get scmUrl(): string;
    get skuName(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tenantAccess;
    get tenantAccess(): DataAzurermApiManagementTenantAccessList;
    private _timeouts;
    get timeouts(): DataAzurermApiManagementTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApiManagementTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermApiManagementTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
