/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppServiceCertificateOrderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/app_service_certificate_order#id DataAzurermAppServiceCertificateOrder#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/app_service_certificate_order#name DataAzurermAppServiceCertificateOrder#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/app_service_certificate_order#resource_group_name DataAzurermAppServiceCertificateOrder#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/app_service_certificate_order#timeouts DataAzurermAppServiceCertificateOrder#timeouts}
    */
    readonly timeouts?: DataAzurermAppServiceCertificateOrderTimeouts;
}
export interface DataAzurermAppServiceCertificateOrderCertificates {
}
export declare function dataAzurermAppServiceCertificateOrderCertificatesToTerraform(struct?: DataAzurermAppServiceCertificateOrderCertificates): any;
export declare function dataAzurermAppServiceCertificateOrderCertificatesToHclTerraform(struct?: DataAzurermAppServiceCertificateOrderCertificates): any;
export declare class DataAzurermAppServiceCertificateOrderCertificatesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermAppServiceCertificateOrderCertificates | undefined;
    set internalValue(value: DataAzurermAppServiceCertificateOrderCertificates | undefined);
    get certificateName(): string;
    get keyVaultId(): string;
    get keyVaultSecretName(): string;
    get provisioningState(): string;
}
export declare class DataAzurermAppServiceCertificateOrderCertificatesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermAppServiceCertificateOrderCertificatesOutputReference;
}
export interface DataAzurermAppServiceCertificateOrderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/app_service_certificate_order#read DataAzurermAppServiceCertificateOrder#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppServiceCertificateOrderTimeoutsToTerraform(struct?: DataAzurermAppServiceCertificateOrderTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermAppServiceCertificateOrderTimeoutsToHclTerraform(struct?: DataAzurermAppServiceCertificateOrderTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppServiceCertificateOrderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermAppServiceCertificateOrderTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermAppServiceCertificateOrderTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/app_service_certificate_order azurerm_app_service_certificate_order}
*/
export declare class DataAzurermAppServiceCertificateOrder extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_app_service_certificate_order";
    /**
    * Generates CDKTF code for importing a DataAzurermAppServiceCertificateOrder resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermAppServiceCertificateOrder to import
    * @param importFromId The id of the existing DataAzurermAppServiceCertificateOrder that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/app_service_certificate_order#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermAppServiceCertificateOrder to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/app_service_certificate_order azurerm_app_service_certificate_order} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppServiceCertificateOrderConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppServiceCertificateOrderConfig);
    get appServiceCertificateNotRenewableReasons(): string[];
    get autoRenew(): cdktf.IResolvable;
    private _certificates;
    get certificates(): DataAzurermAppServiceCertificateOrderCertificatesList;
    get csr(): string;
    get distinguishedName(): string;
    get domainVerificationToken(): string;
    get expirationTime(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get intermediateThumbprint(): string;
    get isPrivateKeyExternal(): cdktf.IResolvable;
    get keySize(): number;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get productType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get rootThumbprint(): string;
    get signedCertificateThumbprint(): string;
    get status(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get validityInYears(): number;
    private _timeouts;
    get timeouts(): DataAzurermAppServiceCertificateOrderTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppServiceCertificateOrderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermAppServiceCertificateOrderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
