/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDevTestLabConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/dev_test_lab#id DataAzurermDevTestLab#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/dev_test_lab#name DataAzurermDevTestLab#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/dev_test_lab#resource_group_name DataAzurermDevTestLab#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/dev_test_lab#timeouts DataAzurermDevTestLab#timeouts}
    */
    readonly timeouts?: DataAzurermDevTestLabTimeouts;
}
export interface DataAzurermDevTestLabTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/dev_test_lab#read DataAzurermDevTestLab#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDevTestLabTimeoutsToTerraform(struct?: DataAzurermDevTestLabTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermDevTestLabTimeoutsToHclTerraform(struct?: DataAzurermDevTestLabTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDevTestLabTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermDevTestLabTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermDevTestLabTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/dev_test_lab azurerm_dev_test_lab}
*/
export declare class DataAzurermDevTestLab extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_dev_test_lab";
    /**
    * Generates CDKTF code for importing a DataAzurermDevTestLab resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermDevTestLab to import
    * @param importFromId The id of the existing DataAzurermDevTestLab that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/dev_test_lab#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermDevTestLab to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/dev_test_lab azurerm_dev_test_lab} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDevTestLabConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDevTestLabConfig);
    get artifactsStorageAccountId(): string;
    get defaultPremiumStorageAccountId(): string;
    get defaultStorageAccountId(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get keyVaultId(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get premiumDataDiskStorageAccountId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get storageType(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get uniqueIdentifier(): string;
    private _timeouts;
    get timeouts(): DataAzurermDevTestLabTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDevTestLabTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermDevTestLabTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
