/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermEventgridDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/eventgrid_domain#id DataAzurermEventgridDomain#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/eventgrid_domain#name DataAzurermEventgridDomain#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/eventgrid_domain#resource_group_name DataAzurermEventgridDomain#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/eventgrid_domain#timeouts DataAzurermEventgridDomain#timeouts}
    */
    readonly timeouts?: DataAzurermEventgridDomainTimeouts;
}
export interface DataAzurermEventgridDomainIdentity {
}
export declare function dataAzurermEventgridDomainIdentityToTerraform(struct?: DataAzurermEventgridDomainIdentity): any;
export declare function dataAzurermEventgridDomainIdentityToHclTerraform(struct?: DataAzurermEventgridDomainIdentity): any;
export declare class DataAzurermEventgridDomainIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermEventgridDomainIdentity | undefined;
    set internalValue(value: DataAzurermEventgridDomainIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermEventgridDomainIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermEventgridDomainIdentityOutputReference;
}
export interface DataAzurermEventgridDomainInboundIpRule {
}
export declare function dataAzurermEventgridDomainInboundIpRuleToTerraform(struct?: DataAzurermEventgridDomainInboundIpRule): any;
export declare function dataAzurermEventgridDomainInboundIpRuleToHclTerraform(struct?: DataAzurermEventgridDomainInboundIpRule): any;
export declare class DataAzurermEventgridDomainInboundIpRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermEventgridDomainInboundIpRule | undefined;
    set internalValue(value: DataAzurermEventgridDomainInboundIpRule | undefined);
    get action(): string;
    get ipMask(): string;
}
export declare class DataAzurermEventgridDomainInboundIpRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermEventgridDomainInboundIpRuleOutputReference;
}
export interface DataAzurermEventgridDomainInputMappingDefaultValues {
}
export declare function dataAzurermEventgridDomainInputMappingDefaultValuesToTerraform(struct?: DataAzurermEventgridDomainInputMappingDefaultValues): any;
export declare function dataAzurermEventgridDomainInputMappingDefaultValuesToHclTerraform(struct?: DataAzurermEventgridDomainInputMappingDefaultValues): any;
export declare class DataAzurermEventgridDomainInputMappingDefaultValuesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermEventgridDomainInputMappingDefaultValues | undefined;
    set internalValue(value: DataAzurermEventgridDomainInputMappingDefaultValues | undefined);
    get dataVersion(): string;
    get eventType(): string;
    get subject(): string;
}
export declare class DataAzurermEventgridDomainInputMappingDefaultValuesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermEventgridDomainInputMappingDefaultValuesOutputReference;
}
export interface DataAzurermEventgridDomainInputMappingFields {
}
export declare function dataAzurermEventgridDomainInputMappingFieldsToTerraform(struct?: DataAzurermEventgridDomainInputMappingFields): any;
export declare function dataAzurermEventgridDomainInputMappingFieldsToHclTerraform(struct?: DataAzurermEventgridDomainInputMappingFields): any;
export declare class DataAzurermEventgridDomainInputMappingFieldsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermEventgridDomainInputMappingFields | undefined;
    set internalValue(value: DataAzurermEventgridDomainInputMappingFields | undefined);
    get dataVersion(): string;
    get eventTime(): string;
    get eventType(): string;
    get id(): string;
    get subject(): string;
    get topic(): string;
}
export declare class DataAzurermEventgridDomainInputMappingFieldsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermEventgridDomainInputMappingFieldsOutputReference;
}
export interface DataAzurermEventgridDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/eventgrid_domain#read DataAzurermEventgridDomain#read}
    */
    readonly read?: string;
}
export declare function dataAzurermEventgridDomainTimeoutsToTerraform(struct?: DataAzurermEventgridDomainTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermEventgridDomainTimeoutsToHclTerraform(struct?: DataAzurermEventgridDomainTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermEventgridDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermEventgridDomainTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermEventgridDomainTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/eventgrid_domain azurerm_eventgrid_domain}
*/
export declare class DataAzurermEventgridDomain extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_eventgrid_domain";
    /**
    * Generates CDKTF code for importing a DataAzurermEventgridDomain resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermEventgridDomain to import
    * @param importFromId The id of the existing DataAzurermEventgridDomain that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/eventgrid_domain#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermEventgridDomain to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/eventgrid_domain azurerm_eventgrid_domain} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermEventgridDomainConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermEventgridDomainConfig);
    get endpoint(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermEventgridDomainIdentityList;
    private _inboundIpRule;
    get inboundIpRule(): DataAzurermEventgridDomainInboundIpRuleList;
    private _inputMappingDefaultValues;
    get inputMappingDefaultValues(): DataAzurermEventgridDomainInputMappingDefaultValuesList;
    private _inputMappingFields;
    get inputMappingFields(): DataAzurermEventgridDomainInputMappingFieldsList;
    get inputSchema(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurermEventgridDomainTimeoutsOutputReference;
    putTimeouts(value: DataAzurermEventgridDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermEventgridDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
