/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermHealthcareMedtechServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/healthcare_medtech_service#id DataAzurermHealthcareMedtechService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/healthcare_medtech_service#name DataAzurermHealthcareMedtechService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/healthcare_medtech_service#workspace_id DataAzurermHealthcareMedtechService#workspace_id}
    */
    readonly workspaceId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/healthcare_medtech_service#timeouts DataAzurermHealthcareMedtechService#timeouts}
    */
    readonly timeouts?: DataAzurermHealthcareMedtechServiceTimeouts;
}
export interface DataAzurermHealthcareMedtechServiceIdentity {
}
export declare function dataAzurermHealthcareMedtechServiceIdentityToTerraform(struct?: DataAzurermHealthcareMedtechServiceIdentity): any;
export declare function dataAzurermHealthcareMedtechServiceIdentityToHclTerraform(struct?: DataAzurermHealthcareMedtechServiceIdentity): any;
export declare class DataAzurermHealthcareMedtechServiceIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHealthcareMedtechServiceIdentity | undefined;
    set internalValue(value: DataAzurermHealthcareMedtechServiceIdentity | undefined);
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermHealthcareMedtechServiceIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHealthcareMedtechServiceIdentityOutputReference;
}
export interface DataAzurermHealthcareMedtechServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/healthcare_medtech_service#read DataAzurermHealthcareMedtechService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermHealthcareMedtechServiceTimeoutsToTerraform(struct?: DataAzurermHealthcareMedtechServiceTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermHealthcareMedtechServiceTimeoutsToHclTerraform(struct?: DataAzurermHealthcareMedtechServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermHealthcareMedtechServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermHealthcareMedtechServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermHealthcareMedtechServiceTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/healthcare_medtech_service azurerm_healthcare_medtech_service}
*/
export declare class DataAzurermHealthcareMedtechService extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_healthcare_medtech_service";
    /**
    * Generates CDKTF code for importing a DataAzurermHealthcareMedtechService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermHealthcareMedtechService to import
    * @param importFromId The id of the existing DataAzurermHealthcareMedtechService that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/healthcare_medtech_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermHealthcareMedtechService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/healthcare_medtech_service azurerm_healthcare_medtech_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermHealthcareMedtechServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermHealthcareMedtechServiceConfig);
    get deviceMappingJson(): string;
    get eventhubConsumerGroupName(): string;
    get eventhubName(): string;
    get eventhubNamespaceName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermHealthcareMedtechServiceIdentityList;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _workspaceId?;
    get workspaceId(): string;
    set workspaceId(value: string);
    get workspaceIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermHealthcareMedtechServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermHealthcareMedtechServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermHealthcareMedtechServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
