/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermHybridComputeMachineConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/hybrid_compute_machine#id DataAzurermHybridComputeMachine#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/hybrid_compute_machine#name DataAzurermHybridComputeMachine#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/hybrid_compute_machine#resource_group_name DataAzurermHybridComputeMachine#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/hybrid_compute_machine#timeouts DataAzurermHybridComputeMachine#timeouts}
    */
    readonly timeouts?: DataAzurermHybridComputeMachineTimeouts;
}
export interface DataAzurermHybridComputeMachineAgentConfigurationExtensionsAllowListStruct {
}
export declare function dataAzurermHybridComputeMachineAgentConfigurationExtensionsAllowListStructToTerraform(struct?: DataAzurermHybridComputeMachineAgentConfigurationExtensionsAllowListStruct): any;
export declare function dataAzurermHybridComputeMachineAgentConfigurationExtensionsAllowListStructToHclTerraform(struct?: DataAzurermHybridComputeMachineAgentConfigurationExtensionsAllowListStruct): any;
export declare class DataAzurermHybridComputeMachineAgentConfigurationExtensionsAllowListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineAgentConfigurationExtensionsAllowListStruct | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineAgentConfigurationExtensionsAllowListStruct | undefined);
    get publisher(): string;
    get type(): string;
}
export declare class DataAzurermHybridComputeMachineAgentConfigurationExtensionsAllowListStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineAgentConfigurationExtensionsAllowListStructOutputReference;
}
export interface DataAzurermHybridComputeMachineAgentConfigurationExtensionsBlockListStruct {
}
export declare function dataAzurermHybridComputeMachineAgentConfigurationExtensionsBlockListStructToTerraform(struct?: DataAzurermHybridComputeMachineAgentConfigurationExtensionsBlockListStruct): any;
export declare function dataAzurermHybridComputeMachineAgentConfigurationExtensionsBlockListStructToHclTerraform(struct?: DataAzurermHybridComputeMachineAgentConfigurationExtensionsBlockListStruct): any;
export declare class DataAzurermHybridComputeMachineAgentConfigurationExtensionsBlockListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineAgentConfigurationExtensionsBlockListStruct | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineAgentConfigurationExtensionsBlockListStruct | undefined);
    get publisher(): string;
    get type(): string;
}
export declare class DataAzurermHybridComputeMachineAgentConfigurationExtensionsBlockListStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineAgentConfigurationExtensionsBlockListStructOutputReference;
}
export interface DataAzurermHybridComputeMachineAgentConfiguration {
}
export declare function dataAzurermHybridComputeMachineAgentConfigurationToTerraform(struct?: DataAzurermHybridComputeMachineAgentConfiguration): any;
export declare function dataAzurermHybridComputeMachineAgentConfigurationToHclTerraform(struct?: DataAzurermHybridComputeMachineAgentConfiguration): any;
export declare class DataAzurermHybridComputeMachineAgentConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineAgentConfiguration | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineAgentConfiguration | undefined);
    private _extensionsAllowList;
    get extensionsAllowList(): DataAzurermHybridComputeMachineAgentConfigurationExtensionsAllowListStructList;
    private _extensionsBlockList;
    get extensionsBlockList(): DataAzurermHybridComputeMachineAgentConfigurationExtensionsBlockListStructList;
    get extensionsEnabled(): cdktf.IResolvable;
    get guestConfigurationEnabled(): cdktf.IResolvable;
    get incomingConnectionsPorts(): string[];
    get proxyBypass(): string[];
    get proxyUrl(): string;
}
export declare class DataAzurermHybridComputeMachineAgentConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineAgentConfigurationOutputReference;
}
export interface DataAzurermHybridComputeMachineCloudMetadata {
}
export declare function dataAzurermHybridComputeMachineCloudMetadataToTerraform(struct?: DataAzurermHybridComputeMachineCloudMetadata): any;
export declare function dataAzurermHybridComputeMachineCloudMetadataToHclTerraform(struct?: DataAzurermHybridComputeMachineCloudMetadata): any;
export declare class DataAzurermHybridComputeMachineCloudMetadataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineCloudMetadata | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineCloudMetadata | undefined);
    get provider(): string;
}
export declare class DataAzurermHybridComputeMachineCloudMetadataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineCloudMetadataOutputReference;
}
export interface DataAzurermHybridComputeMachineErrorDetailsAdditionalInfo {
}
export declare function dataAzurermHybridComputeMachineErrorDetailsAdditionalInfoToTerraform(struct?: DataAzurermHybridComputeMachineErrorDetailsAdditionalInfo): any;
export declare function dataAzurermHybridComputeMachineErrorDetailsAdditionalInfoToHclTerraform(struct?: DataAzurermHybridComputeMachineErrorDetailsAdditionalInfo): any;
export declare class DataAzurermHybridComputeMachineErrorDetailsAdditionalInfoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineErrorDetailsAdditionalInfo | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineErrorDetailsAdditionalInfo | undefined);
    get info(): string;
    get type(): string;
}
export declare class DataAzurermHybridComputeMachineErrorDetailsAdditionalInfoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineErrorDetailsAdditionalInfoOutputReference;
}
export interface DataAzurermHybridComputeMachineErrorDetails {
}
export declare function dataAzurermHybridComputeMachineErrorDetailsToTerraform(struct?: DataAzurermHybridComputeMachineErrorDetails): any;
export declare function dataAzurermHybridComputeMachineErrorDetailsToHclTerraform(struct?: DataAzurermHybridComputeMachineErrorDetails): any;
export declare class DataAzurermHybridComputeMachineErrorDetailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineErrorDetails | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineErrorDetails | undefined);
    private _additionalInfo;
    get additionalInfo(): DataAzurermHybridComputeMachineErrorDetailsAdditionalInfoList;
    get code(): string;
    get message(): string;
    get target(): string;
}
export declare class DataAzurermHybridComputeMachineErrorDetailsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineErrorDetailsOutputReference;
}
export interface DataAzurermHybridComputeMachineIdentity {
}
export declare function dataAzurermHybridComputeMachineIdentityToTerraform(struct?: DataAzurermHybridComputeMachineIdentity): any;
export declare function dataAzurermHybridComputeMachineIdentityToHclTerraform(struct?: DataAzurermHybridComputeMachineIdentity): any;
export declare class DataAzurermHybridComputeMachineIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineIdentity | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineIdentity | undefined);
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermHybridComputeMachineIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineIdentityOutputReference;
}
export interface DataAzurermHybridComputeMachineLocationData {
}
export declare function dataAzurermHybridComputeMachineLocationDataToTerraform(struct?: DataAzurermHybridComputeMachineLocationData): any;
export declare function dataAzurermHybridComputeMachineLocationDataToHclTerraform(struct?: DataAzurermHybridComputeMachineLocationData): any;
export declare class DataAzurermHybridComputeMachineLocationDataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineLocationData | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineLocationData | undefined);
    get city(): string;
    get countryOrRegion(): string;
    get district(): string;
    get name(): string;
}
export declare class DataAzurermHybridComputeMachineLocationDataList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineLocationDataOutputReference;
}
export interface DataAzurermHybridComputeMachineOsProfileLinuxConfigurationPatchSettings {
}
export declare function dataAzurermHybridComputeMachineOsProfileLinuxConfigurationPatchSettingsToTerraform(struct?: DataAzurermHybridComputeMachineOsProfileLinuxConfigurationPatchSettings): any;
export declare function dataAzurermHybridComputeMachineOsProfileLinuxConfigurationPatchSettingsToHclTerraform(struct?: DataAzurermHybridComputeMachineOsProfileLinuxConfigurationPatchSettings): any;
export declare class DataAzurermHybridComputeMachineOsProfileLinuxConfigurationPatchSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineOsProfileLinuxConfigurationPatchSettings | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineOsProfileLinuxConfigurationPatchSettings | undefined);
    get assessmentMode(): string;
    get patchMode(): string;
}
export declare class DataAzurermHybridComputeMachineOsProfileLinuxConfigurationPatchSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineOsProfileLinuxConfigurationPatchSettingsOutputReference;
}
export interface DataAzurermHybridComputeMachineOsProfileLinuxConfiguration {
}
export declare function dataAzurermHybridComputeMachineOsProfileLinuxConfigurationToTerraform(struct?: DataAzurermHybridComputeMachineOsProfileLinuxConfiguration): any;
export declare function dataAzurermHybridComputeMachineOsProfileLinuxConfigurationToHclTerraform(struct?: DataAzurermHybridComputeMachineOsProfileLinuxConfiguration): any;
export declare class DataAzurermHybridComputeMachineOsProfileLinuxConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineOsProfileLinuxConfiguration | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineOsProfileLinuxConfiguration | undefined);
    private _patchSettings;
    get patchSettings(): DataAzurermHybridComputeMachineOsProfileLinuxConfigurationPatchSettingsList;
}
export declare class DataAzurermHybridComputeMachineOsProfileLinuxConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineOsProfileLinuxConfigurationOutputReference;
}
export interface DataAzurermHybridComputeMachineOsProfileWindowsConfigurationPatchSettings {
}
export declare function dataAzurermHybridComputeMachineOsProfileWindowsConfigurationPatchSettingsToTerraform(struct?: DataAzurermHybridComputeMachineOsProfileWindowsConfigurationPatchSettings): any;
export declare function dataAzurermHybridComputeMachineOsProfileWindowsConfigurationPatchSettingsToHclTerraform(struct?: DataAzurermHybridComputeMachineOsProfileWindowsConfigurationPatchSettings): any;
export declare class DataAzurermHybridComputeMachineOsProfileWindowsConfigurationPatchSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineOsProfileWindowsConfigurationPatchSettings | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineOsProfileWindowsConfigurationPatchSettings | undefined);
    get assessmentMode(): string;
    get patchMode(): string;
}
export declare class DataAzurermHybridComputeMachineOsProfileWindowsConfigurationPatchSettingsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineOsProfileWindowsConfigurationPatchSettingsOutputReference;
}
export interface DataAzurermHybridComputeMachineOsProfileWindowsConfiguration {
}
export declare function dataAzurermHybridComputeMachineOsProfileWindowsConfigurationToTerraform(struct?: DataAzurermHybridComputeMachineOsProfileWindowsConfiguration): any;
export declare function dataAzurermHybridComputeMachineOsProfileWindowsConfigurationToHclTerraform(struct?: DataAzurermHybridComputeMachineOsProfileWindowsConfiguration): any;
export declare class DataAzurermHybridComputeMachineOsProfileWindowsConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineOsProfileWindowsConfiguration | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineOsProfileWindowsConfiguration | undefined);
    private _patchSettings;
    get patchSettings(): DataAzurermHybridComputeMachineOsProfileWindowsConfigurationPatchSettingsList;
}
export declare class DataAzurermHybridComputeMachineOsProfileWindowsConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineOsProfileWindowsConfigurationOutputReference;
}
export interface DataAzurermHybridComputeMachineOsProfile {
}
export declare function dataAzurermHybridComputeMachineOsProfileToTerraform(struct?: DataAzurermHybridComputeMachineOsProfile): any;
export declare function dataAzurermHybridComputeMachineOsProfileToHclTerraform(struct?: DataAzurermHybridComputeMachineOsProfile): any;
export declare class DataAzurermHybridComputeMachineOsProfileOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineOsProfile | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineOsProfile | undefined);
    get computerName(): string;
    private _linuxConfiguration;
    get linuxConfiguration(): DataAzurermHybridComputeMachineOsProfileLinuxConfigurationList;
    private _windowsConfiguration;
    get windowsConfiguration(): DataAzurermHybridComputeMachineOsProfileWindowsConfigurationList;
}
export declare class DataAzurermHybridComputeMachineOsProfileList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineOsProfileOutputReference;
}
export interface DataAzurermHybridComputeMachineServiceStatusExtensionService {
}
export declare function dataAzurermHybridComputeMachineServiceStatusExtensionServiceToTerraform(struct?: DataAzurermHybridComputeMachineServiceStatusExtensionService): any;
export declare function dataAzurermHybridComputeMachineServiceStatusExtensionServiceToHclTerraform(struct?: DataAzurermHybridComputeMachineServiceStatusExtensionService): any;
export declare class DataAzurermHybridComputeMachineServiceStatusExtensionServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineServiceStatusExtensionService | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineServiceStatusExtensionService | undefined);
    get startupType(): string;
    get status(): string;
}
export declare class DataAzurermHybridComputeMachineServiceStatusExtensionServiceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineServiceStatusExtensionServiceOutputReference;
}
export interface DataAzurermHybridComputeMachineServiceStatusGuestConfigurationService {
}
export declare function dataAzurermHybridComputeMachineServiceStatusGuestConfigurationServiceToTerraform(struct?: DataAzurermHybridComputeMachineServiceStatusGuestConfigurationService): any;
export declare function dataAzurermHybridComputeMachineServiceStatusGuestConfigurationServiceToHclTerraform(struct?: DataAzurermHybridComputeMachineServiceStatusGuestConfigurationService): any;
export declare class DataAzurermHybridComputeMachineServiceStatusGuestConfigurationServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineServiceStatusGuestConfigurationService | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineServiceStatusGuestConfigurationService | undefined);
    get startupType(): string;
    get status(): string;
}
export declare class DataAzurermHybridComputeMachineServiceStatusGuestConfigurationServiceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineServiceStatusGuestConfigurationServiceOutputReference;
}
export interface DataAzurermHybridComputeMachineServiceStatus {
}
export declare function dataAzurermHybridComputeMachineServiceStatusToTerraform(struct?: DataAzurermHybridComputeMachineServiceStatus): any;
export declare function dataAzurermHybridComputeMachineServiceStatusToHclTerraform(struct?: DataAzurermHybridComputeMachineServiceStatus): any;
export declare class DataAzurermHybridComputeMachineServiceStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermHybridComputeMachineServiceStatus | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineServiceStatus | undefined);
    private _extensionService;
    get extensionService(): DataAzurermHybridComputeMachineServiceStatusExtensionServiceList;
    private _guestConfigurationService;
    get guestConfigurationService(): DataAzurermHybridComputeMachineServiceStatusGuestConfigurationServiceList;
}
export declare class DataAzurermHybridComputeMachineServiceStatusList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermHybridComputeMachineServiceStatusOutputReference;
}
export interface DataAzurermHybridComputeMachineTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/hybrid_compute_machine#read DataAzurermHybridComputeMachine#read}
    */
    readonly read?: string;
}
export declare function dataAzurermHybridComputeMachineTimeoutsToTerraform(struct?: DataAzurermHybridComputeMachineTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermHybridComputeMachineTimeoutsToHclTerraform(struct?: DataAzurermHybridComputeMachineTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermHybridComputeMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermHybridComputeMachineTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermHybridComputeMachineTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/hybrid_compute_machine azurerm_hybrid_compute_machine}
*/
export declare class DataAzurermHybridComputeMachine extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_hybrid_compute_machine";
    /**
    * Generates CDKTF code for importing a DataAzurermHybridComputeMachine resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermHybridComputeMachine to import
    * @param importFromId The id of the existing DataAzurermHybridComputeMachine that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/hybrid_compute_machine#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermHybridComputeMachine to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/hybrid_compute_machine azurerm_hybrid_compute_machine} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermHybridComputeMachineConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermHybridComputeMachineConfig);
    get adFqdn(): string;
    private _agentConfiguration;
    get agentConfiguration(): DataAzurermHybridComputeMachineAgentConfigurationList;
    get agentVersion(): string;
    get clientPublicKey(): string;
    private _cloudMetadata;
    get cloudMetadata(): DataAzurermHybridComputeMachineCloudMetadataList;
    private _detectedProperties;
    get detectedProperties(): cdktf.StringMap;
    get displayName(): string;
    get dnsFqdn(): string;
    get domainName(): string;
    private _errorDetails;
    get errorDetails(): DataAzurermHybridComputeMachineErrorDetailsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermHybridComputeMachineIdentityList;
    get lastStatusChange(): string;
    get location(): string;
    private _locationData;
    get locationData(): DataAzurermHybridComputeMachineLocationDataList;
    get machineFqdn(): string;
    get mssqlDiscovered(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get osName(): string;
    private _osProfile;
    get osProfile(): DataAzurermHybridComputeMachineOsProfileList;
    get osSku(): string;
    get osType(): string;
    get osVersion(): string;
    get parentClusterResourceId(): string;
    get privateLinkScopeResourceId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceStatus;
    get serviceStatus(): DataAzurermHybridComputeMachineServiceStatusList;
    get status(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get vmId(): string;
    get vmUuid(): string;
    private _timeouts;
    get timeouts(): DataAzurermHybridComputeMachineTimeoutsOutputReference;
    putTimeouts(value: DataAzurermHybridComputeMachineTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermHybridComputeMachineTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
