/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMobileNetworkPacketCoreControlPlaneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/mobile_network_packet_core_control_plane#id DataAzurermMobileNetworkPacketCoreControlPlane#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/mobile_network_packet_core_control_plane#name DataAzurermMobileNetworkPacketCoreControlPlane#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/mobile_network_packet_core_control_plane#resource_group_name DataAzurermMobileNetworkPacketCoreControlPlane#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/mobile_network_packet_core_control_plane#timeouts DataAzurermMobileNetworkPacketCoreControlPlane#timeouts}
    */
    readonly timeouts?: DataAzurermMobileNetworkPacketCoreControlPlaneTimeouts;
}
export interface DataAzurermMobileNetworkPacketCoreControlPlaneIdentity {
}
export declare function dataAzurermMobileNetworkPacketCoreControlPlaneIdentityToTerraform(struct?: DataAzurermMobileNetworkPacketCoreControlPlaneIdentity): any;
export declare function dataAzurermMobileNetworkPacketCoreControlPlaneIdentityToHclTerraform(struct?: DataAzurermMobileNetworkPacketCoreControlPlaneIdentity): any;
export declare class DataAzurermMobileNetworkPacketCoreControlPlaneIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkPacketCoreControlPlaneIdentity | undefined;
    set internalValue(value: DataAzurermMobileNetworkPacketCoreControlPlaneIdentity | undefined);
    get identityIds(): string[];
    get type(): string;
}
export declare class DataAzurermMobileNetworkPacketCoreControlPlaneIdentityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkPacketCoreControlPlaneIdentityOutputReference;
}
export interface DataAzurermMobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccess {
}
export declare function dataAzurermMobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccessToTerraform(struct?: DataAzurermMobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccess): any;
export declare function dataAzurermMobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccessToHclTerraform(struct?: DataAzurermMobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccess): any;
export declare class DataAzurermMobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccessOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccess | undefined;
    set internalValue(value: DataAzurermMobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccess | undefined);
    get authenticationType(): string;
    get httpsServerCertificateUrl(): string;
}
export declare class DataAzurermMobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccessList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccessOutputReference;
}
export interface DataAzurermMobileNetworkPacketCoreControlPlanePlatform {
}
export declare function dataAzurermMobileNetworkPacketCoreControlPlanePlatformToTerraform(struct?: DataAzurermMobileNetworkPacketCoreControlPlanePlatform): any;
export declare function dataAzurermMobileNetworkPacketCoreControlPlanePlatformToHclTerraform(struct?: DataAzurermMobileNetworkPacketCoreControlPlanePlatform): any;
export declare class DataAzurermMobileNetworkPacketCoreControlPlanePlatformOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurermMobileNetworkPacketCoreControlPlanePlatform | undefined;
    set internalValue(value: DataAzurermMobileNetworkPacketCoreControlPlanePlatform | undefined);
    get arcKubernetesClusterId(): string;
    get customLocationId(): string;
    get edgeDeviceId(): string;
    get stackHciClusterId(): string;
    get type(): string;
}
export declare class DataAzurermMobileNetworkPacketCoreControlPlanePlatformList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurermMobileNetworkPacketCoreControlPlanePlatformOutputReference;
}
export interface DataAzurermMobileNetworkPacketCoreControlPlaneTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/mobile_network_packet_core_control_plane#read DataAzurermMobileNetworkPacketCoreControlPlane#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMobileNetworkPacketCoreControlPlaneTimeoutsToTerraform(struct?: DataAzurermMobileNetworkPacketCoreControlPlaneTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermMobileNetworkPacketCoreControlPlaneTimeoutsToHclTerraform(struct?: DataAzurermMobileNetworkPacketCoreControlPlaneTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMobileNetworkPacketCoreControlPlaneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermMobileNetworkPacketCoreControlPlaneTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermMobileNetworkPacketCoreControlPlaneTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/mobile_network_packet_core_control_plane azurerm_mobile_network_packet_core_control_plane}
*/
export declare class DataAzurermMobileNetworkPacketCoreControlPlane extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_mobile_network_packet_core_control_plane";
    /**
    * Generates CDKTF code for importing a DataAzurermMobileNetworkPacketCoreControlPlane resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermMobileNetworkPacketCoreControlPlane to import
    * @param importFromId The id of the existing DataAzurermMobileNetworkPacketCoreControlPlane that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/mobile_network_packet_core_control_plane#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermMobileNetworkPacketCoreControlPlane to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/mobile_network_packet_core_control_plane azurerm_mobile_network_packet_core_control_plane} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMobileNetworkPacketCoreControlPlaneConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMobileNetworkPacketCoreControlPlaneConfig);
    get controlPlaneAccessIpv4Address(): string;
    get controlPlaneAccessIpv4Gateway(): string;
    get controlPlaneAccessIpv4Subnet(): string;
    get controlPlaneAccessName(): string;
    get coreNetworkTechnology(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _identity;
    get identity(): DataAzurermMobileNetworkPacketCoreControlPlaneIdentityList;
    get interoperabilitySettingsJson(): string;
    private _localDiagnosticsAccess;
    get localDiagnosticsAccess(): DataAzurermMobileNetworkPacketCoreControlPlaneLocalDiagnosticsAccessList;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _platform;
    get platform(): DataAzurermMobileNetworkPacketCoreControlPlanePlatformList;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get siteIds(): string[];
    get sku(): string;
    get softwareVersion(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    get userEquipmentMtuInBytes(): number;
    private _timeouts;
    get timeouts(): DataAzurermMobileNetworkPacketCoreControlPlaneTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMobileNetworkPacketCoreControlPlaneTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermMobileNetworkPacketCoreControlPlaneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
