/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermSentinelAlertRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/sentinel_alert_rule#id DataAzurermSentinelAlertRule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/sentinel_alert_rule#log_analytics_workspace_id DataAzurermSentinelAlertRule#log_analytics_workspace_id}
    */
    readonly logAnalyticsWorkspaceId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/sentinel_alert_rule#name DataAzurermSentinelAlertRule#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/sentinel_alert_rule#timeouts DataAzurermSentinelAlertRule#timeouts}
    */
    readonly timeouts?: DataAzurermSentinelAlertRuleTimeouts;
}
export interface DataAzurermSentinelAlertRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/sentinel_alert_rule#read DataAzurermSentinelAlertRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermSentinelAlertRuleTimeoutsToTerraform(struct?: DataAzurermSentinelAlertRuleTimeouts | cdktf.IResolvable): any;
export declare function dataAzurermSentinelAlertRuleTimeoutsToHclTerraform(struct?: DataAzurermSentinelAlertRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermSentinelAlertRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurermSentinelAlertRuleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurermSentinelAlertRuleTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/sentinel_alert_rule azurerm_sentinel_alert_rule}
*/
export declare class DataAzurermSentinelAlertRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurerm_sentinel_alert_rule";
    /**
    * Generates CDKTF code for importing a DataAzurermSentinelAlertRule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataAzurermSentinelAlertRule to import
    * @param importFromId The id of the existing DataAzurermSentinelAlertRule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/sentinel_alert_rule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataAzurermSentinelAlertRule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/data-sources/sentinel_alert_rule azurerm_sentinel_alert_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermSentinelAlertRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermSentinelAlertRuleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _logAnalyticsWorkspaceId?;
    get logAnalyticsWorkspaceId(): string;
    set logAnalyticsWorkspaceId(value: string);
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermSentinelAlertRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermSentinelAlertRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurermSentinelAlertRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
