/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataProtectionBackupPolicyKubernetesClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#backup_repeating_time_intervals DataProtectionBackupPolicyKubernetesCluster#backup_repeating_time_intervals}
    */
    readonly backupRepeatingTimeIntervals: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#id DataProtectionBackupPolicyKubernetesCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#name DataProtectionBackupPolicyKubernetesCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#resource_group_name DataProtectionBackupPolicyKubernetesCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#time_zone DataProtectionBackupPolicyKubernetesCluster#time_zone}
    */
    readonly timeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#vault_name DataProtectionBackupPolicyKubernetesCluster#vault_name}
    */
    readonly vaultName: string;
    /**
    * default_retention_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#default_retention_rule DataProtectionBackupPolicyKubernetesCluster#default_retention_rule}
    */
    readonly defaultRetentionRule: DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRule;
    /**
    * retention_rule block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#retention_rule DataProtectionBackupPolicyKubernetesCluster#retention_rule}
    */
    readonly retentionRule?: DataProtectionBackupPolicyKubernetesClusterRetentionRule[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#timeouts DataProtectionBackupPolicyKubernetesCluster#timeouts}
    */
    readonly timeouts?: DataProtectionBackupPolicyKubernetesClusterTimeouts;
}
export interface DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#data_store_type DataProtectionBackupPolicyKubernetesCluster#data_store_type}
    */
    readonly dataStoreType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#duration DataProtectionBackupPolicyKubernetesCluster#duration}
    */
    readonly duration: string;
}
export declare function dataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycleToTerraform(struct?: DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycleToHclTerraform(struct?: DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle | cdktf.IResolvable | undefined);
    private _dataStoreType?;
    get dataStoreType(): string;
    set dataStoreType(value: string);
    get dataStoreTypeInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
}
export declare class DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycleOutputReference;
}
export interface DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRule {
    /**
    * life_cycle block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#life_cycle DataProtectionBackupPolicyKubernetesCluster#life_cycle}
    */
    readonly lifeCycle: DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle[] | cdktf.IResolvable;
}
export declare function dataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleToTerraform(struct?: DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleOutputReference | DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRule): any;
export declare function dataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleToHclTerraform(struct?: DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleOutputReference | DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRule): any;
export declare class DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRule | undefined;
    set internalValue(value: DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRule | undefined);
    private _lifeCycle;
    get lifeCycle(): DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycleList;
    putLifeCycle(value: DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle[] | cdktf.IResolvable): void;
    get lifeCycleInput(): cdktf.IResolvable | DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleLifeCycle[] | undefined;
}
export interface DataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteria {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#absolute_criteria DataProtectionBackupPolicyKubernetesCluster#absolute_criteria}
    */
    readonly absoluteCriteria?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#days_of_week DataProtectionBackupPolicyKubernetesCluster#days_of_week}
    */
    readonly daysOfWeek?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#months_of_year DataProtectionBackupPolicyKubernetesCluster#months_of_year}
    */
    readonly monthsOfYear?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#scheduled_backup_times DataProtectionBackupPolicyKubernetesCluster#scheduled_backup_times}
    */
    readonly scheduledBackupTimes?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#weeks_of_month DataProtectionBackupPolicyKubernetesCluster#weeks_of_month}
    */
    readonly weeksOfMonth?: string[];
}
export declare function dataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteriaToTerraform(struct?: DataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteriaOutputReference | DataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteria): any;
export declare function dataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteriaToHclTerraform(struct?: DataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteriaOutputReference | DataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteria): any;
export declare class DataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteriaOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteria | undefined;
    set internalValue(value: DataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteria | undefined);
    private _absoluteCriteria?;
    get absoluteCriteria(): string;
    set absoluteCriteria(value: string);
    resetAbsoluteCriteria(): void;
    get absoluteCriteriaInput(): string | undefined;
    private _daysOfWeek?;
    get daysOfWeek(): string[];
    set daysOfWeek(value: string[]);
    resetDaysOfWeek(): void;
    get daysOfWeekInput(): string[] | undefined;
    private _monthsOfYear?;
    get monthsOfYear(): string[];
    set monthsOfYear(value: string[]);
    resetMonthsOfYear(): void;
    get monthsOfYearInput(): string[] | undefined;
    private _scheduledBackupTimes?;
    get scheduledBackupTimes(): string[];
    set scheduledBackupTimes(value: string[]);
    resetScheduledBackupTimes(): void;
    get scheduledBackupTimesInput(): string[] | undefined;
    private _weeksOfMonth?;
    get weeksOfMonth(): string[];
    set weeksOfMonth(value: string[]);
    resetWeeksOfMonth(): void;
    get weeksOfMonthInput(): string[] | undefined;
}
export interface DataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycle {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#data_store_type DataProtectionBackupPolicyKubernetesCluster#data_store_type}
    */
    readonly dataStoreType: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#duration DataProtectionBackupPolicyKubernetesCluster#duration}
    */
    readonly duration: string;
}
export declare function dataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycleToTerraform(struct?: DataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycle | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycleToHclTerraform(struct?: DataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycle | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycle | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycle | cdktf.IResolvable | undefined);
    private _dataStoreType?;
    get dataStoreType(): string;
    set dataStoreType(value: string);
    get dataStoreTypeInput(): string | undefined;
    private _duration?;
    get duration(): string;
    set duration(value: string);
    get durationInput(): string | undefined;
}
export declare class DataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycle[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycleOutputReference;
}
export interface DataProtectionBackupPolicyKubernetesClusterRetentionRule {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#name DataProtectionBackupPolicyKubernetesCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#priority DataProtectionBackupPolicyKubernetesCluster#priority}
    */
    readonly priority: number;
    /**
    * criteria block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#criteria DataProtectionBackupPolicyKubernetesCluster#criteria}
    */
    readonly criteria: DataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteria;
    /**
    * life_cycle block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#life_cycle DataProtectionBackupPolicyKubernetesCluster#life_cycle}
    */
    readonly lifeCycle: DataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycle[] | cdktf.IResolvable;
}
export declare function dataProtectionBackupPolicyKubernetesClusterRetentionRuleToTerraform(struct?: DataProtectionBackupPolicyKubernetesClusterRetentionRule | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyKubernetesClusterRetentionRuleToHclTerraform(struct?: DataProtectionBackupPolicyKubernetesClusterRetentionRule | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyKubernetesClusterRetentionRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataProtectionBackupPolicyKubernetesClusterRetentionRule | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyKubernetesClusterRetentionRule | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _priority?;
    get priority(): number;
    set priority(value: number);
    get priorityInput(): number | undefined;
    private _criteria;
    get criteria(): DataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteriaOutputReference;
    putCriteria(value: DataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteria): void;
    get criteriaInput(): DataProtectionBackupPolicyKubernetesClusterRetentionRuleCriteria | undefined;
    private _lifeCycle;
    get lifeCycle(): DataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycleList;
    putLifeCycle(value: DataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycle[] | cdktf.IResolvable): void;
    get lifeCycleInput(): cdktf.IResolvable | DataProtectionBackupPolicyKubernetesClusterRetentionRuleLifeCycle[] | undefined;
}
export declare class DataProtectionBackupPolicyKubernetesClusterRetentionRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataProtectionBackupPolicyKubernetesClusterRetentionRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataProtectionBackupPolicyKubernetesClusterRetentionRuleOutputReference;
}
export interface DataProtectionBackupPolicyKubernetesClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#create DataProtectionBackupPolicyKubernetesCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#delete DataProtectionBackupPolicyKubernetesCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#read DataProtectionBackupPolicyKubernetesCluster#read}
    */
    readonly read?: string;
}
export declare function dataProtectionBackupPolicyKubernetesClusterTimeoutsToTerraform(struct?: DataProtectionBackupPolicyKubernetesClusterTimeouts | cdktf.IResolvable): any;
export declare function dataProtectionBackupPolicyKubernetesClusterTimeoutsToHclTerraform(struct?: DataProtectionBackupPolicyKubernetesClusterTimeouts | cdktf.IResolvable): any;
export declare class DataProtectionBackupPolicyKubernetesClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataProtectionBackupPolicyKubernetesClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataProtectionBackupPolicyKubernetesClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster azurerm_data_protection_backup_policy_kubernetes_cluster}
*/
export declare class DataProtectionBackupPolicyKubernetesCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_data_protection_backup_policy_kubernetes_cluster";
    /**
    * Generates CDKTF code for importing a DataProtectionBackupPolicyKubernetesCluster resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataProtectionBackupPolicyKubernetesCluster to import
    * @param importFromId The id of the existing DataProtectionBackupPolicyKubernetesCluster that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataProtectionBackupPolicyKubernetesCluster to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/data_protection_backup_policy_kubernetes_cluster azurerm_data_protection_backup_policy_kubernetes_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataProtectionBackupPolicyKubernetesClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataProtectionBackupPolicyKubernetesClusterConfig);
    private _backupRepeatingTimeIntervals?;
    get backupRepeatingTimeIntervals(): string[];
    set backupRepeatingTimeIntervals(value: string[]);
    get backupRepeatingTimeIntervalsInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    resetTimeZone(): void;
    get timeZoneInput(): string | undefined;
    private _vaultName?;
    get vaultName(): string;
    set vaultName(value: string);
    get vaultNameInput(): string | undefined;
    private _defaultRetentionRule;
    get defaultRetentionRule(): DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRuleOutputReference;
    putDefaultRetentionRule(value: DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRule): void;
    get defaultRetentionRuleInput(): DataProtectionBackupPolicyKubernetesClusterDefaultRetentionRule | undefined;
    private _retentionRule;
    get retentionRule(): DataProtectionBackupPolicyKubernetesClusterRetentionRuleList;
    putRetentionRule(value: DataProtectionBackupPolicyKubernetesClusterRetentionRule[] | cdktf.IResolvable): void;
    resetRetentionRule(): void;
    get retentionRuleInput(): cdktf.IResolvable | DataProtectionBackupPolicyKubernetesClusterRetentionRule[] | undefined;
    private _timeouts;
    get timeouts(): DataProtectionBackupPolicyKubernetesClusterTimeoutsOutputReference;
    putTimeouts(value: DataProtectionBackupPolicyKubernetesClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataProtectionBackupPolicyKubernetesClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
