/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface LabServiceScheduleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#id LabServiceSchedule#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#lab_id LabServiceSchedule#lab_id}
    */
    readonly labId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#name LabServiceSchedule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#notes LabServiceSchedule#notes}
    */
    readonly notes?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#start_time LabServiceSchedule#start_time}
    */
    readonly startTime?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#stop_time LabServiceSchedule#stop_time}
    */
    readonly stopTime: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#time_zone LabServiceSchedule#time_zone}
    */
    readonly timeZone: string;
    /**
    * recurrence block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#recurrence LabServiceSchedule#recurrence}
    */
    readonly recurrence?: LabServiceScheduleRecurrence;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#timeouts LabServiceSchedule#timeouts}
    */
    readonly timeouts?: LabServiceScheduleTimeouts;
}
export interface LabServiceScheduleRecurrence {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#expiration_date LabServiceSchedule#expiration_date}
    */
    readonly expirationDate: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#frequency LabServiceSchedule#frequency}
    */
    readonly frequency: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#interval LabServiceSchedule#interval}
    */
    readonly interval?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#week_days LabServiceSchedule#week_days}
    */
    readonly weekDays?: string[];
}
export declare function labServiceScheduleRecurrenceToTerraform(struct?: LabServiceScheduleRecurrenceOutputReference | LabServiceScheduleRecurrence): any;
export declare function labServiceScheduleRecurrenceToHclTerraform(struct?: LabServiceScheduleRecurrenceOutputReference | LabServiceScheduleRecurrence): any;
export declare class LabServiceScheduleRecurrenceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServiceScheduleRecurrence | undefined;
    set internalValue(value: LabServiceScheduleRecurrence | undefined);
    private _expirationDate?;
    get expirationDate(): string;
    set expirationDate(value: string);
    get expirationDateInput(): string | undefined;
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    get frequencyInput(): string | undefined;
    private _interval?;
    get interval(): number;
    set interval(value: number);
    resetInterval(): void;
    get intervalInput(): number | undefined;
    private _weekDays?;
    get weekDays(): string[];
    set weekDays(value: string[]);
    resetWeekDays(): void;
    get weekDaysInput(): string[] | undefined;
}
export interface LabServiceScheduleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#create LabServiceSchedule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#delete LabServiceSchedule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#read LabServiceSchedule#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#update LabServiceSchedule#update}
    */
    readonly update?: string;
}
export declare function labServiceScheduleTimeoutsToTerraform(struct?: LabServiceScheduleTimeouts | cdktf.IResolvable): any;
export declare function labServiceScheduleTimeoutsToHclTerraform(struct?: LabServiceScheduleTimeouts | cdktf.IResolvable): any;
export declare class LabServiceScheduleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): LabServiceScheduleTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: LabServiceScheduleTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule azurerm_lab_service_schedule}
*/
export declare class LabServiceSchedule extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_lab_service_schedule";
    /**
    * Generates CDKTF code for importing a LabServiceSchedule resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the LabServiceSchedule to import
    * @param importFromId The id of the existing LabServiceSchedule that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the LabServiceSchedule to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/lab_service_schedule azurerm_lab_service_schedule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options LabServiceScheduleConfig
    */
    constructor(scope: Construct, id: string, config: LabServiceScheduleConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labId?;
    get labId(): string;
    set labId(value: string);
    get labIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notes?;
    get notes(): string;
    set notes(value: string);
    resetNotes(): void;
    get notesInput(): string | undefined;
    private _startTime?;
    get startTime(): string;
    set startTime(value: string);
    resetStartTime(): void;
    get startTimeInput(): string | undefined;
    private _stopTime?;
    get stopTime(): string;
    set stopTime(value: string);
    get stopTimeInput(): string | undefined;
    private _timeZone?;
    get timeZone(): string;
    set timeZone(value: string);
    get timeZoneInput(): string | undefined;
    private _recurrence;
    get recurrence(): LabServiceScheduleRecurrenceOutputReference;
    putRecurrence(value: LabServiceScheduleRecurrence): void;
    resetRecurrence(): void;
    get recurrenceInput(): LabServiceScheduleRecurrence | undefined;
    private _timeouts;
    get timeouts(): LabServiceScheduleTimeoutsOutputReference;
    putTimeouts(value: LabServiceScheduleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | LabServiceScheduleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
