/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NginxCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate#certificate_virtual_path NginxCertificate#certificate_virtual_path}
    */
    readonly certificateVirtualPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate#id NginxCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate#key_vault_secret_id NginxCertificate#key_vault_secret_id}
    */
    readonly keyVaultSecretId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate#key_virtual_path NginxCertificate#key_virtual_path}
    */
    readonly keyVirtualPath: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate#name NginxCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate#nginx_deployment_id NginxCertificate#nginx_deployment_id}
    */
    readonly nginxDeploymentId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate#timeouts NginxCertificate#timeouts}
    */
    readonly timeouts?: NginxCertificateTimeouts;
}
export interface NginxCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate#create NginxCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate#delete NginxCertificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate#read NginxCertificate#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate#update NginxCertificate#update}
    */
    readonly update?: string;
}
export declare function nginxCertificateTimeoutsToTerraform(struct?: NginxCertificateTimeouts | cdktf.IResolvable): any;
export declare function nginxCertificateTimeoutsToHclTerraform(struct?: NginxCertificateTimeouts | cdktf.IResolvable): any;
export declare class NginxCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NginxCertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NginxCertificateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate azurerm_nginx_certificate}
*/
export declare class NginxCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_nginx_certificate";
    /**
    * Generates CDKTF code for importing a NginxCertificate resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NginxCertificate to import
    * @param importFromId The id of the existing NginxCertificate that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NginxCertificate to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/nginx_certificate azurerm_nginx_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NginxCertificateConfig
    */
    constructor(scope: Construct, id: string, config: NginxCertificateConfig);
    private _certificateVirtualPath?;
    get certificateVirtualPath(): string;
    set certificateVirtualPath(value: string);
    get certificateVirtualPathInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyVaultSecretId?;
    get keyVaultSecretId(): string;
    set keyVaultSecretId(value: string);
    get keyVaultSecretIdInput(): string | undefined;
    private _keyVirtualPath?;
    get keyVirtualPath(): string;
    set keyVirtualPath(value: string);
    get keyVirtualPathInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nginxDeploymentId?;
    get nginxDeploymentId(): string;
    set nginxDeploymentId(value: string);
    get nginxDeploymentIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): NginxCertificateTimeoutsOutputReference;
    putTimeouts(value: NginxCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NginxCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
