/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OrbitalContactProfileConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#auto_tracking OrbitalContactProfile#auto_tracking}
    */
    readonly autoTracking: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#event_hub_uri OrbitalContactProfile#event_hub_uri}
    */
    readonly eventHubUri?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#id OrbitalContactProfile#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#location OrbitalContactProfile#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#minimum_elevation_degrees OrbitalContactProfile#minimum_elevation_degrees}
    */
    readonly minimumElevationDegrees?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#minimum_variable_contact_duration OrbitalContactProfile#minimum_variable_contact_duration}
    */
    readonly minimumVariableContactDuration: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#name OrbitalContactProfile#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#network_configuration_subnet_id OrbitalContactProfile#network_configuration_subnet_id}
    */
    readonly networkConfigurationSubnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#resource_group_name OrbitalContactProfile#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#tags OrbitalContactProfile#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * links block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#links OrbitalContactProfile#links}
    */
    readonly links: OrbitalContactProfileLinks[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#timeouts OrbitalContactProfile#timeouts}
    */
    readonly timeouts?: OrbitalContactProfileTimeouts;
}
export interface OrbitalContactProfileLinksChannelsEndPoint {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#end_point_name OrbitalContactProfile#end_point_name}
    */
    readonly endPointName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#ip_address OrbitalContactProfile#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#port OrbitalContactProfile#port}
    */
    readonly port: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#protocol OrbitalContactProfile#protocol}
    */
    readonly protocol: string;
}
export declare function orbitalContactProfileLinksChannelsEndPointToTerraform(struct?: OrbitalContactProfileLinksChannelsEndPoint | cdktf.IResolvable): any;
export declare function orbitalContactProfileLinksChannelsEndPointToHclTerraform(struct?: OrbitalContactProfileLinksChannelsEndPoint | cdktf.IResolvable): any;
export declare class OrbitalContactProfileLinksChannelsEndPointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrbitalContactProfileLinksChannelsEndPoint | cdktf.IResolvable | undefined;
    set internalValue(value: OrbitalContactProfileLinksChannelsEndPoint | cdktf.IResolvable | undefined);
    private _endPointName?;
    get endPointName(): string;
    set endPointName(value: string);
    get endPointNameInput(): string | undefined;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    resetIpAddress(): void;
    get ipAddressInput(): string | undefined;
    private _port?;
    get port(): string;
    set port(value: string);
    get portInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
}
export declare class OrbitalContactProfileLinksChannelsEndPointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrbitalContactProfileLinksChannelsEndPoint[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrbitalContactProfileLinksChannelsEndPointOutputReference;
}
export interface OrbitalContactProfileLinksChannels {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#bandwidth_mhz OrbitalContactProfile#bandwidth_mhz}
    */
    readonly bandwidthMhz: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#center_frequency_mhz OrbitalContactProfile#center_frequency_mhz}
    */
    readonly centerFrequencyMhz: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#demodulation_configuration OrbitalContactProfile#demodulation_configuration}
    */
    readonly demodulationConfiguration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#modulation_configuration OrbitalContactProfile#modulation_configuration}
    */
    readonly modulationConfiguration?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#name OrbitalContactProfile#name}
    */
    readonly name: string;
    /**
    * end_point block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#end_point OrbitalContactProfile#end_point}
    */
    readonly endPoint: OrbitalContactProfileLinksChannelsEndPoint[] | cdktf.IResolvable;
}
export declare function orbitalContactProfileLinksChannelsToTerraform(struct?: OrbitalContactProfileLinksChannels | cdktf.IResolvable): any;
export declare function orbitalContactProfileLinksChannelsToHclTerraform(struct?: OrbitalContactProfileLinksChannels | cdktf.IResolvable): any;
export declare class OrbitalContactProfileLinksChannelsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrbitalContactProfileLinksChannels | cdktf.IResolvable | undefined;
    set internalValue(value: OrbitalContactProfileLinksChannels | cdktf.IResolvable | undefined);
    private _bandwidthMhz?;
    get bandwidthMhz(): number;
    set bandwidthMhz(value: number);
    get bandwidthMhzInput(): number | undefined;
    private _centerFrequencyMhz?;
    get centerFrequencyMhz(): number;
    set centerFrequencyMhz(value: number);
    get centerFrequencyMhzInput(): number | undefined;
    private _demodulationConfiguration?;
    get demodulationConfiguration(): string;
    set demodulationConfiguration(value: string);
    resetDemodulationConfiguration(): void;
    get demodulationConfigurationInput(): string | undefined;
    private _modulationConfiguration?;
    get modulationConfiguration(): string;
    set modulationConfiguration(value: string);
    resetModulationConfiguration(): void;
    get modulationConfigurationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _endPoint;
    get endPoint(): OrbitalContactProfileLinksChannelsEndPointList;
    putEndPoint(value: OrbitalContactProfileLinksChannelsEndPoint[] | cdktf.IResolvable): void;
    get endPointInput(): cdktf.IResolvable | OrbitalContactProfileLinksChannelsEndPoint[] | undefined;
}
export declare class OrbitalContactProfileLinksChannelsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrbitalContactProfileLinksChannels[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrbitalContactProfileLinksChannelsOutputReference;
}
export interface OrbitalContactProfileLinks {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#direction OrbitalContactProfile#direction}
    */
    readonly direction: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#name OrbitalContactProfile#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#polarization OrbitalContactProfile#polarization}
    */
    readonly polarization: string;
    /**
    * channels block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#channels OrbitalContactProfile#channels}
    */
    readonly channels: OrbitalContactProfileLinksChannels[] | cdktf.IResolvable;
}
export declare function orbitalContactProfileLinksToTerraform(struct?: OrbitalContactProfileLinks | cdktf.IResolvable): any;
export declare function orbitalContactProfileLinksToHclTerraform(struct?: OrbitalContactProfileLinks | cdktf.IResolvable): any;
export declare class OrbitalContactProfileLinksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OrbitalContactProfileLinks | cdktf.IResolvable | undefined;
    set internalValue(value: OrbitalContactProfileLinks | cdktf.IResolvable | undefined);
    private _direction?;
    get direction(): string;
    set direction(value: string);
    get directionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _polarization?;
    get polarization(): string;
    set polarization(value: string);
    get polarizationInput(): string | undefined;
    private _channels;
    get channels(): OrbitalContactProfileLinksChannelsList;
    putChannels(value: OrbitalContactProfileLinksChannels[] | cdktf.IResolvable): void;
    get channelsInput(): cdktf.IResolvable | OrbitalContactProfileLinksChannels[] | undefined;
}
export declare class OrbitalContactProfileLinksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: OrbitalContactProfileLinks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OrbitalContactProfileLinksOutputReference;
}
export interface OrbitalContactProfileTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#create OrbitalContactProfile#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#delete OrbitalContactProfile#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#read OrbitalContactProfile#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#update OrbitalContactProfile#update}
    */
    readonly update?: string;
}
export declare function orbitalContactProfileTimeoutsToTerraform(struct?: OrbitalContactProfileTimeouts | cdktf.IResolvable): any;
export declare function orbitalContactProfileTimeoutsToHclTerraform(struct?: OrbitalContactProfileTimeouts | cdktf.IResolvable): any;
export declare class OrbitalContactProfileTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): OrbitalContactProfileTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: OrbitalContactProfileTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile azurerm_orbital_contact_profile}
*/
export declare class OrbitalContactProfile extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_orbital_contact_profile";
    /**
    * Generates CDKTF code for importing a OrbitalContactProfile resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the OrbitalContactProfile to import
    * @param importFromId The id of the existing OrbitalContactProfile that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the OrbitalContactProfile to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/orbital_contact_profile azurerm_orbital_contact_profile} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OrbitalContactProfileConfig
    */
    constructor(scope: Construct, id: string, config: OrbitalContactProfileConfig);
    private _autoTracking?;
    get autoTracking(): string;
    set autoTracking(value: string);
    get autoTrackingInput(): string | undefined;
    private _eventHubUri?;
    get eventHubUri(): string;
    set eventHubUri(value: string);
    resetEventHubUri(): void;
    get eventHubUriInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _minimumElevationDegrees?;
    get minimumElevationDegrees(): number;
    set minimumElevationDegrees(value: number);
    resetMinimumElevationDegrees(): void;
    get minimumElevationDegreesInput(): number | undefined;
    private _minimumVariableContactDuration?;
    get minimumVariableContactDuration(): string;
    set minimumVariableContactDuration(value: string);
    get minimumVariableContactDurationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkConfigurationSubnetId?;
    get networkConfigurationSubnetId(): string;
    set networkConfigurationSubnetId(value: string);
    get networkConfigurationSubnetIdInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _links;
    get links(): OrbitalContactProfileLinksList;
    putLinks(value: OrbitalContactProfileLinks[] | cdktf.IResolvable): void;
    get linksInput(): cdktf.IResolvable | OrbitalContactProfileLinks[] | undefined;
    private _timeouts;
    get timeouts(): OrbitalContactProfileTimeoutsOutputReference;
    putTimeouts(value: OrbitalContactProfileTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | OrbitalContactProfileTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
