/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PaloAltoLocalRulestackOutboundUntrustCertificateAssociationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/palo_alto_local_rulestack_outbound_untrust_certificate_association#certificate_id PaloAltoLocalRulestackOutboundUntrustCertificateAssociation#certificate_id}
    */
    readonly certificateId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/palo_alto_local_rulestack_outbound_untrust_certificate_association#id PaloAltoLocalRulestackOutboundUntrustCertificateAssociation#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/palo_alto_local_rulestack_outbound_untrust_certificate_association#timeouts PaloAltoLocalRulestackOutboundUntrustCertificateAssociation#timeouts}
    */
    readonly timeouts?: PaloAltoLocalRulestackOutboundUntrustCertificateAssociationTimeouts;
}
export interface PaloAltoLocalRulestackOutboundUntrustCertificateAssociationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/palo_alto_local_rulestack_outbound_untrust_certificate_association#create PaloAltoLocalRulestackOutboundUntrustCertificateAssociation#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/palo_alto_local_rulestack_outbound_untrust_certificate_association#delete PaloAltoLocalRulestackOutboundUntrustCertificateAssociation#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/palo_alto_local_rulestack_outbound_untrust_certificate_association#read PaloAltoLocalRulestackOutboundUntrustCertificateAssociation#read}
    */
    readonly read?: string;
}
export declare function paloAltoLocalRulestackOutboundUntrustCertificateAssociationTimeoutsToTerraform(struct?: PaloAltoLocalRulestackOutboundUntrustCertificateAssociationTimeouts | cdktf.IResolvable): any;
export declare function paloAltoLocalRulestackOutboundUntrustCertificateAssociationTimeoutsToHclTerraform(struct?: PaloAltoLocalRulestackOutboundUntrustCertificateAssociationTimeouts | cdktf.IResolvable): any;
export declare class PaloAltoLocalRulestackOutboundUntrustCertificateAssociationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PaloAltoLocalRulestackOutboundUntrustCertificateAssociationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PaloAltoLocalRulestackOutboundUntrustCertificateAssociationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/palo_alto_local_rulestack_outbound_untrust_certificate_association azurerm_palo_alto_local_rulestack_outbound_untrust_certificate_association}
*/
export declare class PaloAltoLocalRulestackOutboundUntrustCertificateAssociation extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_palo_alto_local_rulestack_outbound_untrust_certificate_association";
    /**
    * Generates CDKTF code for importing a PaloAltoLocalRulestackOutboundUntrustCertificateAssociation resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the PaloAltoLocalRulestackOutboundUntrustCertificateAssociation to import
    * @param importFromId The id of the existing PaloAltoLocalRulestackOutboundUntrustCertificateAssociation that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/palo_alto_local_rulestack_outbound_untrust_certificate_association#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the PaloAltoLocalRulestackOutboundUntrustCertificateAssociation to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/palo_alto_local_rulestack_outbound_untrust_certificate_association azurerm_palo_alto_local_rulestack_outbound_untrust_certificate_association} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PaloAltoLocalRulestackOutboundUntrustCertificateAssociationConfig
    */
    constructor(scope: Construct, id: string, config: PaloAltoLocalRulestackOutboundUntrustCertificateAssociationConfig);
    private _certificateId?;
    get certificateId(): string;
    set certificateId(value: string);
    get certificateIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _timeouts;
    get timeouts(): PaloAltoLocalRulestackOutboundUntrustCertificateAssociationTimeoutsOutputReference;
    putTimeouts(value: PaloAltoLocalRulestackOutboundUntrustCertificateAssociationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PaloAltoLocalRulestackOutboundUntrustCertificateAssociationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
