/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecurityCenterAssessmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#additional_data SecurityCenterAssessment#additional_data}
    */
    readonly additionalData?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#assessment_policy_id SecurityCenterAssessment#assessment_policy_id}
    */
    readonly assessmentPolicyId: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#id SecurityCenterAssessment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#target_resource_id SecurityCenterAssessment#target_resource_id}
    */
    readonly targetResourceId: string;
    /**
    * status block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#status SecurityCenterAssessment#status}
    */
    readonly status: SecurityCenterAssessmentStatus;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#timeouts SecurityCenterAssessment#timeouts}
    */
    readonly timeouts?: SecurityCenterAssessmentTimeouts;
}
export interface SecurityCenterAssessmentStatus {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#cause SecurityCenterAssessment#cause}
    */
    readonly cause?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#code SecurityCenterAssessment#code}
    */
    readonly code: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#description SecurityCenterAssessment#description}
    */
    readonly description?: string;
}
export declare function securityCenterAssessmentStatusToTerraform(struct?: SecurityCenterAssessmentStatusOutputReference | SecurityCenterAssessmentStatus): any;
export declare function securityCenterAssessmentStatusToHclTerraform(struct?: SecurityCenterAssessmentStatusOutputReference | SecurityCenterAssessmentStatus): any;
export declare class SecurityCenterAssessmentStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityCenterAssessmentStatus | undefined;
    set internalValue(value: SecurityCenterAssessmentStatus | undefined);
    private _cause?;
    get cause(): string;
    set cause(value: string);
    resetCause(): void;
    get causeInput(): string | undefined;
    private _code?;
    get code(): string;
    set code(value: string);
    get codeInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
}
export interface SecurityCenterAssessmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#create SecurityCenterAssessment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#delete SecurityCenterAssessment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#read SecurityCenterAssessment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#update SecurityCenterAssessment#update}
    */
    readonly update?: string;
}
export declare function securityCenterAssessmentTimeoutsToTerraform(struct?: SecurityCenterAssessmentTimeouts | cdktf.IResolvable): any;
export declare function securityCenterAssessmentTimeoutsToHclTerraform(struct?: SecurityCenterAssessmentTimeouts | cdktf.IResolvable): any;
export declare class SecurityCenterAssessmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecurityCenterAssessmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SecurityCenterAssessmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment azurerm_security_center_assessment}
*/
export declare class SecurityCenterAssessment extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_security_center_assessment";
    /**
    * Generates CDKTF code for importing a SecurityCenterAssessment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecurityCenterAssessment to import
    * @param importFromId The id of the existing SecurityCenterAssessment that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecurityCenterAssessment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.93.0/docs/resources/security_center_assessment azurerm_security_center_assessment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecurityCenterAssessmentConfig
    */
    constructor(scope: Construct, id: string, config: SecurityCenterAssessmentConfig);
    private _additionalData?;
    get additionalData(): {
        [key: string]: string;
    };
    set additionalData(value: {
        [key: string]: string;
    });
    resetAdditionalData(): void;
    get additionalDataInput(): {
        [key: string]: string;
    } | undefined;
    private _assessmentPolicyId?;
    get assessmentPolicyId(): string;
    set assessmentPolicyId(value: string);
    get assessmentPolicyIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _targetResourceId?;
    get targetResourceId(): string;
    set targetResourceId(value: string);
    get targetResourceIdInput(): string | undefined;
    private _status;
    get status(): SecurityCenterAssessmentStatusOutputReference;
    putStatus(value: SecurityCenterAssessmentStatus): void;
    get statusInput(): SecurityCenterAssessmentStatus | undefined;
    private _timeouts;
    get timeouts(): SecurityCenterAssessmentTimeoutsOutputReference;
    putTimeouts(value: SecurityCenterAssessmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SecurityCenterAssessmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
